/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.junit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.checker.CheckerLiterals;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.junit.EarlReport;
import org.apache.jena.sparql.junit.EarlTestCase;
import org.apache.jena.sparql.vocabulary.TestManifestUpdate_11;
import org.apache.jena.update.UpdateAction;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.junit.TestUtils;
import org.apache.jena.vocabulary.RDFS;

public class UpdateTest
extends EarlTestCase {
    private Resource action;
    private Resource result;
    private String updateFile;
    private Dataset input;
    private Dataset output;
    private boolean oldWarningFlag;

    public static UpdateTest create(String testName, EarlReport earl, Resource entry, Resource action, Resource result) {
        if (!action.hasProperty(TestManifestUpdate_11.request)) {
            System.err.println("No request in action: " + testName);
            return null;
        }
        return new UpdateTest(testName, earl, entry, action, result);
    }

    private UpdateTest(String testName, EarlReport earl, Resource entry, Resource action, Resource result) {
        super(TestUtils.safeName((String)testName), entry.getURI(), earl);
        this.action = action;
        this.result = result;
        this.updateFile = action.getProperty(TestManifestUpdate_11.request).getResource().getURI();
    }

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.oldWarningFlag = CheckerLiterals.WarnOnBadLiterals;
        this.input = UpdateTest.getDataset(this.action);
        this.output = UpdateTest.getDataset(this.result);
    }

    @Override
    public void tearDownTest() {
        CheckerLiterals.WarnOnBadLiterals = this.oldWarningFlag;
        this.input = null;
        this.output = null;
        super.tearDownTest();
    }

    @Override
    protected void runTestForReal() {
        try {
            UpdateRequest request = UpdateFactory.read((String)this.updateFile, (Syntax)Syntax.syntaxSPARQL_11);
            UpdateAction.execute((UpdateRequest)request, (Dataset)this.input);
            boolean b = this.datasetSame(this.input, this.output, false);
            if (!b) {
                System.out.println("---- " + this.getName());
                System.out.println("---- Got: ");
                System.out.println(this.input.asDatasetGraph());
                System.out.println("---- Expected");
                System.out.println(this.output.asDatasetGraph());
                this.datasetSame(this.input, this.output, true);
                System.out.println("----------------------------------------");
            }
            UpdateTest.assertTrue((String)"Datasets are different", (boolean)b);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
    }

    private boolean datasetSame(Dataset ds1, Dataset ds2, boolean verbose) {
        List names2;
        List names1 = Iter.toList((Iterator)ds1.listNames());
        if (!names1.equals(names2 = Iter.toList((Iterator)ds2.listNames()))) {
            if (verbose) {
                System.out.println("Different named graphs");
                System.out.println("  " + names1);
                System.out.println("  " + names2);
            }
            return false;
        }
        if (!ds1.getDefaultModel().isIsomorphicWith(ds2.getDefaultModel())) {
            if (verbose) {
                System.out.println("Default graphs differ");
            }
            return false;
        }
        for (String gn : names1) {
            Model m2;
            Model m1 = ds1.getNamedModel(gn);
            if (m1.isIsomorphicWith(m2 = ds2.getNamedModel(gn))) continue;
            if (verbose) {
                System.out.println("Different on named graph " + gn);
            }
            return false;
        }
        return true;
    }

    static Dataset getDataset(Resource r) {
        DatasetGraph dsg = DatasetGraphFactory.create();
        Dataset ds = DatasetFactory.wrap((DatasetGraph)dsg);
        List<String> dftData = UpdateTest.getAll(r, TestManifestUpdate_11.data);
        for (String x : dftData) {
            FileManager.get().readModel(ds.getDefaultModel(), x);
        }
        StmtIterator cIter = r.listProperties(TestManifestUpdate_11.graphData);
        while (cIter.hasNext()) {
            Statement stmt = (Statement)cIter.next();
            Resource gn = stmt.getResource();
            if (gn.isAnon()) {
                if (!gn.hasProperty(TestManifestUpdate_11.graph)) {
                    System.err.println("No data for graphData");
                }
                String fn = gn.getProperty(TestManifestUpdate_11.graph).getResource().getURI();
                String name = gn.getProperty(RDFS.label).getString();
                Model m = FileManager.get().loadModel(fn);
                ds.addNamedModel(name, m);
                continue;
            }
            String x = gn.getURI();
            Model m = FileManager.get().loadModel(x);
            ds.addNamedModel(x, m);
        }
        cIter.close();
        return ds;
    }

    static List<String> getAll(Resource r, Property p) {
        ArrayList<String> l = new ArrayList<String>();
        StmtIterator cIter = r.listProperties(p);
        while (cIter.hasNext()) {
            Statement stmt = (Statement)cIter.next();
            String df = stmt.getObject().asResource().getURI();
            l.add(df);
        }
        cIter.close();
        return l;
    }
}

