/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify;

import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.update.UpdateAction;

public abstract class AbstractTestUpdateBase
extends BaseTest {
    protected static final String FileBase = "testing/Update";

    protected abstract DatasetGraph getEmptyDatasetGraph();

    protected void defaultGraphData(DatasetGraph gStore, Graph data) {
        Graph g = gStore.getDefaultGraph();
        g.clear();
        GraphUtil.addInto((Graph)g, (Graph)data);
    }

    protected void namedGraphData(DatasetGraph gStore, Node uri, Graph data) {
        Graph g = gStore.getGraph(uri);
        if (g == null) {
            gStore.addGraph(uri, GraphFactory.createJenaDefaultGraph());
            g = gStore.getGraph(uri);
        } else {
            g.clear();
        }
        GraphUtil.addInto((Graph)g, (Graph)data);
    }

    protected static void script(DatasetGraph gStore, String filename) {
        UpdateAction.readExecute((String)("testing/Update/" + filename), (DatasetGraph)gStore);
    }

    protected static boolean graphEmpty(Graph graph) {
        return graph.isEmpty();
    }

    protected static boolean graphContains(Graph graph, Triple triple) {
        return graph.contains(triple);
    }
}

