/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify;

import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.sparql.modify.request.UpdateWriter;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.junit.Test;

public class TestUpdateWriter
extends BaseTest {
    @Test
    public void updateWrite01() {
        this.test("INSERT DATA {}");
    }

    @Test
    public void updateWrite02() {
        this.test("PREFIX : <http://example/> INSERT DATA { <s> :p 123 }");
    }

    @Test
    public void updateWrite03() {
        this.test("PREFIX : <http://example/> INSERT DATA { _:a :p 123 , 456 }");
    }

    @Test
    public void updateWrite04() {
        this.test("PREFIX : <http://example/> INSERT DATA { _:a :p 123 ; :q 456 }");
    }

    @Test
    public void updateWrite05() {
        this.test("DELETE {<s> <p> ?v } INSERT {<s> <p> _:x } WHERE {?v <p> _:x }");
    }

    @Test
    public void updateWrite06() {
        this.test("INSERT {<s> <p> ?v } WHERE {?v <p> 123}");
    }

    @Test
    public void updateWrite07() {
        this.test("DELETE {<s> <p> ?v} WHERE {?v <p> 123}");
    }

    @Test
    public void updateWrite08() {
        this.test("DELETE WHERE {?v <p> 123}");
    }

    @Test
    public void updateWrite09() {
        this.test("DELETE { ?w <q> 56 } INSERT {?v <p> 123} WHERE { _:a ?p _:b }");
    }

    @Test
    public void updateWrite10() {
        this.test("INSERT {} WHERE { ?x ?p [ ?a  ?b ] }");
    }

    @Test
    public void updateWrite20() {
        this.test("PREFIX : <http://example/> DELETE {} INSERT {} WHERE {}");
    }

    @Test
    public void updateWrite21() {
        this.test("PREFIX : <http://example/> DELETE {} INSERT {} USING :G WHERE {}");
    }

    @Test
    public void updateWrite22() {
        this.test("PREFIX : <http://example/> DELETE {} INSERT {} USING NAMED :GN WHERE {}");
    }

    @Test
    public void updateWrite23() {
        this.test("PREFIX : <http://example/> WITH :ABC DELETE {} INSERT {} WHERE {}");
    }

    private void test(String updateString) {
        UpdateRequest update1 = UpdateFactory.create((String)updateString);
        IndentedLineBuffer w = new IndentedLineBuffer();
        UpdateWriter.output((UpdateRequest)update1, (IndentedWriter)w);
        String s = w.asString();
        UpdateRequest update2 = UpdateFactory.create((String)s);
        TestUpdateWriter.assertTrue((boolean)update1.equalTo(update2));
    }
}

