/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.rw.ResultsReader;
import org.apache.jena.riot.resultset.rw.ResultsWriter;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ResultSetStream;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.resultset.RDFInput;
import org.apache.jena.sparql.resultset.RDFOutput;
import org.apache.jena.sparql.resultset.ResultSetCompare;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.resultset.ResultSetMem;
import org.apache.jena.sparql.resultset.ResultSetPeekable;
import org.apache.jena.sparql.resultset.ResultSetPeeking;
import org.apache.jena.sparql.resultset.ResultsFormat;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.builders.BuilderResultSet;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.sparql.util.ResultSetUtils;
import org.apache.jena.sys.JenaSystem;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestResultSet
extends BaseTest {
    private static String DIR;
    private static String[] rs1$;
    private static String[] rs2$;
    static Context cxt;

    @BeforeClass
    public static void setup() {
        ResultSetPeeking.warnOnSyncErrors = false;
    }

    @AfterClass
    public static void teardown() {
        ResultSetPeeking.warnOnSyncErrors = true;
    }

    @Test
    public void test_RS_1() {
        ResultSetMem rs1 = new ResultSetMem();
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsXML((OutputStream)arr, (ResultSet)rs1);
        rs1.reset();
        ByteArrayInputStream ins = new ByteArrayInputStream(arr.toByteArray());
        ResultSet rs2 = ResultSetFactory.fromXML((InputStream)ins);
        TestResultSet.assertTrue((boolean)ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2));
    }

    @Test
    public void test_RS_1_str() {
        ResultSetMem rs1 = new ResultSetMem();
        String x = ResultSetFormatter.asXMLString((ResultSet)rs1);
        rs1.reset();
        ByteArrayInputStream in = new ByteArrayInputStream(StrUtils.asUTF8bytes((String)x));
        ResultSet rs2 = ResultSetFactory.fromXML((InputStream)in);
        TestResultSet.assertTrue((boolean)ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2));
    }

    @Test
    public void test_RS_2() {
        ResultSetRewindable rs1 = this.makeRewindable("x", NodeFactory.createURI((String)"tag:local"));
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsXML((OutputStream)arr, (ResultSet)rs1);
        rs1.reset();
        ByteArrayInputStream ins = new ByteArrayInputStream(arr.toByteArray());
        ResultSet rs2 = ResultSetFactory.fromXML((InputStream)ins);
        TestResultSet.assertTrue((boolean)ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2));
    }

    @Test
    public void test_RS_2_str() {
        ResultSetRewindable rs1 = this.makeRewindable("x", NodeFactory.createURI((String)"tag:local"));
        String x = ResultSetFormatter.asXMLString((ResultSet)rs1);
        rs1.reset();
        ByteArrayInputStream in = new ByteArrayInputStream(StrUtils.asUTF8bytes((String)x));
        ResultSet rs2 = ResultSetFactory.fromXML((InputStream)in);
        TestResultSet.assertTrue((boolean)ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2));
    }

    @Test
    public void test_RS_3() {
        ResultSetMem rs1 = new ResultSetMem();
        Model model = RDFOutput.encodeAsModel((ResultSet)rs1);
        rs1.reset();
        ResultSet rs2 = RDFInput.fromRDF((Model)model);
        TestResultSet.assertTrue((boolean)ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2));
    }

    @Test
    public void test_RS_4() {
        ResultSetRewindable rs1 = this.makeRewindable("x", NodeFactory.createURI((String)"tag:local"));
        Model model = RDFOutput.encodeAsModel((ResultSet)rs1);
        rs1.reset();
        ResultSetRewindable rs2 = ResultSetFactory.makeRewindable((ResultSet)RDFInput.fromRDF((Model)model));
        boolean b = ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2);
        if (!b) {
            rs1.reset();
            rs2.reset();
            ResultSetFormatter.out((ResultSet)rs1);
            ResultSetFormatter.out((ResultSet)rs2);
        }
        TestResultSet.assertTrue((boolean)b);
    }

    @Test
    public void test_RS_5() {
        ResultSetMem rs1 = new ResultSetMem();
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON((OutputStream)arr, (ResultSet)rs1);
        rs1.reset();
        ByteArrayInputStream ins = new ByteArrayInputStream(arr.toByteArray());
        ResultSet rs2 = ResultSetFactory.fromJSON((InputStream)ins);
        TestResultSet.assertTrue((boolean)ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2));
    }

    @Test
    public void test_RS_6() {
        ResultSetRewindable rs1 = this.make2Rewindable("x", NodeFactory.createURI((String)"tag:local"));
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON((OutputStream)arr, (ResultSet)rs1);
        rs1.reset();
        ByteArrayInputStream ins = new ByteArrayInputStream(arr.toByteArray());
        ResultSet rs2 = ResultSetFactory.fromJSON((InputStream)ins);
        TestResultSet.assertTrue((boolean)ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2));
    }

    @Test
    public void test_RS_7() {
        ResultSet rs = ResultSetFactory.load((String)(DIR + "output.srx"));
        this.test_RS_fmt(rs, ResultsFormat.FMT_RS_XML, true);
    }

    @Test
    public void test_RS_8() {
        ResultSet rs = ResultSetFactory.load((String)(DIR + "output.srx"));
        this.test_RS_fmt(rs, ResultsFormat.FMT_RS_JSON, true);
    }

    @Test
    public void test_RS_9() {
        ResultSet rs = ResultSetFactory.load((String)(DIR + "output.srx"));
        this.test_RS_fmt(rs, ResultsFormat.FMT_RDF_XML, false);
    }

    @Test
    public void test_RS_10() {
        ResultSet rs = ResultSetFactory.load((String)(DIR + "output.srx"));
        while (rs.hasNext()) {
            rs.next();
        }
        TestResultSet.assertFalse((boolean)rs.hasNext());
    }

    @Test
    public void rs_xmllang_datatype_1() {
        ResultSetFactory.load((String)(DIR + "rs-xmllang-datatype-1.srj"));
    }

    @Test(expected=ResultSetException.class)
    public void rs_xmllang_datatype_2() {
        ResultSetFactory.load((String)(DIR + "rs-xmllang-datatype-2.srj"));
    }

    @Test
    public void rs_datatype_string() {
        ResultSet rs = ResultSetFactory.load((String)(DIR + "rs-datatype-string.srj"));
    }

    @Test
    public void test_RS_union_1() {
        ResultSet rs1 = this.make("x", NodeFactory.createURI((String)"tag:local"));
        ResultSet rs2 = this.make("x", NodeFactory.createURI((String)"tag:local"));
        ResultSet rs3 = this.make2("x", NodeFactory.createURI((String)"tag:local"));
        TestResultSet.assertTrue((boolean)ResultSetCompare.equalsByTerm((ResultSet)rs3, (ResultSet)ResultSetUtils.union((ResultSet[])new ResultSet[]{rs1, rs2})));
    }

    @Test(expected=ResultSetException.class)
    public void test_RS_union_2() {
        ResultSet rs1 = this.make("x", NodeFactory.createURI((String)"tag:local"));
        ResultSet rs2 = this.make("y", NodeFactory.createURI((String)"tag:local"));
        ResultSetUtils.union((ResultSet[])new ResultSet[]{rs1, rs2});
    }

    private void test_RS_fmt(ResultSet rs, ResultsFormat fmt, boolean ordered) {
        ResultSetRewindable rs1 = ResultSetFactory.makeRewindable((ResultSet)rs);
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.output((OutputStream)arr, (ResultSet)rs1, (ResultsFormat)fmt);
        byte[] bytes = arr.toByteArray();
        rs1.reset();
        ByteArrayInputStream ins = new ByteArrayInputStream(bytes);
        ResultSetRewindable rs2 = ResultSetFactory.makeRewindable((ResultSet)ResultSetFactory.load((InputStream)ins, (ResultsFormat)fmt));
        boolean b = ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2);
        if (ordered) {
            rs1.reset();
            rs2.reset();
            b &= ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2);
        }
        if (!b) {
            System.out.println(new String(bytes));
            rs1.reset();
            rs2.reset();
            ResultSetFormatter.out((ResultSet)rs1);
            ResultSetFormatter.out((ResultSet)rs2);
        }
        TestResultSet.assertTrue((boolean)b);
    }

    @Test
    public void test_RS_cmp_1() {
        ResultSetMem rs1 = new ResultSetMem();
        ResultSetMem rs2 = new ResultSetMem();
        TestResultSet.assertTrue((boolean)ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2));
        rs1.reset();
        rs2.reset();
        TestResultSet.assertTrue((boolean)ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2));
    }

    @Test
    public void test_RS_cmp_2() {
        ResultSet rs1 = this.make("x", NodeFactory.createURI((String)"tag:local"));
        ResultSetMem rs2 = new ResultSetMem();
        TestResultSet.assertFalse((boolean)ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2));
    }

    @Test
    public void test_RS_cmp_3() {
        ResultSet rs1 = this.make("x", NodeFactory.createURI((String)"tag:local"));
        ResultSetMem rs2 = new ResultSetMem();
        TestResultSet.assertFalse((boolean)ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2));
    }

    @Test
    public void test_RS_cmp_4() {
        ResultSet rs1 = this.make("x", NodeFactory.createURI((String)"tag:local"));
        ResultSet rs2 = this.make("x", NodeFactory.createURI((String)"tag:local"));
        TestResultSet.assertTrue((boolean)ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2));
        TestResultSet.assertTrue((boolean)ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2));
    }

    @Test
    public void test_RS_cmp_5() {
        ResultSetRewindable rs1 = this.makeRewindable("x", NodeFactory.createURI((String)"tag:local:1"));
        ResultSetRewindable rs2 = this.makeRewindable("x", NodeFactory.createURI((String)"tag:local:2"));
        TestResultSet.assertFalse((boolean)ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2));
        rs1.reset();
        rs2.reset();
        TestResultSet.assertFalse((boolean)ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2));
    }

    @Test
    public void test_RS_cmp_6() {
        ResultSetRewindable rs1 = this.makeRewindable("x", NodeFactory.createURI((String)"tag:local"));
        ResultSetRewindable rs2 = this.makeRewindable("y", NodeFactory.createURI((String)"tag:local"));
        TestResultSet.assertFalse((boolean)ResultSetCompare.equalsByTermAndOrder((ResultSet)rs1, (ResultSet)rs2));
        rs1.reset();
        rs2.reset();
        TestResultSet.assertFalse((boolean)ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2));
    }

    @Test
    public void test_RS_cmp_value_1() {
        ResultSetRewindable rs1 = this.makeRewindable("x", NodeFactoryExtra.parseNode((String)"123"));
        ResultSetRewindable rs2 = this.makeRewindable("x", NodeFactoryExtra.parseNode((String)"0123"));
        TestResultSet.assertFalse((boolean)ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2));
        TestResultSet.assertTrue((boolean)ResultSetCompare.equalsByValue((ResultSet)rs1, (ResultSet)rs2));
    }

    @Test
    public void test_RS_peeking_1() {
        ResultSetPeekable rs = this.makePeekable("x", NodeFactory.createURI((String)"tag:local"));
        TestResultSet.assertTrue((boolean)rs.hasNext());
        TestResultSet.assertNotNull((Object)rs.peek());
        TestResultSet.assertTrue((boolean)rs.hasNext());
        TestResultSet.assertNotNull((Object)rs.next());
        TestResultSet.assertFalse((boolean)rs.hasNext());
    }

    @Test(expected=NoSuchElementException.class)
    public void test_RS_peeking_2() {
        ResultSetPeekable rs = this.makePeekable("x", NodeFactory.createURI((String)"tag:local"));
        TestResultSet.assertTrue((boolean)rs.hasNext());
        TestResultSet.assertNotNull((Object)rs.peek());
        TestResultSet.assertTrue((boolean)rs.hasNext());
        TestResultSet.assertNotNull((Object)rs.next());
        TestResultSet.assertFalse((boolean)rs.hasNext());
        rs.peek();
    }

    @Test
    public void test_RS_peeking_3() {
        ResultSetPeekable rs = (ResultSetPeekable)this.makeRewindable("x", NodeFactory.createURI((String)"tag:local"));
        TestResultSet.assertTrue((boolean)rs.hasNext());
        TestResultSet.assertNotNull((Object)rs.peek());
        TestResultSet.assertTrue((boolean)rs.hasNext());
        TestResultSet.assertNotNull((Object)rs.next());
        TestResultSet.assertFalse((boolean)rs.hasNext());
    }

    @Test(expected=NoSuchElementException.class)
    public void test_RS_peeking_4() {
        ResultSetPeekable rs = (ResultSetPeekable)this.makeRewindable("x", NodeFactory.createURI((String)"tag:local"));
        TestResultSet.assertTrue((boolean)rs.hasNext());
        TestResultSet.assertNotNull((Object)rs.peek());
        TestResultSet.assertTrue((boolean)rs.hasNext());
        TestResultSet.assertNotNull((Object)rs.next());
        TestResultSet.assertFalse((boolean)rs.hasNext());
        rs.peek();
    }

    @Test
    public void test_RS_peeking_5() {
        ResultSetMem inner = new ResultSetMem(new ResultSet[]{this.make("x", NodeFactory.createURI((String)"tag:local")), this.make("x", NodeFactory.createURI((String)"tag:local"))});
        ResultSetPeekable rs = ResultSetFactory.makePeekable((ResultSet)inner);
        TestResultSet.assertTrue((boolean)rs.hasNext());
        TestResultSet.assertNotNull((Object)rs.peek());
        inner.next();
        TestResultSet.assertFalse((boolean)rs.hasNext());
    }

    @Test
    public void test_RS_peeking_6() {
        ResultSetMem inner = new ResultSetMem(new ResultSet[]{this.make("x", NodeFactory.createURI((String)"tag:local")), this.make("x", NodeFactory.createURI((String)"tag:local")), this.make("x", NodeFactory.createURI((String)"tag:local"))});
        ResultSetPeekable rs = ResultSetFactory.makePeekable((ResultSet)inner);
        TestResultSet.assertTrue((boolean)rs.hasNext());
        TestResultSet.assertNotNull((Object)rs.peek());
        inner.next();
        TestResultSet.assertTrue((boolean)rs.hasNext());
    }

    @Test
    public void test_RS_peeking_7() {
        ResultSetRewindable inner = this.makeRewindable("x", NodeFactory.createURI((String)"tag:local"));
        ResultSetPeekable rs = ResultSetFactory.makePeekable((ResultSet)inner);
        TestResultSet.assertTrue((boolean)rs.hasNext());
        TestResultSet.assertNotNull((Object)rs.peek());
        inner.reset();
        TestResultSet.assertTrue((boolean)rs.hasNext());
    }

    @Test(expected=IllegalStateException.class)
    public void test_RS_peeking_8() {
        ResultSetMem inner = new ResultSetMem(new ResultSet[]{this.make("x", NodeFactory.createURI((String)"tag:local")), this.make("x", NodeFactory.createURI((String)"tag:local"))});
        ResultSetPeekable rs = ResultSetFactory.makePeekable((ResultSet)inner);
        TestResultSet.assertTrue((boolean)rs.hasNext());
        TestResultSet.assertNotNull((Object)rs.peek());
        TestResultSet.assertNotNull((Object)rs.next());
        inner.reset();
        rs.hasNext();
    }

    @Test
    public void test_RS_peeking_9() {
        Node first = NodeFactory.createURI((String)"tag:first");
        Node second = NodeFactory.createURI((String)"tag:second");
        Var x = Var.alloc((String)"x");
        ResultSetMem inner = new ResultSetMem(new ResultSet[]{this.make("x", first), this.make("x", second)});
        ResultSetPeekable rs = ResultSetFactory.makePeekable((ResultSet)inner);
        TestResultSet.assertTrue((boolean)rs.hasNext());
        Binding peeked = rs.peekBinding();
        TestResultSet.assertNotNull((Object)peeked);
        TestResultSet.assertTrue((boolean)first.equals((Object)peeked.get(x)));
        Binding next = rs.nextBinding();
        TestResultSet.assertNotNull((Object)next);
        TestResultSet.assertTrue((boolean)first.equals((Object)next.get(x)));
        peeked = rs.peekBinding();
        TestResultSet.assertNotNull((Object)peeked);
        TestResultSet.assertTrue((boolean)second.equals((Object)peeked.get(x)));
        next = rs.nextBinding();
        TestResultSet.assertNotNull((Object)next);
        TestResultSet.assertTrue((boolean)second.equals((Object)next.get(x)));
    }

    @Test
    public void test_RS_iso_1() {
        this.isotest(rs1$, rs2$);
    }

    private void isotest(String[] rs1$2, String[] rs2$2) {
        ResultSetRewindable rs1 = ResultSetFactory.makeRewindable((ResultSet)BuilderResultSet.build((Item)SSE.parseItem((String)StrUtils.strjoinNL((String[])rs1$))));
        ResultSetRewindable rs2 = ResultSetFactory.makeRewindable((ResultSet)BuilderResultSet.build((Item)SSE.parseItem((String)StrUtils.strjoinNL((String[])rs2$))));
        TestResultSet.assertTrue((boolean)ResultSetCompare.isomorphic((ResultSet)rs1, (ResultSet)rs2));
        rs1.reset();
        rs2.reset();
        TestResultSet.assertTrue((boolean)ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2));
        TestResultSet.assertTrue((boolean)ResultSetCompare.equalsByValue((ResultSet)rs1, (ResultSet)rs2));
    }

    @Test
    public void preserve_bnodes_1() {
        TestResultSet.preserve_bnodes(ResultSetLang.SPARQLResultSetJSON, cxt, true);
        TestResultSet.preserve_bnodes(ResultSetLang.SPARQLResultSetJSON, ARQ.getContext(), false);
    }

    @Test
    public void preserve_bnodes_2() {
        TestResultSet.preserve_bnodes(ResultSetLang.SPARQLResultSetXML, cxt, true);
        TestResultSet.preserve_bnodes(ResultSetLang.SPARQLResultSetXML, ARQ.getContext(), false);
    }

    @Test
    public void preserve_bnodes_3() {
        TestResultSet.preserve_bnodes(ResultSetLang.SPARQLResultSetThrift, cxt, true);
        TestResultSet.preserve_bnodes(ResultSetLang.SPARQLResultSetThrift, ARQ.getContext(), true);
    }

    private static void preserve_bnodes(Lang sparqlresultlang, Context cxt, boolean same) {
        ResultSetRewindable rs1 = ResultSetFactory.makeRewindable((ResultSet)BuilderResultSet.build((Item)SSE.parseItem((String)StrUtils.strjoinNL((String[])rs1$))));
        ByteArrayOutputStream x = new ByteArrayOutputStream();
        ResultsWriter.create().context(cxt).lang(sparqlresultlang).write((OutputStream)x, (ResultSet)rs1);
        ByteArrayInputStream y = new ByteArrayInputStream(x.toByteArray());
        ResultSetRewindable rs2 = ResultSetFactory.copyResults((ResultSet)ResultsReader.create().context(cxt).lang(sparqlresultlang).read((InputStream)y));
        rs1.reset();
        rs2.reset();
        if (same) {
            TestResultSet.assertTrue((boolean)ResultSetCompare.equalsExact((ResultSet)rs1, (ResultSet)rs2));
        } else {
            TestResultSet.assertFalse((boolean)ResultSetCompare.equalsExact((ResultSet)rs1, (ResultSet)rs2));
        }
    }

    private ResultSet make(String var, Node val) {
        BindingMap b = BindingFactory.create();
        b.add(Var.alloc((String)var), val);
        ArrayList<String> vars = new ArrayList<String>();
        vars.add(var);
        QueryIterSingleton qIter = QueryIterSingleton.create((Binding)b, null);
        ResultSetStream rs = new ResultSetStream(vars, null, (Iterator)qIter);
        return rs;
    }

    private ResultSet make2(String var, Node val) {
        BindingMap b1 = BindingFactory.create();
        b1.add(Var.alloc((String)var), val);
        BindingMap b2 = BindingFactory.create();
        b2.add(Var.alloc((String)var), val);
        ArrayList<String> vars = new ArrayList<String>();
        vars.add(var);
        ArrayList<BindingMap> solutions = new ArrayList<BindingMap>();
        solutions.add(b1);
        solutions.add(b2);
        QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(solutions.iterator(), null);
        ResultSetStream rs = new ResultSetStream(vars, null, (Iterator)qIter);
        return rs;
    }

    private ResultSetRewindable makeRewindable(String var, Node val) {
        ResultSet rs = this.make(var, val);
        ResultSetRewindable rsw = ResultSetFactory.makeRewindable((ResultSet)rs);
        return rsw;
    }

    private ResultSetRewindable make2Rewindable(String var, Node val) {
        ResultSet rs = this.make2(var, val);
        ResultSetRewindable rsw = ResultSetFactory.makeRewindable((ResultSet)rs);
        return rsw;
    }

    private ResultSet make(String var1, Node val1, String var2, Node val2) {
        BindingMap b = BindingFactory.create();
        b.add(Var.alloc((String)var1), val1);
        b.add(Var.alloc((String)var2), val2);
        ArrayList<String> vars = new ArrayList<String>();
        vars.add(var1);
        vars.add(var2);
        QueryIterSingleton qIter = QueryIterSingleton.create((Binding)b, null);
        ResultSetStream rs = new ResultSetStream(vars, null, (Iterator)qIter);
        return rs;
    }

    private ResultSetRewindable makeRewindable(String var1, Node val1, String var2, Node val2) {
        ResultSet rs = this.make(var1, val1, var2, val2);
        ResultSetRewindable rsw = ResultSetFactory.makeRewindable((ResultSet)rs);
        return rsw;
    }

    private ResultSetPeekable makePeekable(String var, Node val) {
        ResultSet rs = this.make(var, val);
        ResultSetPeekable rsp = ResultSetFactory.makePeekable((ResultSet)rs);
        return rsp;
    }

    private ResultSetPeekable make2Peekable(String var1, Node val1, String var2, Node val2) {
        ResultSet rs = this.make(var1, val1, var2, val2);
        ResultSetPeekable rsp = ResultSetFactory.makePeekable((ResultSet)rs);
        return rsp;
    }

    static {
        JenaSystem.init();
        DIR = "testing/ResultSet/";
        rs1$ = new String[]{"(resultset (?x ?y)", "   (row (?x _:b0) (?y _:b1))", "   (row (?x _:b2) (?y _:b3))", "   (row (?x _:b1) (?y _:b0))", ")"};
        rs2$ = new String[]{"(resultset (?x ?y)", "   (row (?x _:c1) (?y _:c0))", "   (row (?x _:c3) (?y _:c2))", "   (row (?x _:c2) (?y _:c3))", ")"};
        cxt = new Context();
        cxt.set(ARQ.inputGraphBNodeLabels, true);
        cxt.set(ARQ.outputGraphBNodeLabels, true);
    }
}

