/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.resultset.CSVInput;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.resultset.TSVInput;
import org.junit.Assert;
import org.junit.Test;

public class TestResultSetFormat2 {
    @Test
    public void resultset_tsv_01() {
        this.parseTSV("\n");
    }

    @Test
    public void resultset_tsv_02() {
        String x = "\n\n";
        this.parseTSV(x);
    }

    @Test
    public void resultset_tsv_03() {
        String x = "?x\n\n";
        this.parseTSV(x);
    }

    @Test
    public void resultset_tsv_04() {
        String x = "?x\n";
        this.parseTSV(x);
    }

    @Test
    public void resultset_tsv_05() {
        String x = "?x\n'a'\n";
        this.parseTSV(x);
    }

    @Test
    public void resultset_tsv_06() {
        String x = "?x\t?y\n\t\n";
        this.parseTSV(x);
    }

    @Test
    public void resultset_tsv_07() {
        String x = "?x\t?y\t?z\n\t\t";
        this.parseTSV(x);
    }

    @Test
    public void resultset_tsv_08() {
        String x = "?x\n<http://example/foo>\n";
        this.parseTSV(x);
    }

    @Test
    public void resultset_tsv_09() {
        String x = "?x\n_:abc\n";
        this.parseTSV(x);
    }

    @Test
    public void resultset_tsv_11() {
        String x = "?x\n123\n";
        this.parseTSV(x);
    }

    @Test
    public void resultset_tsv_12() {
        String x = "?x\n  123\n";
        this.parseTSV(x);
    }

    @Test
    public void resultset_tsv_13() {
        String x = "?x\n123   \n";
        this.parseTSV(x);
    }

    @Test
    public void resultset_tsv_14() {
        String x = "?x\n<http://example/>    \n";
        this.parseTSV(x);
    }

    @Test
    public void resultset_tsv_boolean_01() {
        String x = "?_askResult\ntrue";
        this.parseTSVAsBoolean(x, true);
    }

    @Test
    public void resultset_tsv_boolean_02() {
        String x = "?_askResult\nTRUE";
        this.parseTSVAsBoolean(x, true);
    }

    @Test
    public void resultset_tsv_boolean_03() {
        String x = "?_askResult\ntRuE";
        this.parseTSVAsBoolean(x, true);
    }

    @Test
    public void resultset_tsv_boolean_04() {
        String x = "?_askResult\nyes";
        this.parseTSVAsBoolean(x, true);
    }

    @Test
    public void resultset_tsv_boolean_05() {
        String x = "?_askResult\nYES";
        this.parseTSVAsBoolean(x, true);
    }

    @Test
    public void resultset_tsv_boolean_06() {
        String x = "?_askResult\nyEs";
        this.parseTSVAsBoolean(x, true);
    }

    @Test
    public void resultset_tsv_boolean_07() {
        String x = "?_askResult\nfalse";
        this.parseTSVAsBoolean(x, false);
    }

    @Test
    public void resultset_tsv_boolean_08() {
        String x = "?_askResult\nFALSE";
        this.parseTSVAsBoolean(x, false);
    }

    @Test
    public void resultset_tsv_boolean_09() {
        String x = "?_askResult\nfAlSe";
        this.parseTSVAsBoolean(x, false);
    }

    @Test
    public void resultset_tsv_boolean_10() {
        String x = "?_askResult\nno";
        this.parseTSVAsBoolean(x, false);
    }

    @Test
    public void resultset_tsv_boolean_11() {
        String x = "?_askResult\nNO";
        this.parseTSVAsBoolean(x, false);
    }

    @Test
    public void resultset_tsv_boolean_12() {
        String x = "?_askResult\nnO";
        this.parseTSVAsBoolean(x, false);
    }

    @Test(expected=ResultSetException.class)
    public void resultset_bad_tsv_01() {
        String x = "?x\t?y\n'a'\t'b'\t'c'";
        this.parseTSV(x);
    }

    @Test(expected=ResultSetException.class)
    public void resultset_bad_tsv_02() {
        String x = "?x\t?y\n'a'";
        this.parseTSV(x);
    }

    @Test(expected=ARQException.class)
    public void resultset_bad_tsv_03() {
        this.parseTSV("");
    }

    @Test(expected=ResultSetException.class)
    public void resultset_bad_tsv_04() {
        String x = "?x\t?y\n\n";
        this.parseTSV(x);
    }

    @Test(expected=ResultSetException.class)
    public void resultset_bad_tsv_05() {
        String x = "?x\n<http://example/";
        this.parseTSV(x);
    }

    @Test(expected=ResultSetException.class)
    public void resultset_bad_tsv_06() {
        String x = "?x\n<http://example/ white space >";
        this.parseTSV(x);
    }

    @Test(expected=ResultSetException.class)
    public void resultset_bad_tsv_07() {
        String x = "?x\n<<<<http://example/>>>>";
        this.parseTSV(x);
    }

    @Test(expected=ResultSetException.class)
    public void resultset_bad_tsv_08() {
        String x = "?x\n_:abc def";
        this.parseTSV(x);
    }

    @Test(expected=ResultSetException.class)
    public void resultset_bad_tsv_09() {
        String x = "x\n<http://example.com>";
        this.parseTSV(x);
    }

    @Test(expected=ARQException.class)
    public void resultset_bad_tsv_boolean_01() {
        String x = "?_askResults\nblah";
        this.parseTSVAsBoolean(x, false);
    }

    @Test(expected=ARQException.class)
    public void resultset_bad_tsv_boolean_02() {
        String x = "true";
        this.parseTSVAsBoolean(x, false);
    }

    @Test(expected=ARQException.class)
    public void resultset_bad_tsv_boolean_03() {
        String x = "?_askResult\n";
        this.parseTSVAsBoolean(x, false);
    }

    @Test(expected=ARQException.class)
    public void resultset_bad_tsv_boolean_04() {
        String x = "?x\n";
        this.parseTSVAsBoolean(x, false);
    }

    @Test(expected=ARQException.class)
    public void resultset_bad_tsv_boolean_05() {
        String x = "?x\t?y\n";
        this.parseTSVAsBoolean(x, false);
    }

    @Test
    public void resultset_csv_01() {
        String x = "x,y\n";
        this.parseCSV(x);
    }

    @Test
    public void resultset_csv_02() {
        String x = "\"x\",\"y\"\n";
        this.parseCSV(x);
    }

    @Test
    public void resultset_json_01() {
        String input = StrUtils.strjoinNL((String[])new String[]{"{\"head\":{\"vars\":[\"s\"]},", "     \"results\": {", "      \"bindings\":[", "       {\"s\":{\"type\":\"uri\",\"value\":\"http://rdf.myexperiment.org/ontologies/snarm/Policy\"}}", "      ]", "     },", "     \"warnings\": [\"parser warning: Variable o was bound but is unused in the query on line 1\",", "     \"parser warning: Variable p was bound but is unused in the query on line 1\"]", "    })", "    }"});
        this.parseJSON(input);
    }

    @Test(expected=ResultSetException.class)
    public void resultset_json_02() {
        String input = StrUtils.strjoinNL((String[])new String[]{"{\"head\":{\"vars\":[\"s\"]},", "     \"results\": {", "      \"bindings\":[", "       {\"s\":{\"type\":\"uri\"}}", "      ]", "     },", "     \"warnings\": [\"parser warning: Variable o was bound but is unused in the query on line 1\",", "     \"parser warning: Variable p was bound but is unused in the query on line 1\"]", "    })", "    }"});
        this.parseJSON(input);
    }

    @Test(expected=ResultSetException.class)
    public void resultset_json_03() {
        String input = "{\"head\":{\"vars\":[\"s\"]}}";
        this.parseJSON(input);
    }

    @Test(expected=ResultSetException.class)
    public void resultset_json_04() {
        String input = "{\"results\":{}}";
        this.parseJSON(input);
    }

    private void parseTSV(String x) {
        byte[] b = StrUtils.asUTF8bytes((String)x);
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        ResultSet rs2 = ResultSetFactory.fromTSV((InputStream)in);
        while (rs2.hasNext()) {
            rs2.nextBinding();
        }
    }

    private void parseCSV(String x) {
        byte[] b = StrUtils.asUTF8bytes((String)x);
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        ResultSet rs2 = CSVInput.fromCSV((InputStream)in);
        while (rs2.hasNext()) {
            rs2.nextBinding();
        }
    }

    private void parseJSON(String input) {
        byte[] b = StrUtils.asUTF8bytes((String)input);
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        ResultSet rs = ResultSetFactory.fromJSON((InputStream)in);
        while (rs.hasNext()) {
            rs.nextBinding();
        }
    }

    private void parseTSVAsBoolean(String x, boolean expected) {
        byte[] b = StrUtils.asUTF8bytes((String)x);
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        boolean actual = TSVInput.booleanFromTSV((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

