/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax.syntaxtransform;

import java.util.HashMap;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.syntax.syntaxtransform.QueryTransformOps;
import org.apache.jena.sparql.syntax.syntaxtransform.UpdateTransformOps;
import org.apache.jena.sparql.util.ModelUtils;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.junit.Assert;
import org.junit.Test;

public class TestSyntaxTransform {
    static final String PREFIX = "";

    @Test
    public void subst_query_01() {
        this.testQuery("SELECT * { }", "SELECT * {}", "o", "1");
    }

    @Test
    public void subst_query_02() {
        this.testQuery("SELECT ?x { }", "SELECT ?x {}", "o", "1");
    }

    @Test
    public void subst_query_03() {
        this.testQuery("SELECT ?o { }", "SELECT (1 as ?o) {}", "o", "1");
    }

    @Test
    public void subst_query_04() {
        this.testQuery("SELECT (?o AS ?z) { }", "SELECT (1 AS ?z) {}", "o", "1");
    }

    @Test
    public void subst_query_05() {
        this.testQuery("SELECT (?o+2 AS ?z) { }", "SELECT (1+2 AS ?z) {}", "o", "1");
    }

    @Test
    public void subst_query_09() {
        this.testQuery("SELECT * {?s ?p ?o}", "SELECT * {?s ?p 1}", "o", "1");
    }

    @Test
    public void subst_query_10() {
        this.testQuery("SELECT * { SELECT ?o {} }", "SELECT * {{SELECT (1 as ?o) {}}}", "o", "1");
    }

    @Test
    public void subst_query_11() {
        this.testQuery("SELECT * { ?s ?p ?o { SELECT ?x { ?x ?p ?o } } }", "SELECT * { ?s ?p 1  { SELECT ?x { ?x ?p 1 } } }", "o", "1");
    }

    @Test
    public void subst_query_20() {
        this.testQuery("SELECT * { ?s ?p ?g GRAPH ?g { ?s ?p ?g } }", "SELECT * { ?s ?p <urn:graph> GRAPH <urn:graph> { ?s ?p <urn:graph> } }", "g", "<urn:graph>");
    }

    @Test
    public void subst_query_21() {
        this.testQuery("SELECT * { ?s ?p ?srv SERVICE ?srv { ?s ?p ?srv}}", "SELECT * { ?s ?p <urn:service> SERVICE <urn:service> { ?s ?p <urn:service>}}", "srv", "<urn:service>");
    }

    @Test
    public void subst_query_30() {
        this.testQuery("SELECT * { ?s ?p ?o } ORDER BY ?s", "SELECT * { <urn:x> ?p ?o } ORDER BY (<urn:x>)", "s", "<urn:x>");
    }

    @Test
    public void subst_query_31() {
        this.testQueryModel("SELECT * { ?s ?p ?o } ORDER BY ?s", "SELECT * { <urn:x> ?p ?o } ORDER BY (<urn:x>)", "s", "<urn:x>");
    }

    @Test
    public void subst_update_01() {
        this.testUpdate("DELETE { ?s <urn:p> ?x } WHERE {}", "DELETE { ?s <urn:p> <urn:x> } WHERE {}", "x", "<urn:x>");
    }

    @Test
    public void subst_update_02() {
        this.testUpdate("DELETE { ?s <urn:p> ?x } WHERE { ?s <urn:p> ?x }", "DELETE { ?s <urn:p> <urn:x> } WHERE { ?s <urn:p> <urn:x> }", "x", "<urn:x>");
    }

    @Test
    public void subst_update_03() {
        this.testUpdate("DELETE { ?s <urn:p> ?x } INSERT { ?s <urn:p> ?x } WHERE { ?s <urn:p> ?x }", "DELETE { ?s <urn:p> <urn:x> } INSERT { ?s <urn:p> <urn:x> } WHERE { ?s <urn:p> <urn:x> }", "x", "<urn:x>");
    }

    @Test
    public void subst_update_09() {
        this.testUpdate("DELETE WHERE { ?s <urn:p> ?x }", "DELETE WHERE { ?s <urn:p> <urn:x> }", "x", "<urn:x>");
    }

    @Test
    public void subst_update_10() {
        this.testUpdateModel("DELETE WHERE { ?s <urn:p> ?x }", "DELETE WHERE { ?s <urn:p> <urn:x> }", "x", "<urn:x>");
    }

    private void testQuery(String input, String output, String varStr, String valStr) {
        Query q1 = QueryFactory.create((String)(PREFIX + input));
        Query qExpected = QueryFactory.create((String)(PREFIX + output));
        HashMap<Var, Node> map = new HashMap<Var, Node>();
        map.put(Var.alloc((String)varStr), SSE.parseNode((String)valStr));
        Query qTrans = QueryTransformOps.transform((Query)q1, map);
        Assert.assertEquals((Object)qExpected, (Object)qTrans);
    }

    private void testQueryModel(String input, String output, String varStr, String valStr) {
        Query q1 = QueryFactory.create((String)(PREFIX + input));
        Query qExpected = QueryFactory.create((String)(PREFIX + output));
        HashMap<String, RDFNode> map = new HashMap<String, RDFNode>();
        Node n = SSE.parseNode((String)valStr);
        RDFNode x = ModelUtils.convertGraphNodeToRDFNode((Node)n);
        map.put(varStr, x);
        Query qTrans = QueryTransformOps.transformQuery((Query)q1, map);
        Assert.assertEquals((Object)qExpected, (Object)qTrans);
    }

    private void testUpdate(String input, String output, String varStr, String valStr) {
        UpdateRequest req1 = UpdateFactory.create((String)(PREFIX + input));
        UpdateRequest reqExpected = UpdateFactory.create((String)(PREFIX + output));
        HashMap<Var, Node> map = new HashMap<Var, Node>();
        map.put(Var.alloc((String)varStr), SSE.parseNode((String)valStr));
        UpdateRequest reqTrans = UpdateTransformOps.transform((UpdateRequest)req1, map);
        String x1 = reqExpected.toString().replaceAll("[ \n\t]", PREFIX);
        String x2 = reqTrans.toString().replaceAll("[ \n\t]", PREFIX);
        Assert.assertEquals((Object)x1, (Object)x2);
    }

    private void testUpdateModel(String input, String output, String varStr, String valStr) {
        UpdateRequest req1 = UpdateFactory.create((String)(PREFIX + input));
        UpdateRequest reqExpected = UpdateFactory.create((String)(PREFIX + output));
        HashMap<String, RDFNode> map = new HashMap<String, RDFNode>();
        Node n = SSE.parseNode((String)valStr);
        RDFNode x = ModelUtils.convertGraphNodeToRDFNode((Node)n);
        map.put(varStr, x);
        UpdateRequest reqTrans = UpdateTransformOps.transformUpdate((UpdateRequest)req1, map);
        String x1 = reqExpected.toString().replaceAll("[ \n\t]", PREFIX);
        String x2 = reqTrans.toString().replaceAll("[ \n\t]", PREFIX);
        Assert.assertEquals((Object)x1, (Object)x2);
    }
}

