/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.transaction;

import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.system.ThreadAction;
import org.apache.jena.system.ThreadTxn;
import org.apache.jena.system.Txn;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractTestTransPromote {
    private final Logger[] loggers;
    private Level[] levels;
    private boolean stdPromotion;
    private boolean stdReadCommitted;
    protected static final Quad q1 = SSE.parseQuad((String)"(_ :s :p1 1)");
    protected static final Quad q2 = SSE.parseQuad((String)"(_ :s :p2 2)");
    protected static final Quad q3 = SSE.parseQuad((String)"(_ :s :p3 3)");

    @Before
    public void beforeLoggersNoWarnings() {
        int N = this.loggers.length;
        this.levels = new Level[N];
        for (int i = 0; i < N; ++i) {
            this.levels[i] = this.loggers[i].getLevel();
            this.loggers[i].setLevel(Level.ERROR);
        }
    }

    @After
    public void afterResetLoggers() {
        int N = this.loggers.length;
        for (int i = 0; i < N; ++i) {
            this.loggers[i].setLevel(this.levels[i]);
        }
    }

    protected abstract Class<? extends Exception> getTransactionExceptionClass();

    protected AbstractTestTransPromote(Logger[] loggers) {
        this.loggers = loggers;
    }

    protected abstract DatasetGraph create();

    protected static void assertCount(long expected, DatasetGraph dsg) {
        dsg.begin(ReadWrite.READ);
        long x = Iter.count((Iterator)dsg.find());
        dsg.end();
        Assert.assertEquals((long)expected, (long)x);
    }

    @Test
    public void promote_snapshot_01() {
        this.run_01(TxnType.READ_PROMOTE);
    }

    @Test
    public void promote_readCommitted_01() {
        this.run_01(TxnType.READ_COMMITTED_PROMOTE);
    }

    private void run_01(TxnType txnType) {
        DatasetGraph dsg = this.create();
        dsg.begin(txnType);
        dsg.add(q1);
        dsg.commit();
        dsg.end();
    }

    @Test
    public void promote_snapshot_02() {
        this.run_02(TxnType.READ_PROMOTE);
    }

    @Test
    public void promote_readCommitted_02() {
        this.run_02(TxnType.READ_COMMITTED_PROMOTE);
    }

    private void run_02(TxnType txnType) {
        DatasetGraph dsg = this.create();
        dsg.begin(txnType);
        dsg.end();
        dsg.begin(txnType);
        dsg.add(q1);
        dsg.commit();
        dsg.end();
    }

    @Test
    public void promote_snapshot_03() {
        this.run_03(TxnType.READ_PROMOTE);
    }

    @Test
    public void promote_readCommitted_03() {
        this.run_03(TxnType.READ_COMMITTED_PROMOTE);
    }

    private void run_03(TxnType txnType) {
        DatasetGraph dsg = this.create();
        dsg.begin(TxnType.WRITE);
        dsg.commit();
        dsg.end();
        dsg.begin(txnType);
        dsg.add(q1);
        dsg.commit();
        dsg.end();
    }

    @Test
    public void promote_snapshot_04() {
        this.run_04(TxnType.READ_PROMOTE);
    }

    @Test
    public void promote_readCommitted_04() {
        this.run_04(TxnType.READ_COMMITTED_PROMOTE);
    }

    private void run_04(TxnType txnType) {
        DatasetGraph dsg = this.create();
        dsg.begin(ReadWrite.WRITE);
        dsg.abort();
        dsg.end();
        dsg.begin(txnType);
        dsg.add(q1);
        dsg.commit();
        dsg.end();
    }

    @Test
    public void promote_snapshot_05() {
        this.run_05(TxnType.READ_PROMOTE);
    }

    @Test
    public void promote_readCommitted_05() {
        this.run_05(TxnType.READ_COMMITTED_PROMOTE);
    }

    private void run_05(TxnType txnType) {
        DatasetGraph dsg = this.create();
        dsg.begin(txnType);
        dsg.add(q1);
        try {
            dsg.end();
            Assert.fail((String)"begin(W);end() did not throw an exception");
        }
        catch (JenaTransactionException jenaTransactionException) {
            // empty catch block
        }
        AbstractTestTransPromote.assertCount(0L, dsg);
    }

    private void run_06(TxnType txnType) {
        DatasetGraph dsg = this.create();
        AtomicInteger a = new AtomicInteger(0);
        Semaphore sema = new Semaphore(0);
        Thread t = new Thread(() -> {
            sema.release();
            Txn.executeWrite((Transactional)dsg, () -> dsg.add(q3));
            sema.release();
        });
        dsg.begin(txnType);
        dsg.add(q1);
        t.start();
        sema.acquireUninterruptibly();
        dsg.add(q2);
        dsg.commit();
        dsg.end();
        sema.acquireUninterruptibly();
        AbstractTestTransPromote.assertCount(3L, dsg);
    }

    @Test
    public void promote_snapshot_07() {
        this.run_07(TxnType.READ_PROMOTE);
    }

    @Test
    public void promote_readCommitted_07() {
        this.run_07(TxnType.READ_COMMITTED_PROMOTE);
    }

    private void run_07(TxnType txnType) {
        DatasetGraph dsg = this.create();
        ThreadAction tt = ThreadTxn.threadTxnRead((Transactional)dsg, () -> {
            long x = Iter.count((Iterator)dsg.find());
            if (x != 0L) {
                throw new RuntimeException();
            }
        });
        dsg.begin(txnType);
        dsg.add(q1);
        dsg.add(q2);
        dsg.commit();
        dsg.end();
        tt.run();
    }

    @Test
    public void promote_snapshot_08() {
        this.run_08(TxnType.READ_PROMOTE);
    }

    @Test
    public void promote_readCommitted_08() {
        this.run_08(TxnType.READ_COMMITTED_PROMOTE);
    }

    private void run_08(TxnType txnType) {
        DatasetGraph dsg = this.create();
        dsg.begin(txnType);
        dsg.add(q1);
        dsg.add(q2);
        dsg.commit();
        dsg.end();
        Txn.executeRead((Transactional)dsg, () -> {
            long x = Iter.count((Iterator)dsg.find());
            Assert.assertEquals((long)2L, (long)x);
        });
    }

    @SafeVarargs
    private final void expect(Runnable runnable, Class<? extends Exception> ... classes) {
        try {
            runnable.run();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            for (Class<? extends Exception> c : classes) {
                if (!e.getClass().equals(c)) continue;
                return;
            }
            throw e;
        }
    }

    @Test
    public void promote_10() {
        this.promote_readCommit_txnCommit(TxnType.READ_COMMITTED_PROMOTE, true);
    }

    @Test
    public void promote_11() {
        this.promote_readCommit_txnCommit(TxnType.READ_COMMITTED_PROMOTE, false);
    }

    @Test
    public void promote_12() {
        this.expect(() -> this.promote_readCommit_txnCommit(TxnType.READ_PROMOTE, true), this.getTransactionExceptionClass());
    }

    @Test
    public void promote_13() {
        this.promote_readCommit_txnCommit(TxnType.READ_PROMOTE, false);
    }

    private void promote_readCommit_txnCommit(TxnType txnType, boolean asyncCommit) {
        DatasetGraph dsg = this.create();
        ThreadAction tt = asyncCommit ? ThreadTxn.threadTxnWrite((Transactional)dsg, () -> dsg.add(q3)) : ThreadTxn.threadTxnWriteAbort((Transactional)dsg, () -> dsg.add(q3));
        dsg.begin(txnType);
        tt.run();
        dsg.add(q1);
        if (txnType == TxnType.READ_PROMOTE && asyncCommit) {
            Assert.fail((String)"Should not be here");
        }
        Assert.assertEquals((Object)asyncCommit, (Object)dsg.contains(q3));
        dsg.commit();
        dsg.end();
    }

    @Test
    public void promote_active_writer_1() throws InterruptedException, ExecutionException {
        this.expect(() -> this.promote_active_writer(true), this.getTransactionExceptionClass());
    }

    @Test
    public void promote_active_writer_2() throws InterruptedException, ExecutionException {
        this.promote_active_writer(false);
    }

    private void promote_active_writer(boolean activeWriterCommit) {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            this.promote_clash_active_writer(executor, activeWriterCommit);
        }
        finally {
            executor.shutdown();
        }
    }

    private void promote_clash_active_writer(ExecutorService executor, boolean activeWriterCommit) {
        Semaphore semaActiveWriterStart = new Semaphore(0);
        Semaphore semaActiveWriterContinue = new Semaphore(0);
        Semaphore semaPromoteTxnStart = new Semaphore(0);
        Semaphore semaPromoteTxnContinue = new Semaphore(0);
        DatasetGraph dsg = this.create();
        Callable<Object> activeWriter = () -> {
            dsg.begin(ReadWrite.WRITE);
            semaActiveWriterStart.release(1);
            semaActiveWriterContinue.acquireUninterruptibly(1);
            if (activeWriterCommit) {
                dsg.commit();
            } else {
                dsg.abort();
            }
            dsg.end();
            return null;
        };
        Future<Object> activeWriterFuture = executor.submit(activeWriter);
        semaActiveWriterStart.acquireUninterruptibly();
        Callable<RuntimeException> attemptedPromote = () -> {
            dsg.begin(TxnType.READ_PROMOTE);
            semaPromoteTxnStart.release(1);
            semaPromoteTxnContinue.acquireUninterruptibly();
            try {
                dsg.add(q1);
                return null;
            }
            catch (RuntimeException e) {
                Class<? extends Exception> c = this.getTransactionExceptionClass();
                if (!e.getClass().equals(c)) {
                    throw e;
                }
                return e;
            }
        };
        Future<RuntimeException> attemptedPromoteFuture = executor.submit(attemptedPromote);
        semaPromoteTxnStart.acquireUninterruptibly();
        semaPromoteTxnContinue.release(1);
        Lib.sleep((int)100);
        semaActiveWriterContinue.release(1);
        try {
            activeWriterFuture.get();
            RuntimeException e = attemptedPromoteFuture.get();
            if (e != null) {
                throw e;
            }
        }
        catch (InterruptedException | ExecutionException e1) {
            throw new RuntimeException(e1);
        }
    }

    @Test
    public void promote_thread_writer_1() {
        this.test_thread_writer(TxnType.READ_COMMITTED_PROMOTE);
    }

    @Test(expected=JenaTransactionException.class)
    public void promote_thread_writer_2() {
        this.test_thread_writer(TxnType.READ_PROMOTE);
    }

    private void test_thread_writer(TxnType txnType) {
        DatasetGraph dsg = this.create();
        ThreadAction a = ThreadTxn.threadTxnWrite((Transactional)dsg, () -> dsg.add(q1));
        dsg.begin(txnType);
        Assert.assertEquals((Object)txnType, (Object)dsg.transactionType());
        a.run();
        dsg.add(q2);
        Assert.assertEquals((Object)txnType, (Object)dsg.transactionType());
        Assert.assertEquals((Object)ReadWrite.WRITE, (Object)dsg.transactionMode());
        dsg.commit();
        dsg.end();
    }

    private void test_promote_thread_writer(TxnType txnType) {
        DatasetGraph dsg = this.create();
        ThreadAction a = ThreadTxn.threadTxnWrite((Transactional)dsg, () -> dsg.add(q1));
        dsg.begin(txnType);
        Assert.assertEquals((Object)txnType, (Object)dsg.transactionType());
        a.run();
        boolean b = dsg.promote();
        if (txnType == TxnType.READ_PROMOTE) {
            Assert.assertFalse((boolean)b);
        }
        if (txnType == TxnType.READ_COMMITTED_PROMOTE) {
            Assert.assertTrue((boolean)b);
        }
        dsg.add(q2);
        Assert.assertEquals((Object)txnType, (Object)dsg.transactionType());
        Assert.assertEquals((Object)ReadWrite.WRITE, (Object)dsg.transactionMode());
        dsg.commit();
        dsg.end();
    }
}

