/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.DatasetGraphZero;
import org.apache.jena.sparql.util.Context;
import org.junit.Test;

public abstract class TestDyadicDatasetGraph
extends BaseTest {
    public abstract DatasetGraph testInstance(DatasetGraph var1, DatasetGraph var2, Context var3);

    private DatasetGraph emptyDsg() {
        return this.testInstance(DatasetGraphFactory.createTxnMem(), DatasetGraphFactory.createTxnMem(), Context.emptyContext);
    }

    @Test(expected=NullPointerException.class)
    public void nullDatasetGraphsNotAllowed() {
        this.testInstance(null, null, Context.emptyContext);
    }

    @Test(expected=NullPointerException.class)
    public void nullContextNotAllowed() {
        this.testInstance((DatasetGraph)new DatasetGraphZero(), (DatasetGraph)new DatasetGraphZero(), null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void noAddingQuads() {
        this.emptyDsg().add(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void noAddingQuads2() {
        this.emptyDsg().add(null, null, null, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void noDeletingQuads() {
        this.emptyDsg().delete(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void noDeletingQuads2() {
        this.emptyDsg().delete(null, null, null, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void noDeletingAnyQuads() {
        this.emptyDsg().deleteAny(null, null, null, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void noAddingGraphs() {
        this.emptyDsg().addGraph(null, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void noDeletingGraphs() {
        this.emptyDsg().removeGraph(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void noClearing() {
        this.emptyDsg().clear();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void noAddingToDefaultGraph() {
        this.emptyDsg().getDefaultGraph().add(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void noDeletingFromDefaultGraph() {
        this.emptyDsg().getDefaultGraph().delete(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void noAddingToANamedGraph() {
        Node graphName = NodeFactory.createBlankNode();
        this.emptyDsg().getGraph(graphName).add(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void noDeletingFromANamedGraph() {
        Node graphName = NodeFactory.createBlankNode();
        this.emptyDsg().getGraph(graphName).delete(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void noClearingDefaultGraph() {
        this.emptyDsg().getDefaultGraph().clear();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void noClearingANamedGraph() {
        Node graphName = NodeFactory.createBlankNode();
        this.emptyDsg().getGraph(graphName).clear();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void noRemovingFromANamedGraph() {
        Node graphName = NodeFactory.createBlankNode();
        this.emptyDsg().getGraph(graphName).remove(null, null, null);
    }

    @Test
    public void txnRead1() {
        DatasetGraph dsg = this.emptyDsg();
        TestDyadicDatasetGraph.assertFalse((boolean)dsg.isInTransaction());
        dsg.begin(ReadWrite.READ);
        TestDyadicDatasetGraph.assertTrue((boolean)dsg.isInTransaction());
        dsg.commit();
        dsg.end();
    }

    @Test
    public void txnRead2() {
        DatasetGraph dsg = this.emptyDsg();
        TestDyadicDatasetGraph.assertFalse((boolean)dsg.isInTransaction());
        dsg.begin(ReadWrite.READ);
        TestDyadicDatasetGraph.assertTrue((boolean)dsg.isInTransaction());
        dsg.end();
    }

    @Test
    public void txnRead3() {
        DatasetGraph dsg = this.emptyDsg();
        TestDyadicDatasetGraph.assertFalse((boolean)dsg.isInTransaction());
        dsg.begin();
        TestDyadicDatasetGraph.assertTrue((boolean)dsg.isInTransaction());
        TestDyadicDatasetGraph.assertEquals((Object)ReadWrite.READ, (Object)dsg.transactionMode());
        TestDyadicDatasetGraph.assertEquals((Object)TxnType.READ, (Object)dsg.transactionType());
        dsg.end();
    }

    @Test(expected=JenaTransactionException.class)
    public void noWriting1() {
        this.emptyDsg().begin(ReadWrite.WRITE);
    }

    @Test(expected=JenaTransactionException.class)
    public void noWriting2() {
        this.emptyDsg().begin(TxnType.WRITE);
    }

    @Test(expected=JenaTransactionException.class)
    public void noWriting3() {
        this.emptyDsg().begin(TxnType.READ_PROMOTE);
    }

    @Test(expected=JenaTransactionException.class)
    public void noWriting4() {
        this.emptyDsg().begin(TxnType.READ_COMMITTED_PROMOTE);
    }

    @Test
    public void noPromoting() {
        DatasetGraph dsg = this.emptyDsg();
        dsg.begin(ReadWrite.READ);
        boolean b = dsg.promote();
        TestDyadicDatasetGraph.assertFalse((boolean)b);
    }

    @Test
    public void testTransactionTypeAndMode() {
        DatasetGraph dsg = this.emptyDsg();
        TestDyadicDatasetGraph.assertFalse((boolean)dsg.isInTransaction());
        dsg.begin(TxnType.READ);
        TestDyadicDatasetGraph.assertTrue((boolean)dsg.isInTransaction());
        TestDyadicDatasetGraph.assertEquals((Object)TxnType.READ, (Object)dsg.transactionType());
        TestDyadicDatasetGraph.assertEquals((Object)ReadWrite.READ, (Object)dsg.transactionMode());
        dsg.end();
        TestDyadicDatasetGraph.assertFalse((boolean)dsg.isInTransaction());
    }

    @Test
    public void canUseEndToFinishTransaction1() {
        DatasetGraph dsg = this.emptyDsg();
        TestDyadicDatasetGraph.assertFalse((boolean)dsg.isInTransaction());
        try {
            dsg.begin(ReadWrite.READ);
            TestDyadicDatasetGraph.assertTrue((boolean)dsg.isInTransaction());
            dsg.end();
            TestDyadicDatasetGraph.assertFalse((boolean)dsg.isInTransaction());
        }
        catch (UnsupportedOperationException e) {
            TestDyadicDatasetGraph.fail();
        }
    }

    @Test
    public void canUseEndToFinishTransaction2() {
        DatasetGraph dsg = this.emptyDsg();
        TestDyadicDatasetGraph.assertFalse((boolean)dsg.isInTransaction());
        try {
            dsg.begin(TxnType.READ);
            TestDyadicDatasetGraph.assertTrue((boolean)dsg.isInTransaction());
            dsg.end();
            TestDyadicDatasetGraph.assertFalse((boolean)dsg.isInTransaction());
        }
        catch (UnsupportedOperationException e) {
            TestDyadicDatasetGraph.fail();
        }
    }

    @Test
    public void canUseAbortToFinishTransaction1() {
        DatasetGraph dsg = this.emptyDsg();
        TestDyadicDatasetGraph.assertFalse((boolean)dsg.isInTransaction());
        try {
            dsg.begin(ReadWrite.READ);
            TestDyadicDatasetGraph.assertTrue((boolean)dsg.isInTransaction());
            dsg.abort();
            TestDyadicDatasetGraph.assertFalse((boolean)dsg.isInTransaction());
        }
        catch (UnsupportedOperationException e) {
            TestDyadicDatasetGraph.fail();
        }
    }

    @Test
    public void canUseAbortToFinishTransaction2() {
        DatasetGraph dsg = this.emptyDsg();
        TestDyadicDatasetGraph.assertFalse((boolean)dsg.isInTransaction());
        try {
            dsg.begin(TxnType.READ);
            TestDyadicDatasetGraph.assertTrue((boolean)dsg.isInTransaction());
            dsg.abort();
            TestDyadicDatasetGraph.assertFalse((boolean)dsg.isInTransaction());
        }
        catch (UnsupportedOperationException e) {
            TestDyadicDatasetGraph.fail();
        }
    }
}

