/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util.compose;

import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.compose.DatasetCollector;
import org.junit.Assert;
import org.junit.Test;

public abstract class TestDatasetCollector
extends Assert {
    public abstract DatasetCollector testInstance();

    @Test
    public void collectionOfEmptyStreamShouldBeEmpty() {
        Dataset collected = (Dataset)Stream.empty().collect(this.testInstance());
        TestDatasetCollector.assertTrue((boolean)collected.isEmpty());
    }

    @Test
    public void collectionOfStreamOfEmptyDatasetsShouldBeEmpty() {
        Stream<Dataset> stream = Stream.builder().add(DatasetFactory.create()).add(DatasetFactory.create()).add(DatasetFactory.create()).build();
        Dataset collected = (Dataset)stream.collect(this.testInstance());
        TestDatasetCollector.assertTrue((boolean)collected.isEmpty());
    }

    @Test(expected=NullPointerException.class)
    public void noNullDatasetsAllowed() {
        Stream.builder().add(null).build().collect(this.testInstance());
    }

    @Test
    public void collectingOneDatasetGivesThatDataset() {
        Graph graph = SSE.parseGraph((String)"(graph (triple <s1> <p1> <o1> ))");
        Model model = ModelFactory.createModelForGraph((Graph)graph);
        Dataset dataset = DatasetFactory.create((Model)model);
        Node graphName = NodeFactory.createBlankNode();
        dataset.addNamedModel(graphName.toString(), model);
        Dataset collection = (Dataset)Stream.builder().add(dataset).build().collect(this.testInstance());
        TestDatasetCollector.assertDatasetsAreIsomorphicPerGraph(dataset, collection);
    }

    protected static void assertDatasetsAreIsomorphicPerGraph(Dataset dataset1, Dataset dataset2) {
        TestDatasetCollector.assertGraphsAreIsomorphic(dataset1.getDefaultModel(), dataset2.getDefaultModel());
        dataset1.listNames().forEachRemaining(graphName -> TestDatasetCollector.assertGraphsAreIsomorphic(dataset1.getNamedModel(graphName), dataset2.getNamedModel(graphName)));
    }

    protected static void assertGraphsAreIsomorphic(Model graph1, Model graph2) {
        TestDatasetCollector.assertTrue((boolean)graph1.isIsomorphicWith(graph2));
    }
}

