/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util.compose;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.compose.DatasetCollector;
import org.apache.jena.sparql.util.compose.DatasetLib;
import org.apache.jena.sparql.util.compose.TestDatasetCollector;
import org.junit.Assert;
import org.junit.Test;

public class TestUnionDatasetCollector
extends TestDatasetCollector {
    @Override
    public DatasetCollector testInstance() {
        return DatasetLib.collectors().union();
    }

    @Test
    public void testUnion() {
        Graph g1 = SSE.parseGraph((String)"(graph (triple <s1> <p1> <o1> ))");
        Model m1 = ModelFactory.createModelForGraph((Graph)g1);
        Dataset dsg1 = DatasetFactory.create((Model)m1);
        String graphName1 = NodeFactory.createBlankNode().toString();
        dsg1.addNamedModel(graphName1, m1);
        Graph g2 = SSE.parseGraph((String)"(graph (triple <s2> <p2> <o2> ))");
        Dataset dsg2 = DatasetFactory.create((Model)ModelFactory.createModelForGraph((Graph)g2));
        Model m2 = ModelFactory.createModelForGraph((Graph)g2);
        String graphName2 = NodeFactory.createBlankNode().toString();
        dsg2.addNamedModel(graphName2, m2);
        Stream<Dataset> stream = Stream.builder().add(dsg1).add(dsg2).build();
        Dataset dataset = (Dataset)stream.collect(this.testInstance());
        TestUnionDatasetCollector.assertEquals((long)2L, (long)Iter.count((Iterator)dataset.listNames()));
        TestUnionDatasetCollector.assertTrue((boolean)m1.isIsomorphicWith(dataset.getNamedModel(graphName1)));
        TestUnionDatasetCollector.assertTrue((boolean)m2.isIsomorphicWith(dataset.getNamedModel(graphName2)));
        m1.listStatements().mapWith(arg_0 -> ((Model)dataset.getDefaultModel()).contains(arg_0)).forEachRemaining(Assert::assertTrue);
        m2.listStatements().mapWith(arg_0 -> ((Model)dataset.getDefaultModel()).contains(arg_0)).forEachRemaining(Assert::assertTrue);
        List leftovers = dataset.getDefaultModel().listStatements().filterDrop(arg_0 -> ((Model)m1).contains(arg_0)).filterDrop(arg_0 -> ((Model)m2).contains(arg_0)).toList();
        TestUnionDatasetCollector.assertTrue((boolean)leftovers.isEmpty());
    }
}

