/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;

public class JsonLDReader
implements ReaderRIOT {
    private ErrorHandler errorHandler = ErrorHandlerFactory.getDefaultErrorHandler();
    private ParserProfile profile;
    public static String LITERAL = "literal";
    public static String BLANK_NODE = "blank node";
    public static String IRI = "IRI";
    private static final String xsdString = XSDDatatype.XSDstring.getURI();

    public JsonLDReader(Lang lang, ParserProfile profile, ErrorHandler errorHandler) {
        this.profile = profile;
        this.errorHandler = errorHandler;
    }

    @Override
    public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        try {
            Object jsonObject = JsonUtils.fromReader((Reader)reader);
            this.read$(jsonObject, baseURI, ct, output, context2);
        }
        catch (JsonProcessingException ex) {
            JsonLocation loc = ex.getLocation();
            this.errorHandler.error(ex.getOriginalMessage(), loc.getLineNr(), loc.getColumnNr());
            throw new RiotException(ex.getOriginalMessage());
        }
        catch (IOException e2) {
            this.errorHandler.error(e2.getMessage(), -1L, -1L);
            IO.exception((IOException)e2);
        }
    }

    @Override
    public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        try {
            Object jsonldCtx;
            Object jsonObject = JsonUtils.fromInputStream((InputStream)in);
            if (context2 != null && (jsonldCtx = context2.get(RIOT.JSONLD_CONTEXT)) != null) {
                if (jsonObject instanceof Map) {
                    ((Map)jsonObject).put("@context", jsonldCtx);
                } else {
                    this.errorHandler.warning("Unexpected: not a Map; unable to set JsonLD's @context", -1L, -1L);
                }
            }
            this.read$(jsonObject, baseURI, ct, output, context2);
        }
        catch (JsonProcessingException ex) {
            JsonLocation loc = ex.getLocation();
            this.errorHandler.error(ex.getOriginalMessage(), loc.getLineNr(), loc.getColumnNr());
            throw new RiotException(ex.getOriginalMessage());
        }
        catch (IOException e2) {
            this.errorHandler.error(e2.getMessage(), -1L, -1L);
            IO.exception((IOException)e2);
        }
    }

    private void read$(Object jsonObject, String baseURI, ContentType ct, final StreamRDF output, Context context2) {
        output.start();
        try {
            JsonLdTripleCallback callback = new JsonLdTripleCallback(){

                public Object call(RDFDataset dataset) {
                    for (Map.Entry namespace2 : dataset.getNamespaces().entrySet()) {
                        output.prefix((String)namespace2.getKey(), (String)namespace2.getValue());
                    }
                    for (String gn : dataset.keySet()) {
                        Object x = dataset.get((Object)gn);
                        if ("@default".equals(gn)) {
                            List triples = (List)x;
                            for (Map t : triples) {
                                Node s = JsonLDReader.this.createNode(t, "subject");
                                Node p = JsonLDReader.this.createNode(t, "predicate");
                                Node o = JsonLDReader.this.createNode(t, "object");
                                Triple triple = JsonLDReader.this.profile.createTriple(s, p, o, -1L, -1L);
                                output.triple(triple);
                            }
                            continue;
                        }
                        List quads = (List)x;
                        Node g = JsonLDReader.this.createURI(gn);
                        for (Map q : quads) {
                            Node s = JsonLDReader.this.createNode(q, "subject");
                            Node p = JsonLDReader.this.createNode(q, "predicate");
                            Node o = JsonLDReader.this.createNode(q, "object");
                            Quad quad = JsonLDReader.this.profile.createQuad(g, s, p, o, -1L, -1L);
                            output.quad(quad);
                        }
                    }
                    return null;
                }
            };
            JsonLdOptions options = new JsonLdOptions(baseURI);
            options.useNamespaces = true;
            JsonLdProcessor.toRDF((Object)jsonObject, (JsonLdTripleCallback)callback, (JsonLdOptions)options);
        }
        catch (JsonLdError e2) {
            this.errorHandler.error(e2.getMessage(), -1L, -1L);
            throw new RiotException(e2);
        }
        output.finish();
    }

    private Node createNode(Map<String, Object> tripleMap, String key) {
        Map x = (Map)tripleMap.get(key);
        return this.createNode(x);
    }

    private Node createNode(Map<String, Object> map) {
        String type = (String)map.get("type");
        String lex = (String)map.get("value");
        if (type.equals(IRI)) {
            return this.createURI(lex);
        }
        if (type.equals(BLANK_NODE)) {
            return this.createBlankNode(lex);
        }
        if (type.equals(LITERAL)) {
            String lang = (String)map.get("language");
            String datatype = (String)map.get("datatype");
            if (Objects.equals(xsdString, datatype)) {
                datatype = null;
            }
            if (lang == null && datatype == null) {
                return this.profile.createStringLiteral(lex, -1L, -1L);
            }
            if (lang != null) {
                return this.profile.createLangLiteral(lex, lang, -1L, -1L);
            }
            RDFDatatype dt = NodeFactory.getType((String)datatype);
            return this.profile.createTypedLiteral(lex, dt, -1L, -1L);
        }
        throw new InternalErrorException("Node is not a IRI, bNode or a literal: " + type);
    }

    private Node createBlankNode(String str2) {
        if (str2.startsWith("_:")) {
            str2 = str2.substring(2);
        }
        return this.profile.createBlankNode(null, str2, -1L, -1L);
    }

    private Node createURI(String str2) {
        if (str2.startsWith("_:")) {
            return this.createBlankNode(str2);
        }
        return this.profile.createURI(str2, -1L, -1L);
    }
}

