/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify.request;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.SinkQuadBracedOutput;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.modify.request.Target;
import org.apache.jena.sparql.modify.request.UpdateAdd;
import org.apache.jena.sparql.modify.request.UpdateBinaryOp;
import org.apache.jena.sparql.modify.request.UpdateClear;
import org.apache.jena.sparql.modify.request.UpdateCopy;
import org.apache.jena.sparql.modify.request.UpdateCreate;
import org.apache.jena.sparql.modify.request.UpdateDataDelete;
import org.apache.jena.sparql.modify.request.UpdateDataInsert;
import org.apache.jena.sparql.modify.request.UpdateDataWriter;
import org.apache.jena.sparql.modify.request.UpdateDeleteWhere;
import org.apache.jena.sparql.modify.request.UpdateDrop;
import org.apache.jena.sparql.modify.request.UpdateDropClear;
import org.apache.jena.sparql.modify.request.UpdateLoad;
import org.apache.jena.sparql.modify.request.UpdateModify;
import org.apache.jena.sparql.modify.request.UpdateMove;
import org.apache.jena.sparql.modify.request.UpdateVisitor;
import org.apache.jena.sparql.serializer.FormatterElement;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.NodeToLabelMapBNode;

public class UpdateWriterVisitor
implements UpdateVisitor {
    protected static final int BLOCK_INDENT = 2;
    protected final IndentedWriter out;
    protected final SerializationContext sCxt;

    public UpdateWriterVisitor(IndentedWriter out, SerializationContext sCxt) {
        this.out = out;
        this.sCxt = sCxt;
    }

    protected void visitDropClear(String name, UpdateDropClear update) {
        this.out.ensureStartOfLine();
        this.out.print(name);
        this.out.print(" ");
        if (update.isSilent()) {
            this.out.print("SILENT ");
        }
        this.printTarget(update.getTarget());
    }

    protected void printTarget(Target target) {
        if (target.isAll()) {
            this.out.print("ALL");
        } else if (target.isAllNamed()) {
            this.out.print("NAMED");
        } else if (target.isDefault()) {
            this.out.print("DEFAULT");
        } else if (target.isOneNamedGraph()) {
            this.out.print("GRAPH ");
            String s = FmtUtils.stringForNode(target.getGraph(), this.sCxt);
            this.out.print(s);
        } else {
            this.out.print("Target BROKEN");
            throw new ARQException("Malformed Target");
        }
    }

    @Override
    public void visit(UpdateDrop update) {
        this.visitDropClear("DROP", update);
    }

    @Override
    public void visit(UpdateClear update) {
        this.visitDropClear("CLEAR", update);
    }

    @Override
    public void visit(UpdateCreate update) {
        this.out.ensureStartOfLine();
        this.out.print("CREATE");
        this.out.print(" ");
        if (update.isSilent()) {
            this.out.print("SILENT ");
        }
        this.out.print("GRAPH");
        this.out.print(" ");
        String s = FmtUtils.stringForNode(update.getGraph(), this.sCxt);
        this.out.print(s);
    }

    @Override
    public void visit(UpdateLoad update) {
        this.out.ensureStartOfLine();
        this.out.print("LOAD");
        this.out.print(" ");
        if (update.getSilent()) {
            this.out.print("SILENT ");
        }
        this.outputStringAsURI(update.getSource());
        if (update.getDest() != null) {
            this.out.print(" INTO GRAPH ");
            this.output(update.getDest());
        }
    }

    protected void outputStringAsURI(String uriStr) {
        String x = FmtUtils.stringForURI(uriStr, this.sCxt);
        this.out.print(x);
    }

    protected void printTargetUpdate2(Target target) {
        if (target.isDefault()) {
            this.out.print("DEFAULT");
        } else if (target.isOneNamedGraph()) {
            String s = FmtUtils.stringForNode(target.getGraph(), this.sCxt);
            this.out.print(s);
        } else {
            this.out.print("Target BROKEN / Update2");
            throw new ARQException("Malformed Target / Update2");
        }
    }

    protected void printUpdate2(UpdateBinaryOp update, String name) {
        this.out.print(name);
        if (update.getSilent()) {
            this.out.print(" SILENT");
        }
        this.out.print(" ");
        this.printTargetUpdate2(update.getSrc());
        this.out.print(" TO ");
        this.printTargetUpdate2(update.getDest());
    }

    @Override
    public void visit(UpdateAdd update) {
        this.printUpdate2(update, "ADD");
    }

    @Override
    public void visit(UpdateCopy update) {
        this.printUpdate2(update, "COPY");
    }

    @Override
    public void visit(UpdateMove update) {
        this.printUpdate2(update, "MOVE");
    }

    @Override
    public Sink<Quad> createInsertDataSink() {
        UpdateDataWriter udw = new UpdateDataWriter(UpdateDataWriter.UpdateMode.INSERT, this.out, this.sCxt);
        udw.open();
        return udw;
    }

    @Override
    public void visit(UpdateDataInsert update) {
        Iter.sendToSink(update.getQuads(), this.createInsertDataSink());
    }

    @Override
    public Sink<Quad> createDeleteDataSink() {
        UpdateDataWriter udw = new UpdateDataWriter(UpdateDataWriter.UpdateMode.DELETE, this.out, this.sCxt);
        udw.open();
        return udw;
    }

    @Override
    public void visit(UpdateDataDelete update) {
        Iter.sendToSink(update.getQuads(), this.createDeleteDataSink());
    }

    protected void outputQuadsBraced(List<Quad> quads) {
        if (quads.size() == 0) {
            this.out.print("{ }");
            return;
        }
        SinkQuadBracedOutput sink = new SinkQuadBracedOutput(this.out, this.sCxt);
        sink.open();
        Iter.sendToSink(quads, (Sink)sink);
    }

    protected void output(Node node) {
        String $ = FmtUtils.stringForNode(node, this.sCxt);
        this.out.print($);
    }

    @Override
    public void visit(UpdateDeleteWhere update) {
        this.out.ensureStartOfLine();
        this.out.println("DELETE WHERE ");
        this.outputQuadsBraced(update.getQuads());
    }

    @Override
    public void visit(UpdateModify update) {
        this.out.ensureStartOfLine();
        if (update.getWithIRI() != null) {
            this.out.print("WITH ");
            this.output(update.getWithIRI());
        }
        if (update.hasDeleteClause()) {
            List<Quad> deleteQuads = update.getDeleteQuads();
            this.out.ensureStartOfLine();
            this.out.print("DELETE ");
            this.outputQuadsBraced(deleteQuads);
        }
        if (update.hasInsertClause()) {
            Iterator<Node> insertQuads = update.getInsertQuads();
            this.out.ensureStartOfLine();
            this.out.print("INSERT ");
            this.outputQuadsBraced((List<Quad>)((Object)insertQuads));
        }
        if (!update.hasInsertClause() && !update.hasDeleteClause()) {
            this.out.ensureStartOfLine();
            this.out.println("INSERT { }");
        }
        for (Node x : update.getUsing()) {
            this.out.ensureStartOfLine();
            this.out.print("USING ");
            this.output(x);
        }
        for (Node x : update.getUsingNamed()) {
            this.out.ensureStartOfLine();
            this.out.print("USING NAMED ");
            this.output(x);
        }
        Element el = update.getWherePattern();
        this.out.ensureStartOfLine();
        this.out.print("WHERE");
        this.out.incIndent(2);
        this.out.newline();
        if (el != null) {
            FormatterElement fmtElement = this.prepareElementFormatter();
            fmtElement.visitAsGroup(el);
        } else {
            this.out.print("{}");
        }
        this.out.decIndent(2);
    }

    protected FormatterElement prepareElementFormatter() {
        SerializationContext sCxt1 = new SerializationContext(this.sCxt);
        sCxt1.setBNodeMap(new NodeToLabelMapBNode("x", false));
        return new FormatterElement(this.out, sCxt1);
    }
}

