/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.table;

import java.util.Iterator;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.FmtUtils;

public class TableWriter {
    public static String asSSE(Table table) {
        IndentedLineBuffer out = new IndentedLineBuffer();
        TableWriter.output(table, (IndentedWriter)out);
        return out.asString();
    }

    public static void output(Table table, IndentedWriter out) {
        TableWriter.output(table, out, null);
    }

    public static void output(Table table, IndentedWriter out, SerializationContext sCxt) {
        if (sCxt != null) {
            // empty if block
        }
        out.print("(table");
        out.incIndent();
        QueryIterator qIter = table.iterator(null);
        while (qIter.hasNext()) {
            out.println();
            Binding binding = qIter.nextBinding();
            TableWriter.output(binding, out, sCxt);
        }
        out.decIndent();
        out.print(")");
    }

    private static void output(Binding binding, IndentedWriter out, SerializationContext sCxt) {
        out.print("(row");
        Iterator<Var> iter = binding.vars();
        while (iter.hasNext()) {
            Var v = iter.next();
            Node n = binding.get(v);
            out.print(" ");
            out.print("(");
            out.print(FmtUtils.stringForNode((Node)v));
            out.print(" ");
            out.print(FmtUtils.stringForNode(n));
            out.print(")");
        }
        out.print(")");
    }
}

