/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import java.util.Objects;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphMap;
import org.apache.jena.sparql.core.DatasetGraphMapLink;
import org.apache.jena.sparql.core.DatasetGraphOne;
import org.apache.jena.sparql.core.NamedGraphWrapper;
import org.apache.jena.sparql.core.mem.DatasetGraphInMemory;
import org.apache.jena.sparql.graph.GraphFactory;

public class DatasetGraphFactory {
    public static GraphMaker graphMakerNull = name -> null;
    public static GraphMaker graphMakerMem = name -> GraphFactory.createDefaultGraph();
    public static GraphMaker graphMakerNamedGraphMem = name -> {
        Graph g = GraphFactory.createDefaultGraph();
        return new NamedGraphWrapper(name, g);
    };

    public static DatasetGraph create() {
        return new DatasetGraphMap();
    }

    public static DatasetGraph createTxnMem() {
        return new DatasetGraphInMemory();
    }

    public static DatasetGraph createGeneral() {
        return new DatasetGraphMapLink(graphMakerMem.create(null), graphMakerMem);
    }

    @Deprecated
    public static DatasetGraph createMem() {
        return DatasetGraphFactory.createGeneral();
    }

    @Deprecated
    public static DatasetGraph create(DatasetGraph dsg) {
        return DatasetGraphFactory.cloneStructure(dsg);
    }

    public static DatasetGraph cloneStructure(DatasetGraph dsg) {
        Objects.requireNonNull(dsg, "DatasetGraph must be provided");
        DatasetGraphMapLink dsg2 = new DatasetGraphMapLink(dsg.getDefaultGraph());
        Iterator<Node> names = dsg.listGraphNodes();
        while (names.hasNext()) {
            Node gn = names.next();
            dsg2.addGraph(gn, dsg.getGraph(gn));
        }
        return dsg2;
    }

    private static void copyOver(DatasetGraph dsgDest, DatasetGraph dsgSrc) {
        dsgDest.setDefaultGraph(dsgSrc.getDefaultGraph());
        Iterator<Node> names = dsgSrc.listGraphNodes();
        while (names.hasNext()) {
            Node gn = names.next();
            dsgDest.addGraph(gn, dsgSrc.getGraph(gn));
        }
    }

    public static DatasetGraph create(Graph graph) {
        return new DatasetGraphMapLink(graph);
    }

    public static DatasetGraph wrap(Graph graph) {
        return DatasetGraphOne.create(graph);
    }

    @Deprecated
    public static DatasetGraph createOneGraph(Graph graph) {
        return DatasetGraphFactory.wrap(graph);
    }

    public static interface GraphMaker {
        public Graph create(Node var1);
    }
}

