/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Node_Triple;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarAlloc;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIter1;
import org.apache.jena.sparql.engine.iterator.QueryIterAddTripleTerm;
import org.apache.jena.sparql.engine.iterator.QueryIterTriplePattern;
import org.apache.jena.sparql.serializer.SerializationContext;

public class QueryIterBlockTriplesStar
extends QueryIter1 {
    private final BasicPattern pattern;
    private QueryIterator output;
    static String allocTripleTerms = "*";
    static VarAlloc varAlloc = new VarAlloc(allocTripleTerms);
    private static final boolean TEST_FOR_CONCRETE_TRIPLE_TERM = false;

    public static QueryIterator create(QueryIterator input, BasicPattern pattern, ExecutionContext execContext) {
        return new QueryIterBlockTriplesStar(input, pattern, execContext);
    }

    private QueryIterBlockTriplesStar(QueryIterator input, BasicPattern pattern, ExecutionContext execContext) {
        super(input, execContext);
        this.pattern = pattern;
        QueryIterator chain = this.getInput();
        for (Triple triple : pattern) {
            chain = this.rdfStarTriple(chain, triple);
        }
        this.output = chain;
    }

    @Override
    protected boolean hasNextBinding() {
        return this.output.hasNext();
    }

    @Override
    protected Binding moveToNextBinding() {
        return this.output.nextBinding();
    }

    @Override
    protected void closeSubIterator() {
        if (this.output != null) {
            this.output.close();
        }
        this.output = null;
    }

    @Override
    protected void requestSubCancel() {
        if (this.output != null) {
            this.output.cancel();
        }
    }

    private QueryIterator rdfStarTriple(QueryIterator chain, Triple triple) {
        if (!QueryIterBlockTriplesStar.tripleHasNodeTriple(triple)) {
            return QueryIterBlockTriplesStar.matchData(chain, triple, this.getExecContext());
        }
        return QueryIterBlockTriplesStar.rdfStarTripleSub(chain, triple, this.getExecContext());
    }

    private static QueryIterator rdfStarTripleSub(QueryIterator chain, Triple triple, ExecutionContext execContext) {
        Pair<QueryIterator, Triple> pair = QueryIterBlockTriplesStar.preprocess(chain, triple, execContext);
        QueryIterator chain2 = QueryIterBlockTriplesStar.matchData((QueryIterator)pair.getLeft(), (Triple)pair.getRight(), execContext);
        return chain2;
    }

    private static Pair<QueryIterator, Triple> preprocess(QueryIterator chain, Triple triple, ExecutionContext execContext) {
        Triple tripleTerm;
        Var var;
        Triple t2;
        Triple triple2 = triple;
        Node s = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        Object s1 = null;
        Object o1 = null;
        if (s.isNodeTriple() && !s.isConcrete()) {
            t2 = Node_Triple.triple((Node)s);
            var = varAlloc.allocVar();
            tripleTerm = Triple.create((Node)t2.getSubject(), (Node)t2.getPredicate(), (Node)t2.getObject());
            chain = QueryIterBlockTriplesStar.matchTripleStar(chain, var, tripleTerm, execContext);
            s1 = var;
        }
        if (o.isNodeTriple() && !o.isConcrete()) {
            t2 = Node_Triple.triple((Node)o);
            var = varAlloc.allocVar();
            tripleTerm = Triple.create((Node)t2.getSubject(), (Node)t2.getPredicate(), (Node)t2.getObject());
            chain = QueryIterBlockTriplesStar.matchTripleStar(chain, var, tripleTerm, execContext);
            o1 = var;
        }
        if (s1 == null && o1 == null) {
            return Pair.create((Object)chain, (Object)triple);
        }
        if (s1 == null) {
            s1 = s;
        }
        if (o1 == null) {
            o1 = o;
        }
        Triple triple1 = Triple.create((Node)s1, (Node)p, (Node)o1);
        return Pair.create((Object)chain, (Object)triple1);
    }

    private static QueryIterator matchData(QueryIterator chain, Triple triple, ExecutionContext execContext) {
        QueryIterTriplePattern qIter = new QueryIterTriplePattern(chain, triple, execContext);
        return qIter;
    }

    private static QueryIterator matchTripleStar(QueryIterator chain, Var var, Triple triple, ExecutionContext execContext) {
        if (QueryIterBlockTriplesStar.tripleHasNodeTriple(triple)) {
            Pair<QueryIterator, Triple> pair = QueryIterBlockTriplesStar.preprocess(chain, triple, execContext);
            chain = (QueryIterator)pair.getLeft();
            triple = (Triple)pair.getRight();
        }
        QueryIterAddTripleTerm qIter = new QueryIterAddTripleTerm(chain, var, triple, execContext);
        return qIter;
    }

    private static boolean tripleHasNodeTriple(Triple triple) {
        return triple.getSubject().isNodeTriple() || triple.getObject().isNodeTriple();
    }

    @Override
    protected void details(IndentedWriter out, SerializationContext sCxt) {
        out.print(this.getClass().getSimpleName() + ": " + this.pattern);
    }
}

