/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main.iterator;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.http.Service;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIterCommonParent;
import org.apache.jena.sparql.engine.iterator.QueryIterRepeatApply;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.engine.main.QC;

public class QueryIterService
extends QueryIterRepeatApply {
    OpService opService;

    public QueryIterService(QueryIterator input, OpService opService, ExecutionContext context2) {
        super(input, context2);
        if (context2.getContext().isFalse(Service.serviceAllowed)) {
            throw new QueryExecException("SERVICE not allowed");
        }
        this.opService = opService;
    }

    @Override
    protected QueryIterator nextStage(Binding outerBinding) {
        QueryIterator qIter;
        Op op = QC.substitute(this.opService, outerBinding);
        boolean silent = this.opService.getSilent();
        try {
            qIter = Service.exec((OpService)op, this.getExecContext().getContext());
            qIter = QueryIter.makeTracked(qIter, this.getExecContext());
        }
        catch (RuntimeException ex) {
            if (silent) {
                Log.warn((Object)this, (String)("SERVICE <" + this.opService.getService().toString() + ">: " + ex.getMessage()));
                return QueryIterSingleton.create(outerBinding, this.getExecContext());
            }
            throw ex;
        }
        QueryIterCommonParent qIter2 = new QueryIterCommonParent(qIter, outerBinding, this.getExecContext());
        return qIter2;
    }
}

