/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.jena.JenaRuntime;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.XSDDateTime;
import org.apache.jena.ext.xerces.DatatypeFactoryInst;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprEvalTypeException;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.ExprNode;
import org.apache.jena.sparql.expr.ExprNotComparableException;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.ValueSpaceClassification;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;
import org.apache.jena.sparql.expr.nodevalue.NodeValueBoolean;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDT;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDecimal;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDouble;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDuration;
import org.apache.jena.sparql.expr.nodevalue.NodeValueFloat;
import org.apache.jena.sparql.expr.nodevalue.NodeValueInteger;
import org.apache.jena.sparql.expr.nodevalue.NodeValueLang;
import org.apache.jena.sparql.expr.nodevalue.NodeValueNode;
import org.apache.jena.sparql.expr.nodevalue.NodeValueSortKey;
import org.apache.jena.sparql.expr.nodevalue.NodeValueString;
import org.apache.jena.sparql.expr.nodevalue.NodeValueVisitor;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.sparql.util.RomanNumeral;
import org.apache.jena.sparql.util.RomanNumeralDatatype;
import org.apache.jena.sparql.util.Utils;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeValue
extends ExprNode {
    private static Logger log;
    public static boolean VerboseWarnings;
    public static boolean VerboseExceptions;
    public static final NodeValue TRUE;
    public static final NodeValue FALSE;
    public static final NodeValue nvZERO;
    public static final NodeValue nvNegZERO;
    public static final NodeValue nvONE;
    public static final NodeValue nvTEN;
    public static final NodeValue nvDecimalZERO;
    public static final NodeValue nvDecimalONE;
    public static final NodeValue nvNaN;
    public static final NodeValue nvINF;
    public static final NodeValue nvNegINF;
    public static final NodeValue nvEmptyString;
    private static final String strForUnNode = "node value nothing";
    @Deprecated
    public static final NodeValue nvNothing;
    public static final String xsdNamespace = "http://www.w3.org/2001/XMLSchema#";
    public static DatatypeFactory xmlDatatypeFactory;
    private Node node = null;
    private static final String dtXSDprecisionDecimal = "http://www.w3.org/2001/XMLSchema#precisionDecimal";

    protected NodeValue() {
    }

    protected NodeValue(Node n) {
        this.node = n;
    }

    public static NodeValue parse(String string) {
        return NodeValue.makeNode(NodeFactoryExtra.parseNode(string));
    }

    public static NodeValue makeInteger(long i) {
        return new NodeValueInteger(BigInteger.valueOf(i));
    }

    public static NodeValue makeInteger(BigInteger i) {
        return new NodeValueInteger(i);
    }

    public static NodeValue makeInteger(String lexicalForm) {
        return new NodeValueInteger(new BigInteger(lexicalForm));
    }

    public static NodeValue makeFloat(float f) {
        return new NodeValueFloat(f);
    }

    public static NodeValue makeDouble(double d) {
        return new NodeValueDouble(d);
    }

    public static NodeValue makeString(String s) {
        return new NodeValueString(s);
    }

    public static NodeValue makeSortKey(String s, String collation2) {
        return new NodeValueSortKey(s, collation2);
    }

    public static NodeValue makeLangString(String s, String lang) {
        return new NodeValueLang(s, lang);
    }

    public static NodeValue makeDecimal(BigDecimal d) {
        return new NodeValueDecimal(d);
    }

    public static NodeValue makeDecimal(long i) {
        return new NodeValueDecimal(BigDecimal.valueOf(i));
    }

    public static NodeValue makeDecimal(double d) {
        return new NodeValueDecimal(BigDecimal.valueOf(d));
    }

    public static NodeValue makeDecimal(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, (RDFDatatype)XSDDatatype.XSDdecimal);
    }

    public static NodeValue makeDateTime(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, (RDFDatatype)XSDDatatype.XSDdateTime);
    }

    public static NodeValue makeDate(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, (RDFDatatype)XSDDatatype.XSDdate);
    }

    public static NodeValue makeDateTime(Calendar cal) {
        String lex = DateTimeUtils.calendarToXSDDateTimeString((Calendar)cal);
        return NodeValue.makeNode(lex, (RDFDatatype)XSDDatatype.XSDdateTime);
    }

    public static NodeValue makeDateTime(XMLGregorianCalendar cal) {
        String lex = cal.toXMLFormat();
        Node node = NodeFactory.createLiteral((String)lex, (RDFDatatype)XSDDatatype.XSDdateTime);
        return new NodeValueDT(lex, node);
    }

    public static NodeValue makeDate(Calendar cal) {
        String lex = DateTimeUtils.calendarToXSDDateString((Calendar)cal);
        return NodeValue.makeNode(lex, (RDFDatatype)XSDDatatype.XSDdate);
    }

    public static NodeValue makeDate(XMLGregorianCalendar cal) {
        String lex = cal.toXMLFormat();
        Node node = NodeFactory.createLiteral((String)lex, (RDFDatatype)XSDDatatype.XSDdate);
        return new NodeValueDT(lex, node);
    }

    public static NodeValue makeDuration(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, (RDFDatatype)XSDDatatype.XSDduration);
    }

    public static NodeValue makeDuration(Duration duration) {
        return new NodeValueDuration(duration);
    }

    public static NodeValue makeNodeDuration(Duration duration, Node node) {
        return new NodeValueDuration(duration, node);
    }

    public static NodeValue makeBoolean(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static NodeValue booleanReturn(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static NodeValue makeNode(Node n) {
        NodeValue nv = NodeValue.nodeToNodeValue(n);
        return nv;
    }

    public static NodeValue makeNode(String lexicalForm, RDFDatatype dtype) {
        Node n = NodeFactory.createLiteral((String)lexicalForm, (RDFDatatype)dtype);
        NodeValue nv = NodeValue.makeNode(n);
        return nv;
    }

    public static NodeValue makeNode(String lexicalForm, String langTag, Node datatype) {
        String uri = datatype == null ? null : datatype.getURI();
        return NodeValue.makeNode(lexicalForm, langTag, uri);
    }

    public static NodeValue makeNode(String lexicalForm, String langTag, String datatype) {
        if (datatype != null && datatype.equals("")) {
            datatype = null;
        }
        if (langTag != null && datatype != null) {
            Log.warn(NodeValue.class, (String)("Both lang tag and datatype defined (lexcial form '" + lexicalForm + "')"));
        }
        Node n = null;
        if (langTag != null) {
            n = NodeFactory.createLiteral((String)lexicalForm, (String)langTag);
        } else if (datatype != null) {
            RDFDatatype dType = TypeMapper.getInstance().getSafeTypeByName(datatype);
            n = NodeFactory.createLiteral((String)lexicalForm, (RDFDatatype)dType);
        } else {
            n = NodeFactory.createLiteral((String)lexicalForm);
        }
        return NodeValue.makeNode(n);
    }

    public static NodeValue makeNodeBoolean(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static NodeValue makeNodeBoolean(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSDDatatype.XSDboolean.getURI());
        return nv;
    }

    public static NodeValue makeNodeInteger(long v) {
        NodeValue nv = NodeValue.makeNode(Long.toString(v), null, XSDDatatype.XSDinteger.getURI());
        return nv;
    }

    public static NodeValue makeNodeInteger(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSDDatatype.XSDinteger.getURI());
        return nv;
    }

    public static NodeValue makeNodeFloat(float f) {
        NodeValue nv = NodeValue.makeNode(Utils.stringForm(f), null, XSDDatatype.XSDfloat.getURI());
        return nv;
    }

    public static NodeValue makeNodeFloat(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSDDatatype.XSDdouble.getURI());
        return nv;
    }

    public static NodeValue makeNodeDouble(double v) {
        NodeValue nv = NodeValue.makeNode(Utils.stringForm(v), null, XSDDatatype.XSDdouble.getURI());
        return nv;
    }

    public static NodeValue makeNodeDouble(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSDDatatype.XSDdouble.getURI());
        return nv;
    }

    public static NodeValue makeNodeDecimal(BigDecimal decimal) {
        NodeValue nv = XSDFuncOp.canonicalDecimalNV(decimal);
        return nv;
    }

    public static NodeValue makeNodeDecimal(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSDDatatype.XSDdecimal.getURI());
        return nv;
    }

    public static NodeValue makeNodeString(String string) {
        NodeValue nv = NodeValue.makeNode(string, null, (String)null);
        return nv;
    }

    public static NodeValue makeNodeDateTime(Calendar date2) {
        String lex = DateTimeUtils.calendarToXSDDateTimeString((Calendar)date2);
        NodeValue nv = NodeValue.makeNode(lex, (RDFDatatype)XSDDatatype.XSDdateTime);
        return nv;
    }

    public static NodeValue makeNodeDateTime(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, (RDFDatatype)XSDDatatype.XSDdateTime);
        return nv;
    }

    public static NodeValue makeNodeDate(Calendar date2) {
        String lex = DateTimeUtils.calendarToXSDDateString((Calendar)date2);
        NodeValue nv = NodeValue.makeNode(lex, (RDFDatatype)XSDDatatype.XSDdate);
        return nv;
    }

    public static NodeValue makeNodeDate(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, (RDFDatatype)XSDDatatype.XSDdate);
        return nv;
    }

    @Override
    public NodeValue eval(Binding binding, FunctionEnv env) {
        return this;
    }

    @Override
    public Expr copySubstitute(Binding binding) {
        return this;
    }

    @Override
    public Expr applyNodeTransform(NodeTransform transform) {
        Node n = this.asNode();
        n = (Node)transform.apply(n);
        return NodeValue.makeNode(n);
    }

    public Node evalNode(Binding binding, ExecutionContext execCxt) {
        return this.asNode();
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public NodeValue getConstant() {
        return this;
    }

    public boolean isIRI() {
        if (this.node == null) {
            return false;
        }
        this.forceToNode();
        return this.node.isURI();
    }

    public boolean isBlank() {
        if (this.node == null) {
            return false;
        }
        this.forceToNode();
        return this.node.isBlank();
    }

    public static boolean sameAs(NodeValue nv1, NodeValue nv2) {
        if (nv1 == null || nv2 == null) {
            throw new ARQInternalErrorException("Attempt to sameValueAs on a null");
        }
        ValueSpaceClassification compType = NodeValue.classifyValueOp(nv1, nv2);
        switch (compType) {
            case VSPACE_NUM: {
                return XSDFuncOp.compareNumeric(nv1, nv2) == 0;
            }
            case VSPACE_DATETIME: 
            case VSPACE_DATE: 
            case VSPACE_TIME: 
            case VSPACE_G_YEAR: 
            case VSPACE_G_YEARMONTH: 
            case VSPACE_G_MONTH: 
            case VSPACE_G_MONTHDAY: 
            case VSPACE_G_DAY: {
                int x = XSDFuncOp.compareDateTime(nv1, nv2);
                if (x == 2) {
                    throw new ExprNotComparableException("Indeterminate dateTime comparison");
                }
                return x == 0;
            }
            case VSPACE_DURATION: {
                int x = XSDFuncOp.compareDuration(nv1, nv2);
                if (x == 2) {
                    throw new ExprNotComparableException("Indeterminate duration comparison");
                }
                return x == 0;
            }
            case VSPACE_STRING: {
                return XSDFuncOp.compareString(nv1, nv2) == 0;
            }
            case VSPACE_BOOLEAN: {
                return XSDFuncOp.compareBoolean(nv1, nv2) == 0;
            }
            case VSPACE_LANG: {
                Node node1 = nv1.asNode();
                Node node2 = nv2.asNode();
                return node1.getLiteralLexicalForm().equals(node2.getLiteralLexicalForm()) && node1.getLiteralLanguage().equalsIgnoreCase(node2.getLiteralLanguage());
            }
            case VSPACE_NODE: {
                return NodeFunctions.sameTerm(nv1.getNode(), nv2.getNode());
            }
            case VSPACE_UNKNOWN: {
                Node node1 = nv1.asNode();
                Node node2 = nv2.asNode();
                if (!SystemARQ.ValueExtensions) {
                    return NodeFunctions.rdfTermEquals(node1, node2);
                }
                if (!node1.isLiteral() || !node2.isLiteral()) {
                    return false;
                }
                if (NodeFunctions.sameTerm(node1, node2)) {
                    return true;
                }
                if (!node1.getLiteralLanguage().equals("") || !node2.getLiteralLanguage().equals("")) {
                    return false;
                }
                NodeValue.raise(new ExprEvalException("Unknown equality test: " + nv1 + " and " + nv2));
                throw new ARQInternalErrorException("raise returned (sameValueAs)");
            }
            case VSPACE_SORTKEY: {
                return nv1.getSortKey().compareTo(nv2.getSortKey()) == 0;
            }
            case VSPACE_DIFFERENT: {
                if (!SystemARQ.ValueExtensions && nv1.isLiteral() && nv2.isLiteral()) {
                    NodeValue.raise(new ExprEvalException("Incompatible: " + nv1 + " and " + nv2));
                }
                return false;
            }
        }
        throw new ARQInternalErrorException("sameValueAs failure " + nv1 + " and " + nv2);
    }

    public static boolean notSameAs(Node n1, Node n2) {
        return NodeValue.notSameAs(NodeValue.makeNode(n1), NodeValue.makeNode(n2));
    }

    public static boolean notSameAs(NodeValue nv1, NodeValue nv2) {
        return !NodeValue.sameAs(nv1, nv2);
    }

    public static int compareAlways(NodeValue nv1, NodeValue nv2) {
        try {
            int x = NodeValue.compare(nv1, nv2, true);
            if (x != 0) {
                return x;
            }
        }
        catch (ExprNotComparableException exprNotComparableException) {
            // empty catch block
        }
        return NodeUtils.compareRDFTerms(nv1.asNode(), nv2.asNode());
    }

    public static int compare(NodeValue nv1, NodeValue nv2) {
        if (nv1 == null || nv2 == null) {
            throw new ARQInternalErrorException("Attempt to compare on null");
        }
        int x = NodeValue.compare(nv1, nv2, false);
        return x;
    }

    private static int compare(NodeValue nv1, NodeValue nv2, boolean sortOrderingCompare) {
        if (nv1 == null && nv2 == null) {
            return 0;
        }
        if (nv1 == null) {
            return -1;
        }
        if (nv2 == null) {
            return 1;
        }
        ValueSpaceClassification compType = NodeValue.classifyValueOp(nv1, nv2);
        switch (compType) {
            case VSPACE_DATETIME: 
            case VSPACE_DATE: 
            case VSPACE_TIME: 
            case VSPACE_G_YEAR: 
            case VSPACE_G_YEARMONTH: 
            case VSPACE_G_MONTH: 
            case VSPACE_G_MONTHDAY: 
            case VSPACE_G_DAY: {
                int x = XSDFuncOp.compareDateTime(nv1, nv2);
                if (x != 2) {
                    return x;
                }
                compType = ValueSpaceClassification.VSPACE_DIFFERENT;
                break;
            }
            case VSPACE_DURATION: {
                int x = XSDFuncOp.compareDuration(nv1, nv2);
                if (x == 0) {
                    Duration d1 = nv1.getDuration();
                    Duration d2 = nv2.getDuration();
                    if (XSDFuncOp.isDayTime(d1) && XSDFuncOp.isYearMonth(d2) || XSDFuncOp.isDayTime(d2) && XSDFuncOp.isYearMonth(d1)) {
                        x = 2;
                    }
                }
                if (x != 2) {
                    return x;
                }
                compType = ValueSpaceClassification.VSPACE_DIFFERENT;
                break;
            }
        }
        switch (compType) {
            case VSPACE_DATETIME: 
            case VSPACE_DATE: 
            case VSPACE_TIME: 
            case VSPACE_G_YEAR: 
            case VSPACE_G_YEARMONTH: 
            case VSPACE_G_MONTH: 
            case VSPACE_G_MONTHDAY: 
            case VSPACE_G_DAY: 
            case VSPACE_DURATION: {
                throw new ARQInternalErrorException("Still seeing date/dateTime/time/duration compare type");
            }
            case VSPACE_NUM: {
                return XSDFuncOp.compareNumeric(nv1, nv2);
            }
            case VSPACE_STRING: {
                int cmp = XSDFuncOp.compareString(nv1, nv2);
                if (!sortOrderingCompare) {
                    return cmp;
                }
                if (cmp != 0) {
                    return cmp;
                }
                if (JenaRuntime.isRDF11) {
                    return cmp;
                }
                String dt1 = nv1.asNode().getLiteralDatatypeURI();
                String dt2 = nv2.asNode().getLiteralDatatypeURI();
                if (dt1 == null && dt2 != null) {
                    return -1;
                }
                if (dt2 == null && dt1 != null) {
                    return 1;
                }
                return 0;
            }
            case VSPACE_SORTKEY: {
                return nv1.getSortKey().compareTo(nv2.getSortKey());
            }
            case VSPACE_BOOLEAN: {
                return XSDFuncOp.compareBoolean(nv1, nv2);
            }
            case VSPACE_LANG: {
                Node node1 = nv1.asNode();
                Node node2 = nv2.asNode();
                int x = StrUtils.strCompareIgnoreCase((String)node1.getLiteralLanguage(), (String)node2.getLiteralLanguage());
                if (x != 0) {
                    if (!sortOrderingCompare) {
                        NodeValue.raise(new ExprNotComparableException("Can't compare (different languages) " + nv1 + " and " + nv2));
                    }
                    return x;
                }
                x = StrUtils.strCompare((String)node1.getLiteralLexicalForm(), (String)node2.getLiteralLexicalForm());
                if (x != 0) {
                    return x;
                }
                x = StrUtils.strCompare((String)node1.getLiteralLanguage(), (String)node2.getLiteralLanguage());
                if (x == 0 && !NodeFunctions.sameTerm(node1, node2)) {
                    throw new ARQInternalErrorException("Looks like the same (lang tags) but not node equals");
                }
                return x;
            }
            case VSPACE_NODE: {
                if (sortOrderingCompare) {
                    return NodeUtils.compareRDFTerms(nv1.asNode(), nv2.asNode());
                }
                NodeValue.raise(new ExprNotComparableException("Can't compare (nodes) " + nv1 + " and " + nv2));
                throw new ARQInternalErrorException("NodeValue.raise returned");
            }
            case VSPACE_UNKNOWN: {
                Node node1 = nv1.asNode();
                Node node2 = nv2.asNode();
                if (NodeFunctions.sameTerm(node1, node2)) {
                    return 0;
                }
                if (sortOrderingCompare) {
                    return NodeUtils.compareRDFTerms(node1, node2);
                }
                NodeValue.raise(new ExprNotComparableException("Can't compare " + nv1 + " and " + nv2));
                throw new ARQInternalErrorException("NodeValue.raise returned");
            }
            case VSPACE_DIFFERENT: {
                if (sortOrderingCompare) {
                    return NodeUtils.compareRDFTerms(nv1.asNode(), nv2.asNode());
                }
                NodeValue.raise(new ExprNotComparableException("Can't compare (incompatible value spaces)" + nv1 + " and " + nv2));
                throw new ARQInternalErrorException("NodeValue.raise returned");
            }
        }
        throw new ARQInternalErrorException("Compare failure " + nv1 + " and " + nv2);
    }

    public static ValueSpaceClassification classifyValueOp(NodeValue nv1, NodeValue nv2) {
        ValueSpaceClassification c2;
        ValueSpaceClassification c1 = nv1.getValueSpace();
        if (c1 == (c2 = nv2.getValueSpace())) {
            return c1;
        }
        if (c1 == ValueSpaceClassification.VSPACE_UNKNOWN || c2 == ValueSpaceClassification.VSPACE_UNKNOWN) {
            return ValueSpaceClassification.VSPACE_UNKNOWN;
        }
        return ValueSpaceClassification.VSPACE_DIFFERENT;
    }

    public ValueSpaceClassification getValueSpace() {
        return NodeValue.classifyValueSpace(this);
    }

    private static ValueSpaceClassification classifyValueSpace(NodeValue nv) {
        if (nv.isNumber()) {
            return ValueSpaceClassification.VSPACE_NUM;
        }
        if (nv.isDateTime()) {
            return ValueSpaceClassification.VSPACE_DATETIME;
        }
        if (nv.isString()) {
            return ValueSpaceClassification.VSPACE_STRING;
        }
        if (nv.isBoolean()) {
            return ValueSpaceClassification.VSPACE_BOOLEAN;
        }
        if (!nv.isLiteral()) {
            return ValueSpaceClassification.VSPACE_NODE;
        }
        if (!SystemARQ.ValueExtensions) {
            return ValueSpaceClassification.VSPACE_UNKNOWN;
        }
        if (nv.isDate()) {
            return ValueSpaceClassification.VSPACE_DATE;
        }
        if (nv.isTime()) {
            return ValueSpaceClassification.VSPACE_TIME;
        }
        if (nv.isDuration()) {
            return ValueSpaceClassification.VSPACE_DURATION;
        }
        if (nv.isGYear()) {
            return ValueSpaceClassification.VSPACE_G_YEAR;
        }
        if (nv.isGYearMonth()) {
            return ValueSpaceClassification.VSPACE_G_YEARMONTH;
        }
        if (nv.isGMonth()) {
            return ValueSpaceClassification.VSPACE_G_MONTH;
        }
        if (nv.isGMonthDay()) {
            return ValueSpaceClassification.VSPACE_G_MONTHDAY;
        }
        if (nv.isGDay()) {
            return ValueSpaceClassification.VSPACE_G_DAY;
        }
        if (nv.isSortKey()) {
            return ValueSpaceClassification.VSPACE_SORTKEY;
        }
        if (NodeUtils.hasLang(nv.asNode())) {
            return ValueSpaceClassification.VSPACE_LANG;
        }
        return ValueSpaceClassification.VSPACE_UNKNOWN;
    }

    public static Node toNode(NodeValue nv) {
        if (nv == null) {
            return null;
        }
        return nv.asNode();
    }

    public final Node asNode() {
        if (this.node == null) {
            this.node = this.makeNode();
        }
        return this.node;
    }

    protected abstract Node makeNode();

    public Node getNode() {
        return this.node;
    }

    public String getDatatypeURI() {
        return this.asNode().getLiteralDatatypeURI();
    }

    public boolean hasNode() {
        return this.node != null;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isLangString() {
        return false;
    }

    public boolean isSortKey() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isDecimal() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean hasDateTime() {
        return this.isDateTime() || this.isDate() || this.isTime() || this.isGYear() || this.isGYearMonth() || this.isGMonth() || this.isGMonthDay() || this.isGDay();
    }

    public boolean isDateTime() {
        return false;
    }

    public boolean isDate() {
        return false;
    }

    public boolean isLiteral() {
        return this.getNode() == null || this.getNode().isLiteral();
    }

    public boolean isTime() {
        return false;
    }

    public boolean isDuration() {
        return false;
    }

    @Deprecated
    public boolean isYearMonth() {
        return this.isYearMonthDuration();
    }

    public boolean isYearMonthDuration() {
        if (!this.isDuration()) {
            return false;
        }
        Duration dur = this.getDuration();
        return (dur.isSet(DatatypeConstants.YEARS) || dur.isSet(DatatypeConstants.MONTHS)) && !dur.isSet(DatatypeConstants.DAYS) && !dur.isSet(DatatypeConstants.HOURS) && !dur.isSet(DatatypeConstants.MINUTES) && !dur.isSet(DatatypeConstants.SECONDS);
    }

    public boolean isDayTimeDuration() {
        if (!this.isDuration()) {
            return false;
        }
        Duration dur = this.getDuration();
        return !dur.isSet(DatatypeConstants.YEARS) && !dur.isSet(DatatypeConstants.MONTHS) && (dur.isSet(DatatypeConstants.DAYS) || dur.isSet(DatatypeConstants.HOURS) || dur.isSet(DatatypeConstants.MINUTES) || dur.isSet(DatatypeConstants.SECONDS));
    }

    public boolean isGYear() {
        return false;
    }

    public boolean isGYearMonth() {
        return false;
    }

    public boolean isGMonth() {
        return false;
    }

    public boolean isGMonthDay() {
        return false;
    }

    public boolean isGDay() {
        return false;
    }

    public boolean getBoolean() {
        NodeValue.raise(new ExprEvalTypeException("Not a boolean: " + this));
        return false;
    }

    public String getString() {
        NodeValue.raise(new ExprEvalTypeException("Not a string: " + this));
        return null;
    }

    public String getLang() {
        NodeValue.raise(new ExprEvalTypeException("Not a string: " + this));
        return null;
    }

    public NodeValueSortKey getSortKey() {
        NodeValue.raise(new ExprEvalTypeException("Not a sort key: " + this));
        return null;
    }

    public BigInteger getInteger() {
        NodeValue.raise(new ExprEvalTypeException("Not an integer: " + this));
        return null;
    }

    public BigDecimal getDecimal() {
        NodeValue.raise(new ExprEvalTypeException("Not a decimal: " + this));
        return null;
    }

    public float getFloat() {
        NodeValue.raise(new ExprEvalTypeException("Not a float: " + this));
        return Float.NaN;
    }

    public double getDouble() {
        NodeValue.raise(new ExprEvalTypeException("Not a double: " + this));
        return Double.NaN;
    }

    public XMLGregorianCalendar getDateTime() {
        NodeValue.raise(new ExprEvalTypeException("No DateTime value: " + this));
        return null;
    }

    public Duration getDuration() {
        NodeValue.raise(new ExprEvalTypeException("Not a duration: " + this));
        return null;
    }

    private static NodeValue nodeToNodeValue(Node node) {
        boolean isPlainLiteral;
        if (node.isVariable()) {
            Log.warn(NodeValue.class, (String)"Variable passed to NodeValue.nodeToNodeValue");
        }
        if (!node.isLiteral()) {
            return new NodeValueNode(node);
        }
        boolean hasLangTag = NodeUtils.isLangString(node);
        boolean bl = isPlainLiteral = node.getLiteralDatatypeURI() == null && !hasLangTag;
        if (isPlainLiteral) {
            return new NodeValueString(node.getLiteralLexicalForm(), node);
        }
        if (hasLangTag) {
            if (node.getLiteralDatatype() != null && !RDF.dtLangString.equals(node.getLiteralDatatype()) && VerboseWarnings) {
                Log.warn(NodeValue.class, (String)"Lang tag and datatype (datatype ignored)");
            }
            return new NodeValueLang(node);
        }
        LiteralLabel lit = node.getLiteral();
        if (!node.getLiteral().isWellFormed()) {
            if (VerboseWarnings) {
                String tmp = FmtUtils.stringForNode(node);
                Log.warn(NodeValue.class, (String)("Datatype format exception: " + tmp));
            }
            return new NodeValueNode(node);
        }
        NodeValue nv = NodeValue._setByValue(node);
        if (nv != null) {
            return nv;
        }
        return new NodeValueNode(node);
    }

    private static NodeValue _setByValue(Node node) {
        if (NodeUtils.hasLang(node)) {
            return new NodeValueLang(node);
        }
        LiteralLabel lit = node.getLiteral();
        String lex = lit.getLexicalForm();
        RDFDatatype datatype = lit.getDatatype();
        String datatypeURI = datatype.getURI();
        if (!datatypeURI.startsWith(xsdNamespace) && !SystemARQ.EnableRomanNumerals) {
            return null;
        }
        try {
            if (XSDDatatype.XSDstring.isValidLiteral(lit)) {
                return new NodeValueString(lit.getLexicalForm(), node);
            }
            if (!datatype.equals(XSDDatatype.XSDdecimal) && XSDDatatype.XSDinteger.isValidLiteral(lit)) {
                String s = node.getLiteralLexicalForm().trim();
                if (s.startsWith("+")) {
                    s = s.substring(1);
                }
                BigInteger integer = new BigInteger(s);
                return new NodeValueInteger(integer, node);
            }
            if (datatype.equals(XSDDatatype.XSDdecimal) && XSDDatatype.XSDdecimal.isValidLiteral(lit)) {
                BigDecimal decimal = new BigDecimal(lit.getLexicalForm());
                return new NodeValueDecimal(decimal, node);
            }
            if (datatype.equals(XSDDatatype.XSDfloat) && XSDDatatype.XSDfloat.isValidLiteral(lit)) {
                float f = ((Number)lit.getValue()).floatValue();
                return new NodeValueFloat(f, node);
            }
            if (datatype.equals(XSDDatatype.XSDdouble) && XSDDatatype.XSDdouble.isValidLiteral(lit)) {
                double d = ((Number)lit.getValue()).doubleValue();
                return new NodeValueDouble(d, node);
            }
            if ((datatype.equals(XSDDatatype.XSDdateTime) || datatype.equals(XSDDatatype.XSDdateTimeStamp)) && XSDDatatype.XSDdateTime.isValid(lex)) {
                return new NodeValueDT(lex, node);
            }
            if (datatype.equals(XSDDatatype.XSDdate) && XSDDatatype.XSDdate.isValidLiteral(lit)) {
                return new NodeValueDT(lex, node);
            }
            if (datatype.equals(XSDDatatype.XSDtime) && XSDDatatype.XSDtime.isValidLiteral(lit)) {
                return new NodeValueDT(lex, node);
            }
            if (datatype.equals(XSDDatatype.XSDgYear) && XSDDatatype.XSDgYear.isValidLiteral(lit)) {
                return new NodeValueDT(lex, node);
            }
            if (datatype.equals(XSDDatatype.XSDgYearMonth) && XSDDatatype.XSDgYearMonth.isValidLiteral(lit)) {
                return new NodeValueDT(lex, node);
            }
            if (datatype.equals(XSDDatatype.XSDgMonth) && XSDDatatype.XSDgMonth.isValidLiteral(lit)) {
                XSDDateTime time = (XSDDateTime)lit.getValue();
                return new NodeValueDT(lex, node);
            }
            if (datatype.equals(XSDDatatype.XSDgMonthDay) && XSDDatatype.XSDgMonthDay.isValidLiteral(lit)) {
                XSDDateTime time = (XSDDateTime)lit.getValue();
                return new NodeValueDT(lex, node);
            }
            if (datatype.equals(XSDDatatype.XSDgDay) && XSDDatatype.XSDgDay.isValidLiteral(lit)) {
                XSDDateTime time = (XSDDateTime)lit.getValue();
                return new NodeValueDT(lex, node);
            }
            if (datatype.equals(XSDDatatype.XSDduration) && XSDDatatype.XSDduration.isValid(lex)) {
                Duration duration = xmlDatatypeFactory.newDuration(lex);
                return new NodeValueDuration(duration, node);
            }
            if (datatype.equals(XSDDatatype.XSDyearMonthDuration) && XSDDatatype.XSDyearMonthDuration.isValid(lex)) {
                Duration duration = xmlDatatypeFactory.newDuration(lex);
                return new NodeValueDuration(duration, node);
            }
            if (datatype.equals(XSDDatatype.XSDdayTimeDuration) && XSDDatatype.XSDdayTimeDuration.isValid(lex)) {
                Duration duration = xmlDatatypeFactory.newDuration(lex);
                return new NodeValueDuration(duration, node);
            }
            if (datatype.equals(XSDDatatype.XSDboolean) && XSDDatatype.XSDboolean.isValidLiteral(lit)) {
                boolean b = (Boolean)lit.getValue();
                return new NodeValueBoolean(b, node);
            }
            if (SystemARQ.EnableRomanNumerals && lit.getDatatypeURI().equals(RomanNumeralDatatype.get().getURI())) {
                Object obj = RomanNumeralDatatype.get().parse(lit.getLexicalForm());
                if (obj instanceof Integer) {
                    return new NodeValueInteger(((Integer)obj).longValue());
                }
                if (obj instanceof RomanNumeral) {
                    return new NodeValueInteger(((RomanNumeral)obj).intValue());
                }
                throw new ARQInternalErrorException("DatatypeFormatException: Roman numeral is unknown class");
            }
        }
        catch (DatatypeFormatException ex) {
            throw new ARQInternalErrorException("DatatypeFormatException: " + lit, ex);
        }
        return null;
    }

    public static void raise(ExprException ex) {
        throw ex;
    }

    @Override
    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    private void forceToNode() {
        if (this.node == null) {
            this.node = this.asNode();
        }
        if (this.node == null) {
            NodeValue.raise(new ExprEvalException("Not a node: " + this));
        }
    }

    public final String asUnquotedString() {
        return this.asString();
    }

    public final String asQuotedString() {
        return this.asQuotedString(new SerializationContext());
    }

    public final String asQuotedString(SerializationContext context2) {
        if (this.node == null) {
            this.node = this.asNode();
        }
        if (this.node != null) {
            return FmtUtils.stringForNode(this.node, context2);
        }
        return this.toString();
    }

    public String asString() {
        this.forceToNode();
        return NodeFunctions.str(this.node);
    }

    @Override
    public int hashCode() {
        return this.asNode().hashCode();
    }

    @Override
    public boolean equals(Expr other, boolean bySyntax) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof NodeValue)) {
            return false;
        }
        NodeValue nv = (NodeValue)other;
        return this.asNode().equals((Object)nv.asNode());
    }

    public abstract void visit(NodeValueVisitor var1);

    public Expr apply(ExprTransform transform) {
        return transform.transform(this);
    }

    @Override
    public String toString() {
        return this.asQuotedString();
    }

    static {
        JenaSystem.init();
        log = LoggerFactory.getLogger(NodeValue.class);
        VerboseWarnings = true;
        VerboseExceptions = false;
        TRUE = NodeValue.makeNode("true", (RDFDatatype)XSDDatatype.XSDboolean);
        FALSE = NodeValue.makeNode("false", (RDFDatatype)XSDDatatype.XSDboolean);
        nvZERO = NodeValue.makeNode(NodeConst.nodeZero);
        nvNegZERO = NodeValue.makeNode("-0.0e0", (RDFDatatype)XSDDatatype.XSDdouble);
        nvONE = NodeValue.makeNode(NodeConst.nodeOne);
        nvTEN = NodeValue.makeNode(NodeConst.nodeTen);
        nvDecimalZERO = NodeValue.makeNode("0.0", (RDFDatatype)XSDDatatype.XSDdecimal);
        nvDecimalONE = NodeValue.makeNode("1.0", (RDFDatatype)XSDDatatype.XSDdecimal);
        nvNaN = NodeValue.makeNode("NaN", (RDFDatatype)XSDDatatype.XSDdouble);
        nvINF = NodeValue.makeNode("INF", (RDFDatatype)XSDDatatype.XSDdouble);
        nvNegINF = NodeValue.makeNode("-INF", (RDFDatatype)XSDDatatype.XSDdouble);
        nvEmptyString = NodeValue.makeString("");
        nvNothing = NodeValue.makeNode(NodeFactory.createBlankNode((String)strForUnNode));
        xmlDatatypeFactory = DatatypeFactoryInst.newDatatypeFactory();
    }
}

