/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.nodevalue;

import java.math.BigDecimal;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeValueVisitor;
import org.apache.jena.sparql.util.Utils;

public class NodeValueDouble
extends NodeValue {
    double value = Double.NaN;

    public NodeValueDouble(double d) {
        this.value = d;
    }

    public NodeValueDouble(double d, Node n) {
        super(n);
        this.value = d;
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public BigDecimal getDecimal() {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    protected Node makeNode() {
        return NodeFactory.createLiteral((String)Utils.stringForm(this.value), (RDFDatatype)XSDDatatype.XSDdouble);
    }

    @Override
    public String asString() {
        return this.toString();
    }

    @Override
    public String toString() {
        if (this.getNode() != null) {
            return super.asString();
        }
        return Utils.stringForm(this.value);
    }

    @Override
    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }
}

