/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.sparql.graph.PrefixMappingBase;

public class PrefixMappingAdapter
extends PrefixMappingBase {
    private final PrefixMap pmap;

    public PrefixMappingAdapter(PrefixMap pmap) {
        this.pmap = pmap;
    }

    @Override
    protected void add(String prefix, String uri) {
        this.pmap.add(prefix, uri);
    }

    @Override
    protected void remove(String prefix) {
        this.pmap.delete(prefix);
    }

    @Override
    protected void clear() {
        this.pmap.clear();
    }

    @Override
    protected boolean isEmpty() {
        return this.pmap.isEmpty();
    }

    @Override
    protected int size() {
        return this.pmap.size();
    }

    @Override
    protected String prefixToUri(String prefix) {
        return this.pmap.getMapping().get(prefix);
    }

    @Override
    protected String uriToPrefix(String uri) {
        return this.pmap.getMapping().entrySet().stream().filter(e2 -> Objects.equals(uri, ((String)e2.getValue()).toString())).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    @Override
    protected Map<String, String> asMap() {
        return this.pmap.getMapping();
    }

    @Override
    protected Map<String, String> asMapCopy() {
        return this.pmap.getMappingCopy();
    }

    @Override
    protected void apply(BiConsumer<String, String> action) {
        this.pmap.forEach(action);
    }
}

