/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jena.sparql.engine;

import java.util.List ;

import org.apache.jena.query.QuerySolution ;
import org.apache.jena.query.ResultSet ;
import org.apache.jena.rdf.model.Model ;
import org.apache.jena.sparql.engine.binding.Binding ;

/** Wrap another {@link ResultSet} (probably to modify operations on it). */
public class ResultSetWrapper implements ResultSet {
    
    private final ResultSet rs;

    public ResultSetWrapper(ResultSet rs) {
        this.rs = rs ;
    }
    
    protected ResultSet get() { return rs ; }

    @Override
    public boolean hasNext() {
        return get().hasNext() ;
    }

    @Override
    public QuerySolution next() {
        return get().next();
    }

    @Override
    public QuerySolution nextSolution() {
        return get().nextSolution();
    }

    @Override
    public Binding nextBinding() {
        return get().nextBinding();
    }

    @Override
    public int getRowNumber() {
        return get().getRowNumber() ;
    }

    @Override
    public List<String> getResultVars() {
        return get().getResultVars() ;
    }

    @Override
    public Model getResourceModel() {
        return get().getResourceModel() ;
    }
    
}