/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.shared.LockMRPlusSW;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.DatasetGraphTriplesQuads;
import org.apache.jena.sparql.core.DatasetPrefixStorage;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.mem.DatasetPrefixStorageInMemory;
import org.apache.jena.sparql.core.mem.GraphInMemory;
import org.apache.jena.sparql.core.mem.HexTable;
import org.apache.jena.sparql.core.mem.QuadTable;
import org.apache.jena.sparql.core.mem.TriTable;
import org.apache.jena.sparql.core.mem.TripleTable;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetGraphInMemory
extends DatasetGraphTriplesQuads
implements Transactional {
    private static final Logger log = LoggerFactory.getLogger(DatasetGraphInMemory.class);
    private final DatasetPrefixStorage prefixes = new DatasetPrefixStorageInMemory();
    private final org.apache.jena.shared.Lock transactionLock = new LockMRPlusSW();
    private final ReentrantLock systemLock = new ReentrantLock(true);
    private final AtomicLong generation = new AtomicLong(0L);
    private final ThreadLocal<Long> version = ThreadLocal.withInitial(() -> 0L);
    private final ThreadLocal<Boolean> isInTransaction = ThreadLocal.withInitial(() -> false);
    private final ThreadLocal<ReadWrite> transactionType = ThreadLocal.withInitial(() -> null);
    private final QuadTable quadsIndex;
    private final TripleTable defaultGraph;
    private final Consumer<Graph> removeGraph = g -> g.find(Node.ANY, Node.ANY, Node.ANY).forEachRemaining(arg_0 -> ((Graph)g).delete(arg_0));
    public static boolean promotion = false;
    public static boolean readCommittedPromotion = true;

    @Override
    public boolean isInTransaction() {
        return this.isInTransaction.get();
    }

    protected void isInTransaction(boolean b) {
        this.isInTransaction.set(b);
    }

    public ReadWrite transactionType() {
        return this.transactionType.get();
    }

    protected void transactionType(ReadWrite readWrite) {
        this.transactionType.set(readWrite);
    }

    private QuadTable quadsIndex() {
        return this.quadsIndex;
    }

    private TripleTable defaultGraph() {
        return this.defaultGraph;
    }

    public DatasetGraphInMemory() {
        this(new HexTable(), new TriTable());
    }

    public DatasetGraphInMemory(QuadTable i, TripleTable t) {
        this.quadsIndex = i;
        this.defaultGraph = t;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionAbort() {
        return true;
    }

    @Override
    public void begin(ReadWrite readWrite) {
        if (this.isInTransaction()) {
            throw new JenaTransactionException("Transactions cannot be nested!");
        }
        this.startTransaction(readWrite);
        this._begin(readWrite);
    }

    private void _begin(ReadWrite readWrite) {
        DatasetGraphInMemory.withLock(this.systemLock, () -> {
            this.quadsIndex().begin(readWrite);
            this.defaultGraph().begin(readWrite);
            this.version.set(this.generation.get());
        });
    }

    private void startTransaction(ReadWrite mode) {
        this.transactionLock.enterCriticalSection(mode.equals((Object)ReadWrite.READ));
        this.transactionType(mode);
        this.isInTransaction(true);
    }

    private void finishTransaction() {
        this.isInTransaction.remove();
        this.transactionType.remove();
        this.version.remove();
        this.transactionLock.leaveCriticalSection();
    }

    @Override
    public void commit() {
        if (!this.isInTransaction()) {
            throw new JenaTransactionException("Tried to commit outside a transaction!");
        }
        if (this.transactionType().equals((Object)ReadWrite.WRITE)) {
            this._commit();
        }
        this.finishTransaction();
    }

    private void _commit() {
        DatasetGraphInMemory.withLock(this.systemLock, () -> {
            this.quadsIndex().commit();
            this.defaultGraph().commit();
            this.quadsIndex().end();
            this.defaultGraph().end();
            if (this.transactionType().equals((Object)ReadWrite.WRITE)) {
                if (this.version.get().longValue() != this.generation.get()) {
                    throw new InternalErrorException(String.format("Version=%d, Generation=%d", this.version.get(), this.generation.get()));
                }
                this.generation.incrementAndGet();
            }
        });
    }

    @Override
    public void abort() {
        if (!this.isInTransaction()) {
            throw new JenaTransactionException("Tried to abort outside a transaction!");
        }
        if (this.transactionType().equals((Object)ReadWrite.WRITE)) {
            this._abort();
        }
        this.finishTransaction();
    }

    private void _abort() {
        DatasetGraphInMemory.withLock(this.systemLock, () -> {
            this.quadsIndex().abort();
            this.defaultGraph().abort();
            this.quadsIndex().end();
            this.defaultGraph().end();
        });
    }

    @Override
    public void close() {
        if (this.isInTransaction()) {
            this.abort();
        }
    }

    @Override
    public void end() {
        if (this.isInTransaction()) {
            if (this.transactionType().equals((Object)ReadWrite.WRITE)) {
                log.warn("end() called for WRITE transaction without commit or abort having been called. This causes a forced abort.");
                this._abort();
            } else {
                this._end();
            }
            this.finishTransaction();
        }
    }

    private void _end() {
        DatasetGraphInMemory.withLock(this.systemLock, () -> {
            this.quadsIndex().end();
            this.defaultGraph().end();
        });
    }

    private static void withLock(Lock lock, Runnable action) {
        lock.lock();
        try {
            action.run();
        }
        finally {
            lock.unlock();
        }
    }

    private <T> Iterator<T> access(Supplier<Iterator<T>> source) {
        if (!this.isInTransaction()) {
            this.begin(ReadWrite.READ);
            try {
                Iterator<T> iterator = source.get();
                return iterator;
            }
            finally {
                this.end();
            }
        }
        return source.get();
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return this.access(() -> this.quadsIndex().listGraphNodes().iterator());
    }

    private Iterator<Quad> quadsFinder(Node g, Node s, Node p, Node o) {
        if (Quad.isUnionGraph(g)) {
            return this.findInUnionGraph$(s, p, o);
        }
        return this.quadsIndex().find(g, s, p, o).iterator();
    }

    private Iterator<Quad> findInUnionGraph$(Node s, Node p, Node o) {
        return this.access(() -> this.quadsIndex().findInUnionGraph(s, p, o).iterator());
    }

    private Iterator<Quad> triplesFinder(Node s, Node p, Node o) {
        return GraphUtils.triples2quadsDftGraph(this.defaultGraph().find(s, p, o).iterator());
    }

    @Override
    public void setDefaultGraph(Graph g) {
        this.mutate(graph -> {
            this.defaultGraph().clear();
            graph.find(Node.ANY, Node.ANY, Node.ANY).forEachRemaining(t -> this.addToDftGraph(t.getSubject(), t.getPredicate(), t.getObject()));
        }, g);
    }

    @Override
    public Graph getGraph(Node graphNode) {
        return new GraphInMemory(this, graphNode);
    }

    @Override
    public Graph getDefaultGraph() {
        return this.getGraph(Quad.defaultGraphNodeGenerated);
    }

    private Consumer<Graph> addGraph(Node name) {
        return g -> g.find(Node.ANY, Node.ANY, Node.ANY).forEachRemaining(t -> this.add(new Quad(name, (Triple)t)));
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
        this.mutate(this.addGraph(graphName), graph);
    }

    @Override
    public void removeGraph(Node graphName) {
        this.mutate(this.removeGraph, this.getGraph(graphName));
        this.prefixes().removeAllFromPrefixMap(graphName.getURI());
    }

    private <T> void mutate(Consumer<T> mutator, T payload) {
        if (!this.isInTransaction()) {
            this.begin(ReadWrite.WRITE);
            try {
                mutator.accept(payload);
                this.commit();
            }
            finally {
                this.end();
            }
            return;
        }
        if (!this.transactionType().equals((Object)ReadWrite.WRITE)) {
            if (!promotion) {
                throw new JenaTransactionException("Tried to write inside a READ transaction!");
            }
            this.promote(readCommittedPromotion);
        }
        mutator.accept(payload);
    }

    private void promote(boolean readCommited) {
        if (!readCommited && this.version.get().longValue() != this.generation.get()) {
            throw new JenaTransactionException("Dataset changed - can't promote");
        }
        this.transactionLock.enterCriticalSection(false);
        if (!readCommited && this.version.get().longValue() != this.generation.get()) {
            this.transactionLock.leaveCriticalSection();
            throw new JenaTransactionException("Concurrent writer changed the dataset : can't promote");
        }
        this.transactionType(ReadWrite.WRITE);
        this._begin(ReadWrite.WRITE);
    }

    public DatasetPrefixStorage prefixes() {
        return this.prefixes;
    }

    @Override
    public long size() {
        return this.quadsIndex().listGraphNodes().count();
    }

    @Override
    public void clear() {
        this.mutate(x -> {
            this.defaultGraph().clear();
            this.quadsIndex().clear();
        }, null);
    }

    @Override
    protected void addToDftGraph(Node s, Node p, Node o) {
        this.mutate(this.defaultGraph()::add, Triple.create((Node)s, (Node)p, (Node)o));
    }

    @Override
    protected void addToNamedGraph(Node g, Node s, Node p, Node o) {
        this.mutate(this.quadsIndex()::add, Quad.create(g, s, p, o));
    }

    @Override
    protected void deleteFromDftGraph(Node s, Node p, Node o) {
        this.mutate(this.defaultGraph()::delete, Triple.create((Node)s, (Node)p, (Node)o));
    }

    @Override
    protected void deleteFromNamedGraph(Node g, Node s, Node p, Node o) {
        this.mutate(this.quadsIndex()::delete, Quad.create(g, s, p, o));
    }

    @Override
    protected Iterator<Quad> findInDftGraph(Node s, Node p, Node o) {
        return this.access(() -> this.triplesFinder(s, p, o));
    }

    @Override
    protected Iterator<Quad> findInSpecificNamedGraph(Node g, Node s, Node p, Node o) {
        return this.access(() -> this.quadsFinder(g, s, p, o));
    }

    @Override
    protected Iterator<Quad> findInAnyNamedGraphs(Node s, Node p, Node o) {
        return this.findInSpecificNamedGraph(Node.ANY, s, p, o);
    }
}

