/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.util.stream.Stream;
import org.apache.jena.atlas.lib.persistent.PersistentSet;
import org.apache.jena.atlas.lib.tuple.TConsumer4;
import org.apache.jena.atlas.lib.tuple.TFunction4;
import org.apache.jena.atlas.lib.tuple.TupleMap;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.mem.FourTupleMap;
import org.apache.jena.sparql.core.mem.PMapTupleTable;
import org.apache.jena.sparql.core.mem.QuadTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMapQuadTable
extends PMapTupleTable<FourTupleMap, Quad, TConsumer4<Node>>
implements QuadTable {
    private static final Logger log = LoggerFactory.getLogger(PMapQuadTable.class);
    private TFunction4<Node, Stream<Quad>> find = (first, second, third, fourth) -> {
        this.debug("Querying on four-tuple pattern: {} {} {} {} .", first, second, third, fourth);
        FourTupleMap fourTuples = (FourTupleMap)((Object)((Object)this.local().get()));
        if (this.isConcrete((Node)first)) {
            this.debug("Using a specific first slot value.", new Object[0]);
            return fourTuples.get(first).map((? super T threeTuples) -> {
                if (this.isConcrete((Node)second)) {
                    this.debug("Using a specific second slot value.", new Object[0]);
                    return threeTuples.get(second).map((? super T twoTuples) -> {
                        if (this.isConcrete((Node)third)) {
                            this.debug("Using a specific third slot value.", new Object[0]);
                            return twoTuples.get(third).map((? super T oneTuples) -> {
                                if (this.isConcrete((Node)fourth)) {
                                    this.debug("Using a specific fourth slot value.", new Object[0]);
                                    return oneTuples.contains(fourth) ? Stream.of(this.unmap((Node)first, (Node)second, (Node)third, (Node)fourth)) : Stream.empty();
                                }
                                this.debug("Using a wildcard fourth slot value.", new Object[0]);
                                return oneTuples.stream().map((? super T slot4) -> this.unmap((Node)first, (Node)second, (Node)third, (Node)slot4));
                            }).orElse(Stream.empty());
                        }
                        this.debug("Using wildcard third and fourth slot values.", new Object[0]);
                        return twoTuples.flatten((slot3, oneTuples) -> oneTuples.stream().map((? super T slot4) -> this.unmap((Node)first, (Node)second, (Node)slot3, (Node)slot4)));
                    }).orElse(Stream.empty());
                }
                this.debug("Using wildcard second, third and fourth slot values.", new Object[0]);
                return threeTuples.flatten((slot2, twoTuples) -> twoTuples.flatten((slot3, oneTuples) -> oneTuples.stream().map((? super T slot4) -> this.unmap((Node)first, (Node)slot2, (Node)slot3, (Node)slot4))));
            }).orElse(Stream.empty());
        }
        this.debug("Using a wildcard for all slot values.", new Object[0]);
        return fourTuples.flatten((slot1, threeTuples) -> threeTuples.flatten((slot2, twoTuples) -> twoTuples.flatten((slot3, oneTuples) -> oneTuples.stream().map((? super T slot4) -> this.unmap((Node)slot1, (Node)slot2, (Node)slot3, (Node)slot4)))));
    };

    public PMapQuadTable(String order) {
        this("GSPO", order);
    }

    public PMapQuadTable(String canonical, String order) {
        this(canonical + "->" + order, TupleMap.create((String)canonical, (String)order));
    }

    public PMapQuadTable(String tableName, TupleMap order) {
        super(tableName, order);
    }

    @Override
    protected Logger log() {
        return log;
    }

    @Override
    protected FourTupleMap initial() {
        return new FourTupleMap();
    }

    @Override
    public void add(Quad q) {
        this.map(this.add()).accept(q);
    }

    @Override
    public void delete(Quad q) {
        this.map(this.delete()).accept(q);
    }

    @Override
    public Stream<Quad> find(Node g, Node s, Node p, Node o) {
        return (Stream)this.map(this.find).apply((Object)g, (Object)s, (Object)p, (Object)o);
    }

    @Override
    protected TConsumer4<Node> add() {
        return (first, second, third, fourth) -> {
            this.debug("Adding four-tuple: {} {} {} {} .", first, second, third, fourth);
            FourTupleMap fourTuples = (FourTupleMap)((Object)((Object)this.local().get()));
            FourTupleMap.ThreeTupleMap threeTuples = fourTuples.get(first).orElse(new FourTupleMap.ThreeTupleMap());
            FourTupleMap.TwoTupleMap twoTuples = threeTuples.get(second).orElse(new FourTupleMap.TwoTupleMap());
            PersistentSet oneTuples = twoTuples.get(third).orElse(PersistentSet.empty());
            if (!oneTuples.contains(fourth)) {
                oneTuples = oneTuples.plus(fourth);
            }
            twoTuples = (FourTupleMap.TwoTupleMap)((FourTupleMap.TwoTupleMap)twoTuples.minus(third)).plus(third, oneTuples);
            threeTuples = (FourTupleMap.ThreeTupleMap)((FourTupleMap.ThreeTupleMap)threeTuples.minus(second)).plus(second, (Object)twoTuples);
            this.debug("Setting transactional index to new value.", new Object[0]);
            this.local().set(((FourTupleMap)fourTuples.minus(first)).plus(first, (Object)threeTuples));
        };
    }

    @Override
    protected TConsumer4<Node> delete() {
        return (first, second, third, fourth) -> {
            this.debug("Removing four-tuple: {} {} {} {} .", first, second, third, fourth);
            FourTupleMap fourTuples = (FourTupleMap)((Object)((Object)this.local().get()));
            fourTuples.get(first).ifPresent(threeTuples -> threeTuples.get(second).ifPresent(twoTuples -> twoTuples.get(third).ifPresent(oneTuples -> {
                if (oneTuples.contains(fourth)) {
                    oneTuples = oneTuples.minus(fourth);
                    FourTupleMap.TwoTupleMap newTwoTuples = (FourTupleMap.TwoTupleMap)((FourTupleMap.TwoTupleMap)twoTuples.minus(third)).plus(third, oneTuples);
                    FourTupleMap.ThreeTupleMap newThreeTuples = (FourTupleMap.ThreeTupleMap)((FourTupleMap.ThreeTupleMap)threeTuples.minus(second)).plus(second, (Object)newTwoTuples);
                    this.debug("Setting transactional index to new value.", new Object[0]);
                    this.local().set(((FourTupleMap)fourTuples.minus(first)).plus(first, (Object)newThreeTuples));
                }
            })));
        };
    }
}

