/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.FactoryRDF;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.stream.StreamManager;
import org.apache.jena.riot.web.HttpOp;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;

public class RDFParserBuilder {
    private String uri = null;
    private Path path = null;
    private String content = null;
    private InputStream inputStream;
    private Reader javaReader = null;
    private StreamManager streamManager = null;
    private Map<String, String> httpHeaders = new HashMap<String, String>();
    private HttpClient httpClient = null;
    private Lang hintLang = null;
    private Lang forceLang = null;
    private String baseUri = null;
    private boolean canonicalValues = false;
    private RDFParser.LangTagForm langTagForm = RDFParser.LangTagForm.NONE;
    private Optional<Boolean> checking = Optional.empty();
    private boolean strict = SysRIOT.isStrictMode();
    private boolean resolveURIs = true;
    private IRIResolver resolver = null;
    private FactoryRDF factory = null;
    private LabelToNode labelToNode = null;
    private ErrorHandler errorHandler = null;
    private Context context = null;

    public static RDFParserBuilder create() {
        return new RDFParserBuilder();
    }

    private RDFParserBuilder() {
    }

    public RDFParserBuilder source(Path path) {
        this.clearSource();
        this.path = path;
        return this;
    }

    public RDFParserBuilder source(String uriOrFile) {
        this.clearSource();
        this.uri = uriOrFile;
        return this;
    }

    public RDFParserBuilder fromString(String string) {
        this.clearSource();
        this.content = string;
        return this;
    }

    public RDFParserBuilder source(InputStream input) {
        this.clearSource();
        this.inputStream = input;
        return this;
    }

    public RDFParserBuilder source(StringReader reader) {
        this.clearSource();
        this.javaReader = reader;
        return this;
    }

    @Deprecated
    public RDFParserBuilder source(Reader reader) {
        this.clearSource();
        this.javaReader = reader;
        return this;
    }

    public RDFParserBuilder streamManager(StreamManager streamManager) {
        this.streamManager = streamManager;
        return this;
    }

    private void clearSource() {
        this.uri = null;
        this.path = null;
        this.content = null;
        this.inputStream = null;
        this.javaReader = null;
    }

    public RDFParserBuilder lang(Lang lang) {
        this.hintLang = lang;
        return this;
    }

    public RDFParserBuilder forceLang(Lang lang) {
        this.forceLang = lang;
        return this;
    }

    public RDFParserBuilder httpAccept(String acceptHeader) {
        this.httpHeader("Accept", acceptHeader);
        return this;
    }

    public RDFParserBuilder httpHeader(String header, String value) {
        this.httpHeaders.put(header, value);
        return this;
    }

    public RDFParserBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public RDFParserBuilder base(String base) {
        this.baseUri = base;
        return this;
    }

    public RDFParserBuilder resolveURIs(boolean flag) {
        this.resolveURIs = flag;
        return this;
    }

    @Deprecated
    public RDFParserBuilder canonicalLiterals(boolean flag) {
        this.canonicalValues(flag);
        if (flag) {
            this.langTagCanonical();
        } else {
            this.langTagAsGiven();
        }
        return this;
    }

    public RDFParserBuilder canonicalValues(boolean flag) {
        this.canonicalValues = flag;
        return this;
    }

    public RDFParserBuilder langTagLowerCase() {
        return this.langTagForm(RDFParser.LangTagForm.LOWER_CASE);
    }

    public RDFParserBuilder langTagCanonical() {
        return this.langTagForm(RDFParser.LangTagForm.CANONICAL);
    }

    public RDFParserBuilder langTagAsGiven() {
        return this.langTagForm(RDFParser.LangTagForm.NONE);
    }

    private RDFParserBuilder langTagForm(RDFParser.LangTagForm form) {
        this.langTagForm = form;
        return this;
    }

    public RDFParserBuilder checking(boolean flag) {
        this.checking = Optional.of(flag);
        return this;
    }

    public RDFParserBuilder errorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
        return this;
    }

    public RDFParserBuilder factory(FactoryRDF factory) {
        this.factory = factory;
        return this;
    }

    public RDFParserBuilder labelToNode(LabelToNode labelToNode) {
        this.labelToNode = labelToNode;
        return this;
    }

    public RDFParserBuilder context(Context context) {
        if (context != null) {
            context = context.copy();
        }
        this.context = context;
        return this;
    }

    public void parse(StreamRDF stream) {
        this.build().parse(stream);
    }

    public void parse(Graph graph) {
        this.build().parse(graph);
    }

    public void parse(DatasetGraph dataset) {
        this.build().parse(dataset);
    }

    public RDFParser build() {
        StreamManager sMgr;
        if (this.uri == null && this.path == null && this.content == null && this.inputStream == null && this.javaReader == null) {
            throw new RiotException("No source specified");
        }
        HttpClient client = this.buildHttpClient();
        FactoryRDF factory$ = this.buildFactoryRDF();
        ErrorHandler errorHandler$ = this.errorHandler;
        if (errorHandler$ == null) {
            errorHandler$ = ErrorHandlerFactory.getDefaultErrorHandler();
        }
        if (this.path != null && this.baseUri == null) {
            this.baseUri = IRILib.filenameToIRI((String)this.path.toString());
        }
        if (this.path == null && this.baseUri == null && this.uri != null) {
            this.baseUri = this.uri;
        }
        if ((sMgr = this.streamManager) == null) {
            sMgr = StreamManager.get(this.context);
        }
        return new RDFParser(this.uri, this.path, this.content, this.inputStream, this.javaReader, sMgr, client, this.hintLang, this.forceLang, this.baseUri, this.strict, this.checking, this.canonicalValues, this.langTagForm, this.resolveURIs, this.resolver, factory$, errorHandler$, this.context);
    }

    private FactoryRDF buildFactoryRDF() {
        FactoryRDF factory$ = this.factory;
        if (factory$ == null) {
            factory$ = this.labelToNode != null ? RiotLib.factoryRDF(this.labelToNode) : RiotLib.factoryRDF();
        }
        return factory$;
    }

    private HttpClient buildHttpClient() {
        if (this.httpClient != null) {
            return this.httpClient;
        }
        if (this.httpHeaders.isEmpty()) {
            return null;
        }
        ArrayList hdrs = new ArrayList();
        this.httpHeaders.forEach((k, v) -> {
            BasicHeader header = new BasicHeader(k, v);
            hdrs.add(header);
        });
        CloseableHttpClient hc = HttpOp.createPoolingHttpClientBuilder().setDefaultHeaders(hdrs).build();
        return hc;
    }

    public RDFParserBuilder clone() {
        RDFParserBuilder builder = new RDFParserBuilder();
        builder.uri = this.uri;
        builder.path = this.path;
        builder.content = this.content;
        builder.inputStream = this.inputStream;
        builder.javaReader = this.javaReader;
        builder.httpHeaders = new HashMap<String, String>(this.httpHeaders);
        builder.httpClient = this.httpClient;
        builder.hintLang = this.hintLang;
        builder.forceLang = this.forceLang;
        builder.baseUri = this.baseUri;
        builder.checking = this.checking;
        builder.canonicalValues = this.canonicalValues;
        builder.langTagForm = this.langTagForm;
        builder.strict = this.strict;
        builder.resolveURIs = this.resolveURIs;
        builder.resolver = this.resolver;
        builder.factory = this.factory;
        builder.labelToNode = this.labelToNode;
        builder.errorHandler = this.errorHandler;
        builder.context = this.context;
        return builder;
    }
}

