/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.Transactional;

public class TransactionalNull
implements Transactional {
    private ThreadLocal<Boolean> inTransaction = ThreadLocal.withInitial(() -> Boolean.FALSE);

    public static TransactionalNull create() {
        return new TransactionalNull();
    }

    @Override
    public void begin(ReadWrite readWrite) {
        if (this.inTransaction.get().booleanValue()) {
            throw new JenaTransactionException("Already in transaction");
        }
        this.inTransaction.set(true);
    }

    @Override
    public void commit() {
        if (!this.inTransaction.get().booleanValue()) {
            throw new JenaTransactionException("Not in transaction");
        }
        this.inTransaction.set(false);
    }

    @Override
    public void abort() {
        if (!this.inTransaction.get().booleanValue()) {
            throw new JenaTransactionException("Not in transaction");
        }
        this.inTransaction.set(false);
    }

    @Override
    public boolean isInTransaction() {
        return this.inTransaction.get();
    }

    @Override
    public void end() {
        this.inTransaction.set(false);
    }

    public void remove() {
        this.inTransaction.remove();
    }
}

