/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.lang.LangNTuple;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LangNTriples
extends LangNTuple<Triple> {
    private static Logger messageLog = LoggerFactory.getLogger((String)"N-Triples");

    public LangNTriples(Tokenizer tokens, ParserProfile profile, StreamRDF dest) {
        super(tokens, profile, dest);
    }

    @Override
    public Lang getLang() {
        return RDFLanguages.NTRIPLES;
    }

    @Override
    protected final void runParser() {
        while (this.hasNext()) {
            Triple x = this.parseOne();
            if (x == null) continue;
            this.dest.triple(x);
        }
    }

    @Override
    protected final Triple parseOne() {
        Token oToken;
        Token pToken;
        Token sToken = this.nextToken();
        if (sToken.isEOF()) {
            this.exception(sToken, "Premature end of file: %s", sToken);
        }
        if ((pToken = this.nextToken()).isEOF()) {
            this.exception(pToken, "Premature end of file: %s", pToken);
        }
        if ((oToken = this.nextToken()).isEOF()) {
            this.exception(oToken, "Premature end of file: %s", oToken);
        }
        this.checkIRIOrBNode(sToken);
        this.checkIRI(pToken);
        this.checkRDFTerm(oToken);
        Token x = this.nextToken();
        if (x.getType() != TokenType.DOT) {
            this.exception(x, "Triple not terminated by DOT: %s", x);
        }
        Node s = this.tokenAsNode(sToken);
        Node p = this.tokenAsNode(pToken);
        Node o = this.tokenAsNode(oToken);
        return this.profile.createTriple(s, p, o, sToken.getLine(), sToken.getColumn());
    }

    @Override
    protected final Node tokenAsNode(Token token) {
        return this.profile.create(null, token);
    }
}

