/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.ResultSetMgr;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetReaderRegistry;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.ResultSetCheckCondition;
import org.apache.jena.sparql.engine.http.HttpQuery;
import org.apache.jena.sparql.engine.http.Params;
import org.apache.jena.sparql.engine.http.QueryExceptionHTTP;
import org.apache.jena.sparql.engine.http.Service;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryEngineHTTP
implements QueryExecution {
    private static Logger log = LoggerFactory.getLogger(QueryEngineHTTP.class);
    public static final String QUERY_MIME_TYPE = "application/sparql-query";
    private final Query query;
    private final String queryString;
    private final String service;
    private final Context context;
    private Params params = null;
    private List<String> defaultGraphURIs = new ArrayList<String>();
    private List<String> namedGraphURIs = new ArrayList<String>();
    private HttpClient client;
    private HttpContext httpContext;
    private boolean closed = false;
    private long connectTimeout = -1L;
    private TimeUnit connectTimeoutUnit = TimeUnit.MILLISECONDS;
    private long readTimeout = -1L;
    private TimeUnit readTimeoutUnit = TimeUnit.MILLISECONDS;
    private boolean allowCompression = true;
    private String selectContentType = QueryEngineHTTP.defaultSelectHeader();
    private String askContentType = QueryEngineHTTP.defaultAskHeader();
    private String modelContentType = QueryEngineHTTP.defaultConstructHeader();
    private String constructContentType = QueryEngineHTTP.defaultConstructHeader();
    private String datasetContentType = QueryEngineHTTP.defaultConstructDatasetHeader();
    private String acceptHeader = null;
    private String httpResponseContentType = null;
    public static String[] supportedSelectContentTypes = new String[]{"application/sparql-results+xml", "application/sparql-results+json", "text/tab-separated-values", "text/csv", "application/sparql-results+thrift"};
    public static String[] supportedAskContentTypes = new String[]{"application/sparql-results+xml", "application/sparql-results+json", "text/tab-separated-values", "text/csv"};
    private InputStream retainedConnection = null;
    private static final String dftSelectContentTypeHeader = QueryEngineHTTP.initSelectContentTypes();
    private static final String askContentTypeHeader = QueryEngineHTTP.initAskContentTypes();
    private static final String dftConstructContentTypeHeader = QueryEngineHTTP.initConstructContentTypes();
    private static final String dftConstructDatasetContentTypeHeader = QueryEngineHTTP.initConstructDatasetContentTypes();

    public QueryEngineHTTP(String serviceURI, Query query) {
        this(serviceURI, query, null, null);
    }

    public QueryEngineHTTP(String serviceURI, Query query, HttpClient client) {
        this(serviceURI, query, client, null);
    }

    public QueryEngineHTTP(String serviceURI, Query query, HttpClient client, HttpContext httpContext) {
        this(serviceURI, query, query.toString(), client, httpContext);
    }

    public QueryEngineHTTP(String serviceURI, String queryString) {
        this(serviceURI, queryString, null, null);
    }

    public QueryEngineHTTP(String serviceURI, String queryString, HttpClient client) {
        this(serviceURI, queryString, client, null);
    }

    public QueryEngineHTTP(String serviceURI, String queryString, HttpClient client, HttpContext httpContext) {
        this(serviceURI, null, queryString, client, httpContext);
    }

    private QueryEngineHTTP(String serviceURI, Query query, String queryString, HttpClient client, HttpContext httpContext) {
        this.query = query;
        this.queryString = queryString;
        this.service = serviceURI;
        this.context = ARQ.getContext().copy();
        QueryEngineHTTP.applyServiceConfig(serviceURI, this);
        if (client != null) {
            this.setClient(client);
        }
        if (httpContext != null) {
            this.setHttpContext(httpContext);
        }
    }

    private static void applyServiceConfig(String serviceURI, QueryEngineHTTP engine) {
        if (engine.context == null) {
            return;
        }
        Map serviceContextMap = (Map)engine.context.get(Service.serviceContext);
        if (serviceContextMap != null && serviceContextMap.containsKey(serviceURI)) {
            Context serviceContext = (Context)serviceContextMap.get(serviceURI);
            if (log.isDebugEnabled()) {
                log.debug("Endpoint URI {} has SERVICE Context: {} ", (Object)serviceURI, (Object)serviceContext);
            }
            engine.setAllowCompression(serviceContext.isTrueOrUndef(Service.queryCompression));
            QueryEngineHTTP.applyServiceTimeouts(engine, serviceContext);
            HttpClient client = (HttpClient)serviceContext.get(Service.queryClient);
            if (client != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Using context-supplied HTTP client for endpoint URI {}", (Object)serviceURI);
                }
                engine.setClient(client);
            }
        }
    }

    private static void applyServiceTimeouts(QueryEngineHTTP engine, Context context) {
        if (context.isDefined(Service.queryTimeout)) {
            Object obj = context.get(Service.queryTimeout);
            if (obj instanceof Number) {
                int x = ((Number)obj).intValue();
                engine.setTimeout(-1L, x);
            } else if (obj instanceof String) {
                try {
                    String str2 = obj.toString();
                    if (str2.contains(",")) {
                        String[] a = str2.split(",");
                        int connect = Integer.parseInt(a[0]);
                        int read = Integer.parseInt(a[1]);
                        engine.setTimeout((long)read, connect);
                    }
                    int x = Integer.parseInt(str2);
                    engine.setTimeout(-1L, x);
                }
                catch (NumberFormatException ex) {
                    throw new QueryExecException("Can't interpret string for timeout: " + obj);
                }
            } else {
                throw new QueryExecException("Can't interpret timeout: " + obj);
            }
        }
    }

    @Override
    public void setInitialBinding(QuerySolution binding) {
        throw new UnsupportedOperationException("Initial bindings not supported for remote queries, consider using a ParameterizedSparqlString to prepare a query for remote execution");
    }

    public void setInitialBindings(ResultSet table) {
        throw new UnsupportedOperationException("Initial bindings not supported for remote queries, consider using a ParameterizedSparqlString to prepare a query for remote execution");
    }

    public void setDefaultGraphURIs(List<String> defaultGraphURIs) {
        this.defaultGraphURIs = defaultGraphURIs;
    }

    public void setNamedGraphURIs(List<String> namedGraphURIs) {
        this.namedGraphURIs = namedGraphURIs;
    }

    public void setAllowCompression(boolean allowed) {
        this.allowCompression = allowed;
    }

    public void addParam(String field, String value) {
        if (this.params == null) {
            this.params = new Params();
        }
        this.params.addParam(field, value);
    }

    public void addDefaultGraph(String defaultGraph) {
        if (this.defaultGraphURIs == null) {
            this.defaultGraphURIs = new ArrayList<String>();
        }
        this.defaultGraphURIs.add(defaultGraph);
    }

    public void addNamedGraph(String name) {
        if (this.namedGraphURIs == null) {
            this.namedGraphURIs = new ArrayList<String>();
        }
        this.namedGraphURIs.add(name);
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public void setHttpContext(HttpContext context) {
        this.httpContext = context;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public String getHttpResponseContentType() {
        return this.httpResponseContentType;
    }

    @Override
    public ResultSet execSelect() {
        this.checkNotClosed();
        ResultSet rs = this.execResultSetInner();
        return new ResultSetCheckCondition(rs, this);
    }

    private ResultSet execResultSetInner() {
        Lang lang;
        String actualContentType;
        InputStream in;
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept(QueryEngineHTTP.chooseAcceptHeader(this.acceptHeader, this.selectContentType));
        this.retainedConnection = in = httpQuery.exec();
        this.httpResponseContentType = actualContentType = httpQuery.getContentType();
        if (actualContentType == null || actualContentType.equals("")) {
            actualContentType = this.selectContentType;
        }
        if ((lang = WebContent.contentTypeToLangResultSet(actualContentType)) == null) {
            throw new QueryException("Endpoint returned Content-Type: " + actualContentType + " which is not rcognized for SELECT queries");
        }
        if (!ResultSetReaderRegistry.isRegistered(lang)) {
            throw new QueryException("Endpoint returned Content-Type: " + actualContentType + " which is not supported for SELECT queries");
        }
        ResultSet result = ResultSetMgr.read(in, lang);
        return result;
    }

    private static String chooseAcceptHeader(String acceptHeader, String contentType) {
        if (acceptHeader != null) {
            return acceptHeader;
        }
        return contentType;
    }

    @Override
    public Model execConstruct() {
        return this.execConstruct(GraphFactory.makeJenaDefaultModel());
    }

    @Override
    public Model execConstruct(Model model) {
        return this.execModel(model);
    }

    @Override
    public Iterator<Triple> execConstructTriples() {
        return this.execTriples();
    }

    @Override
    public Iterator<Quad> execConstructQuads() {
        return this.execQuads();
    }

    @Override
    public Dataset execConstructDataset() {
        return this.execConstructDataset(DatasetFactory.createTxnMem());
    }

    @Override
    public Dataset execConstructDataset(Dataset dataset) {
        return this.execDataset(dataset);
    }

    @Override
    public Model execDescribe() {
        return this.execDescribe(GraphFactory.makeJenaDefaultModel());
    }

    @Override
    public Model execDescribe(Model model) {
        return this.execModel(model);
    }

    @Override
    public Iterator<Triple> execDescribeTriples() {
        return this.execTriples();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model execModel(Model model) {
        Pair<InputStream, Lang> p = this.execConstructWorker(this.modelContentType);
        InputStream in = (InputStream)p.getLeft();
        Lang lang = (Lang)p.getRight();
        try {
            RDFDataMgr.read(model, in, lang);
        }
        finally {
            this.close();
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dataset execDataset(Dataset dataset) {
        Pair<InputStream, Lang> p = this.execConstructWorker(this.datasetContentType);
        InputStream in = (InputStream)p.getLeft();
        Lang lang = (Lang)p.getRight();
        try {
            RDFDataMgr.read(dataset, in, lang);
        }
        finally {
            this.close();
        }
        return dataset;
    }

    private Iterator<Triple> execTriples() {
        Pair<InputStream, Lang> p = this.execConstructWorker(this.modelContentType);
        InputStream in = (InputStream)p.getLeft();
        Lang lang = (Lang)p.getRight();
        return RDFDataMgr.createIteratorTriples(in, lang, null);
    }

    private Iterator<Quad> execQuads() {
        Pair<InputStream, Lang> p = this.execConstructWorker(this.datasetContentType);
        InputStream in = (InputStream)p.getLeft();
        Lang lang = (Lang)p.getRight();
        return RDFDataMgr.createIteratorQuads(in, lang, null);
    }

    private Pair<InputStream, Lang> execConstructWorker(String contentType) {
        Lang lang;
        String actualContentType;
        this.checkNotClosed();
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept(QueryEngineHTTP.chooseAcceptHeader(this.acceptHeader, contentType));
        InputStream in = httpQuery.exec();
        this.httpResponseContentType = actualContentType = httpQuery.getContentType();
        if (actualContentType == null || actualContentType.equals("")) {
            actualContentType = "application/trig,application/n-quads;q=0.9,text/x-nquads;q=0.8,application/x-trig;q=0.7,application/ld+json;q=0.5,*/*;q=0.5";
        }
        if (!RDFLanguages.isQuads(lang = RDFLanguages.contentTypeToLang(actualContentType)) && !RDFLanguages.isTriples(lang)) {
            throw new QueryException("Endpoint returned Content Type: " + actualContentType + " which is not a valid RDF syntax");
        }
        return Pair.create((Object)in, (Object)lang);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execAsk() {
        this.checkNotClosed();
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept(QueryEngineHTTP.chooseAcceptHeader(this.acceptHeader, this.askContentType));
        try (InputStream in = httpQuery.exec();){
            Lang lang;
            String actualContentType;
            this.httpResponseContentType = actualContentType = httpQuery.getContentType();
            if (actualContentType == null || actualContentType.equals("")) {
                actualContentType = this.askContentType;
            }
            if ((lang = RDFLanguages.contentTypeToLang(actualContentType)) == null) {
                if (actualContentType.equals("application/xml")) {
                    lang = ResultSetLang.SPARQLResultSetXML;
                } else if (actualContentType.equals("application/json")) {
                    lang = ResultSetLang.SPARQLResultSetJSON;
                }
            }
            if (lang == null) {
                throw new QueryException("Endpoint returned Content-Type: " + actualContentType + " which is not supported for ASK queries");
            }
            Boolean result = ResultSetMgr.readBoolean(in, lang);
            boolean bl = result;
            return bl;
        }
        catch (ResultSetException e2) {
            log.warn("Returned content is not a boolean result", (Throwable)((Object)e2));
            throw e2;
        }
        catch (QueryExceptionHTTP e3) {
            throw e3;
        }
        catch (IOException e4) {
            log.warn("Failed to close connection", (Throwable)e4);
            return false;
        }
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new QueryExecException("HTTP QueryExecution has been closed");
        }
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public Dataset getDataset() {
        return null;
    }

    @Override
    public Query getQuery() {
        if (this.query != null) {
            return this.query;
        }
        if (this.queryString != null) {
            try {
                return QueryFactory.create(this.queryString, Syntax.syntaxARQ);
            }
            catch (QueryParseException queryParseException) {
                return null;
            }
        }
        return null;
    }

    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public void setTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
        this.readTimeoutUnit = TimeUnit.MILLISECONDS;
    }

    @Override
    public void setTimeout(long readTimeout, long connectTimeout) {
        this.readTimeout = readTimeout;
        this.readTimeoutUnit = TimeUnit.MILLISECONDS;
        this.connectTimeout = connectTimeout;
        this.connectTimeoutUnit = TimeUnit.MILLISECONDS;
    }

    @Override
    public void setTimeout(long readTimeout, TimeUnit timeoutUnits) {
        this.readTimeout = readTimeout;
        this.readTimeoutUnit = timeoutUnits;
    }

    @Override
    public void setTimeout(long timeout1, TimeUnit timeUnit1, long timeout2, TimeUnit timeUnit2) {
        this.readTimeout = timeout1;
        this.readTimeoutUnit = timeUnit1;
        this.connectTimeout = timeout2;
        this.connectTimeoutUnit = timeUnit2;
    }

    @Override
    public long getTimeout1() {
        return QueryEngineHTTP.asMillis(this.readTimeout, this.readTimeoutUnit);
    }

    @Override
    public long getTimeout2() {
        return QueryEngineHTTP.asMillis(this.connectTimeout, this.connectTimeoutUnit);
    }

    public boolean getAllowCompression() {
        return this.allowCompression;
    }

    private static long asMillis(long duration, TimeUnit timeUnit) {
        return duration < 0L ? duration : timeUnit.toMillis(duration);
    }

    private HttpQuery makeHttpQuery() {
        Context serviceContext;
        Map servicesContext;
        if (this.closed) {
            throw new ARQException("HTTP execution already closed");
        }
        HttpQuery httpQuery = new HttpQuery(this.service);
        httpQuery.merge(QueryEngineHTTP.getServiceParams(this.service, this.context));
        httpQuery.addParam("query", this.queryString);
        for (String dft : this.defaultGraphURIs) {
            httpQuery.addParam("default-graph-uri", dft);
        }
        for (String name : this.namedGraphURIs) {
            httpQuery.addParam("named-graph-uri", name);
        }
        if (this.params != null) {
            httpQuery.merge(this.params);
        }
        httpQuery.setAllowCompression(this.allowCompression);
        if (this.context.isDefined(Service.serviceContext) && (servicesContext = (Map)this.context.get(Service.serviceContext)).containsKey(this.service) && (serviceContext = (Context)servicesContext.get(this.service)).isDefined(Service.queryClient)) {
            this.client = (HttpClient)serviceContext.get(Service.queryClient);
        }
        httpQuery.setClient(this.client);
        HttpClientContext hcc = this.httpContext == null ? null : HttpClientContext.adapt((HttpContext)this.httpContext);
        httpQuery.setContext((HttpContext)hcc);
        if (this.connectTimeout > 0L) {
            httpQuery.setConnectTimeout((int)this.connectTimeoutUnit.toMillis(this.connectTimeout));
        }
        if (this.readTimeout > 0L) {
            httpQuery.setReadTimeout((int)this.readTimeoutUnit.toMillis(this.readTimeout));
        }
        return httpQuery;
    }

    protected static Params getServiceParams(String serviceURI, Context context) throws QueryExecException {
        Map paramsMap;
        Params params = new Params();
        Map serviceParams = (Map)context.get(ARQ.serviceParams);
        if (serviceParams != null && (paramsMap = (Map)serviceParams.get(serviceURI)) != null) {
            for (String param : paramsMap.keySet()) {
                if ("query".equals(param)) {
                    throw new QueryExecException("ARQ serviceParams overrides the 'query' SPARQL protocol parameter");
                }
                List values = (List)paramsMap.get(param);
                for (String value : values) {
                    params.addParam(param, value);
                }
            }
        }
        return params;
    }

    public void cancel() {
        this.closed = true;
    }

    @Override
    public void abort() {
        try {
            this.close();
        }
        catch (Exception ex) {
            log.warn("Error during abort", (Throwable)ex);
        }
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.retainedConnection != null) {
            try {
                if (this.retainedConnection.read() != -1) {
                    log.warn("HTTP response not fully consumed, if HTTP Client is reusing connections (its default behaviour) then it will consume the remaining response data which may take a long time and cause this application to become unresponsive");
                }
                this.retainedConnection.close();
            }
            catch (RuntimeIOException e2) {
                log.debug("Failed to close connection", (Throwable)e2);
            }
            catch (IOException e3) {
                log.debug("Failed to close connection", (Throwable)e3);
            }
            finally {
                this.retainedConnection = null;
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        HttpQuery httpQuery = this.makeHttpQuery();
        return "GET " + httpQuery.toString();
    }

    public void setSelectContentType(String contentType) {
        boolean ok = false;
        for (String supportedType : supportedSelectContentTypes) {
            if (!supportedType.equals(contentType)) continue;
            ok = true;
            break;
        }
        if (!ok) {
            throw new IllegalArgumentException("Given Content Type '" + contentType + "' is not a supported SELECT results format");
        }
        this.selectContentType = contentType;
    }

    public void setAskContentType(String contentType) {
        boolean ok = false;
        for (String supportedType : supportedAskContentTypes) {
            if (!supportedType.equals(contentType)) continue;
            ok = true;
            break;
        }
        if (!ok) {
            throw new IllegalArgumentException("Given Content Type '" + contentType + "' is not a supported ASK results format");
        }
        this.askContentType = contentType;
    }

    public void setModelContentType(String contentType) {
        Lang lang = RDFLanguages.contentTypeToLang(contentType);
        if (lang == null) {
            throw new IllegalArgumentException("Given Content Type '" + contentType + "' is not supported by RIOT");
        }
        if (!RDFLanguages.isTriples(lang)) {
            throw new IllegalArgumentException("Given Content Type '" + contentType + "' is not a RDF Graph format");
        }
        this.modelContentType = contentType;
    }

    public void setDatasetContentType(String contentType) {
        Lang lang = RDFLanguages.contentTypeToLang(contentType);
        if (lang == null) {
            throw new IllegalArgumentException("Given Content Type '" + contentType + "' is not supported by RIOT");
        }
        if (!RDFLanguages.isQuads(lang)) {
            throw new IllegalArgumentException("Given Content Type '" + contentType + "' is not a RDF Dataset format");
        }
        this.datasetContentType = contentType;
    }

    public static String defaultSelectHeader() {
        return dftSelectContentTypeHeader;
    }

    private static String initSelectContentTypes() {
        StringBuilder sBuff = new StringBuilder();
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "application/sparql-results+json", 1.0);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "application/sparql-results+xml", 0.9);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "text/tab-separated-values", 0.7);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "text/csv", 0.5);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "application/json", 0.2);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "application/xml", 0.2);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "*/*", 0.1);
        return sBuff.toString();
    }

    public static String defaultAskHeader() {
        return dftSelectContentTypeHeader;
    }

    private static String initAskContentTypes() {
        return QueryEngineHTTP.initSelectContentTypes();
    }

    public static String defaultConstructHeader() {
        return dftConstructContentTypeHeader;
    }

    private static String initConstructContentTypes() {
        StringBuilder sBuff = new StringBuilder();
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "text/turtle", 1.0);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "application/n-triples", 1.0);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "application/rdf+xml", 0.9);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "application/turtle", 0.8);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "application/x-turtle", 0.8);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "text/rdf+n3", 0.7);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "application/n3", 0.6);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "text/n3", 0.6);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "text/plain", 0.5);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "*/*", 0.1);
        return sBuff.toString();
    }

    public static String defaultConstructDatasetHeader() {
        return dftConstructDatasetContentTypeHeader;
    }

    private static String initConstructDatasetContentTypes() {
        StringBuilder sBuff = new StringBuilder();
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "text/trig", 1.0);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "application/x-trig", 1.0);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "application/trig", 1.0);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "application/n-quads", 1.0);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "text/n-quads", 1.0);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "text/nquads", 1.0);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "application/ld+json", 0.9);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "text/turtle", 0.8);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "application/n-triples", 0.8);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "application/rdf+xml", 0.7);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "application/turtle", 0.6);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "application/x-turtle", 0.6);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "text/rdf+n3", 0.5);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "application/n3", 0.5);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "text/n3", 0.5);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "text/plain", 0.4);
        QueryEngineHTTP.accumulateContentTypeString(sBuff, "*/*", 0.1);
        return sBuff.toString();
    }

    private static void accumulateContentTypeString(StringBuilder sBuff, String str2, double v) {
        if (sBuff.length() != 0) {
            sBuff.append(", ");
        }
        sBuff.append(str2);
        if (v < 1.0) {
            sBuff.append(";q=").append(v);
        }
    }

    public String getAcceptHeader() {
        return this.acceptHeader;
    }

    public void setAcceptHeader(String acceptHeader) {
        this.acceptHeader = acceptHeader;
    }
}

