/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.lib;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Properties;
import org.apache.jena.atlas.lib.SystemUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.sparql.ARQException;

public class Metadata {
    private List<String> resources = new ArrayList<String>();
    private Properties properties = new Properties();

    public Metadata() {
    }

    public Metadata(String resourceName) {
        this();
        this.addMetadata(resourceName);
    }

    public void addMetadata(String resourceName) {
        this.resources.add(resourceName);
        Metadata.read(this.properties, resourceName);
    }

    private static void read(Properties properties, String resourceName) {
        try {
            ClassLoader classLoader = null;
            try {
                classLoader = SystemUtils.chooseClassLoader();
            }
            catch (ARQException aRQException) {
                // empty catch block
            }
            if (classLoader == null) {
                try {
                    classLoader = Metadata.class.getClassLoader();
                }
                catch (ARQException aRQException) {
                    // empty catch block
                }
            }
            if (classLoader == null) {
                Log.error(Metadata.class, (String)"No classloader");
                return;
            }
            InputStream in = classLoader.getResourceAsStream(resourceName);
            if (in == null) {
                return;
            }
            try {
                properties.loadFromXML(in);
            }
            catch (InvalidPropertiesFormatException ex) {
                throw new ARQException("Invalid properties file", ex);
            }
            catch (IOException ex) {
                throw new ARQException("Metadata ==> IOException", ex);
            }
        }
        catch (Throwable ex) {
            Log.error(Metadata.class, (String)"Unexpected Thorwable", (Throwable)ex);
            return;
        }
    }

    public String get(String name) {
        return this.get(name, null);
    }

    public String get(String name, String defaultValue) {
        if (this.properties == null) {
            return defaultValue;
        }
        return this.properties.getProperty(name, defaultValue);
    }

    public List<String> getResources() {
        return this.resources;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

