/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.irix.IRIs;
import org.apache.jena.irix.IRIx;
import org.apache.jena.irix.IRIxResolver;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.WriterDatasetRIOT;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.FactoryRDF;
import org.apache.jena.riot.system.FactoryRDFCaching;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.ParserProfileStd;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.riot.writer.WriterConst;
import org.apache.jena.riot.writer.WriterGraphRIOTBase;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.util.iterator.ExtendedIterator;

public class RiotLib {
    private static final boolean skolomizedBNodes = ARQ.isTrueOrUndef(ARQ.constantBNodeLabels);
    private static final String bNodeLabelStart = "_:";
    private static final String URI_PREFIX_FIXUP = "::";
    public static final Function<String, String> fixupPrefixes = x -> URI_PREFIX_FIXUP.concat((String)x);
    public static final Predicate<String> testFixupedPrefixURI = x -> x.startsWith(URI_PREFIX_FIXUP);

    public static Node blankNodeToIri(Node node) {
        if (node.isBlank()) {
            return NodeFactory.createURI((String)RiotLib.blankNodeToIriString(node));
        }
        return node;
    }

    public static String blankNodeToIriString(Node node) {
        if (node.isBlank()) {
            String x = node.getBlankNodeLabel();
            return bNodeLabelStart + x;
        }
        if (node.isURI()) {
            return node.getURI();
        }
        throw new RiotException("Not a blank node or URI");
    }

    public static Node createIRIorBNode(String str2) {
        if (skolomizedBNodes && RiotLib.isBNodeIRI(str2)) {
            String s = str2.substring(bNodeLabelStart.length());
            Node n = NodeFactory.createBlankNode((String)s);
            return n;
        }
        return NodeFactory.createURI((String)str2);
    }

    public static boolean isBNodeIRI(String iri) {
        return iri.startsWith(bNodeLabelStart);
    }

    public static boolean isPrefixIRI(String iri) {
        return testFixupedPrefixURI.test(iri);
    }

    public static String fixupPrefixIRI(String prefix, String localPart) {
        return RiotLib.fixupPrefixIRI(prefix + ":" + localPart);
    }

    public static String fixupPrefixIRI(String prefixedName) {
        return fixupPrefixes.apply(prefixedName);
    }

    public static Node parse(String string) {
        return NodeFactoryExtra.parseNode(string, null);
    }

    public static ParserProfile profile(Lang lang, String baseIRI, ErrorHandler handler) {
        if (RDFLanguages.sameLang(RDFLanguages.NTRIPLES, lang) || RDFLanguages.sameLang(RDFLanguages.NQUADS, lang)) {
            boolean checking = SysRIOT.isStrictMode();
            return RiotLib.profile(baseIRI, false, checking, handler);
        }
        if (RDFLanguages.sameLang(RDFLanguages.RDFJSON, lang)) {
            return RiotLib.profile(baseIRI, false, true, handler);
        }
        return RiotLib.profile(baseIRI, true, true, handler);
    }

    private static ParserProfile profile(String baseIRI, boolean resolveIRIs, boolean checking, ErrorHandler handler) {
        LabelToNode labelToNode = SyntaxLabels.createLabelToNode();
        IRIx base = resolveIRIs ? IRIs.resolveIRI((String)baseIRI) : IRIx.create((String)baseIRI);
        IRIxResolver resolver = IRIxResolver.create((IRIx)base).resolve(resolveIRIs).allowRelative(false).build();
        ParserProfile profile = RiotLib.createParserProfile(RiotLib.factoryRDF(labelToNode), handler, resolver, checking);
        return profile;
    }

    public static FactoryRDF factoryRDF(LabelToNode labelMapping) {
        return new FactoryRDFCaching(5000, labelMapping);
    }

    public static FactoryRDF factoryRDF() {
        return RiotLib.factoryRDF(SyntaxLabels.createLabelToNode());
    }

    public static ParserProfile dftProfile() {
        return RiotLib.createParserProfile(RiotLib.factoryRDF(), ErrorHandlerFactory.errorHandlerStd, true);
    }

    public static ParserProfile createParserProfile(ErrorHandler errorHandler) {
        return RiotLib.createParserProfile(RiotLib.factoryRDF(), errorHandler, true);
    }

    public static ParserProfile createParserProfile(FactoryRDF factory, ErrorHandler errorHandler, boolean checking) {
        return new ParserProfileStd(factory, errorHandler, IRIxResolver.create((IRIx)IRIs.getSystemBase()).build(), PrefixMapFactory.create(), RIOT.getContext().copy(), checking, false);
    }

    public static ParserProfile createParserProfile(FactoryRDF factory, ErrorHandler errorHandler, IRIxResolver resolver, boolean checking) {
        return new ParserProfileStd(factory, errorHandler, resolver, PrefixMapFactory.create(), RIOT.getContext().copy(), checking, false);
    }

    public static Collection<Triple> triplesOfSubject(Graph graph, Node subj) {
        return RiotLib.triples(graph, subj, Node.ANY, Node.ANY);
    }

    public static List<Triple> triples(Graph graph, Node s, Node p, Node o) {
        ArrayList<Triple> acc = new ArrayList<Triple>();
        RiotLib.accTriples(acc, graph, s, p, o);
        return acc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long countTriples(Graph graph, Node s, Node p, Node o) {
        try (ExtendedIterator iter = graph.find(s, p, o);){
            long l = Iter.count((Iterator)iter);
            return l;
        }
    }

    public static long countTriples(DatasetGraph dsg, Node s, Node p, Node o) {
        Iterator<Quad> iter = dsg.find(Node.ANY, s, p, o);
        return Iter.count(iter);
    }

    public static void accTriples(Collection<Triple> acc, Graph graph, Node s, Node p, Node o) {
        ExtendedIterator iter = graph.find(s, p, o);
        while (iter.hasNext()) {
            acc.add((Triple)iter.next());
        }
        iter.close();
    }

    public static boolean strSafeFor(String str2, char ch) {
        return str2.indexOf(ch) == -1;
    }

    public static void writeBase(IndentedWriter out, String base, boolean newStyle) {
        if (newStyle) {
            RiotLib.writeBaseNewStyle(out, base);
        } else {
            RiotLib.writeBaseOldStyle(out, base);
        }
    }

    private static void writeBaseNewStyle(IndentedWriter out, String base) {
        if (base != null) {
            out.print("BASE ");
            out.pad(15);
            out.print("<");
            out.print(base);
            out.print(">");
            out.println();
        }
    }

    private static void writeBaseOldStyle(IndentedWriter out, String base) {
        if (base != null) {
            out.print("@base ");
            out.pad(15);
            out.print("<");
            out.print(base);
            out.print(">");
            out.print(" .");
            out.println();
        }
    }

    public static void writePrefixes(IndentedWriter out, PrefixMap prefixMap, boolean newStyle) {
        if (prefixMap != null && !prefixMap.isEmpty()) {
            for (Map.Entry<String, String> e2 : prefixMap.getMapping().entrySet()) {
                if (newStyle) {
                    RiotLib.writePrefixNewStyle(out, e2.getKey(), e2.getValue());
                    continue;
                }
                RiotLib.writePrefixOldStyle(out, e2.getKey(), e2.getValue());
            }
        }
    }

    public static void writePrefix(IndentedWriter out, String prefix, String uri, boolean newStyle) {
        if (newStyle) {
            RiotLib.writePrefixNewStyle(out, prefix, uri);
        } else {
            RiotLib.writePrefixOldStyle(out, prefix, uri);
        }
    }

    private static void writePrefixNewStyle(IndentedWriter out, String prefix, String uri) {
        out.print("PREFIX ");
        out.print(prefix);
        out.print(": ");
        out.pad(15);
        out.print("<");
        out.print(uri);
        out.print(">");
        out.println();
    }

    public static void writePrefixOldStyle(IndentedWriter out, String prefix, String uri) {
        out.print("@prefix ");
        out.print(prefix);
        out.print(": ");
        out.pad(15);
        out.print("<");
        out.print(uri);
        out.print(">");
        out.print(" .");
        out.println();
    }

    public static PrefixMap prefixMap(DatasetGraph dsg) {
        return PrefixMapFactory.create(dsg.getDefaultGraph().getPrefixMapping());
    }

    public static int calcWidth(PrefixMap prefixMap, String baseURI, Node p) {
        if (!prefixMap.containsPrefix(WriterConst.rdfNS) && WriterConst.RDF_type.equals((Object)p)) {
            return 1;
        }
        String x = prefixMap.abbreviate(p.getURI());
        if (x == null) {
            return p.getURI().length() + 2;
        }
        return x.length();
    }

    public static int calcWidth(PrefixMap prefixMap, String baseURI, Collection<Node> nodes, int minWidth, int maxWidth) {
        Node prev = null;
        int nodeMaxWidth = minWidth;
        for (Node n : nodes) {
            int len;
            if (prev != null && prev.equals((Object)n) || (len = RiotLib.calcWidth(prefixMap, baseURI, n)) > maxWidth) continue;
            if (nodeMaxWidth < len) {
                nodeMaxWidth = len;
            }
            prev = n;
        }
        return nodeMaxWidth;
    }

    public static int calcWidthTriples(PrefixMap prefixMap, String baseURI, Collection<Triple> triples, int minWidth, int maxWidth) {
        Node prev = null;
        int nodeMaxWidth = minWidth;
        for (Triple triple : triples) {
            int len;
            Node n = triple.getPredicate();
            if (prev != null && prev.equals((Object)n) || (len = RiotLib.calcWidth(prefixMap, baseURI, n)) > maxWidth) continue;
            if (nodeMaxWidth < len) {
                nodeMaxWidth = len;
            }
            prev = n;
        }
        return nodeMaxWidth;
    }

    public static IndentedWriter create(Writer writer) {
        return new IndentedWriterWriter(writer);
    }

    public static PrefixMap prefixMap(Graph graph) {
        return PrefixMapFactory.create(graph.getPrefixMapping());
    }

    public static WriterGraphRIOTBase adapter(WriterDatasetRIOT writer) {
        return new WriterAdapter(writer);
    }

    private static class WriterAdapter
    extends WriterGraphRIOTBase {
        private WriterDatasetRIOT writer;

        WriterAdapter(WriterDatasetRIOT writer) {
            this.writer = writer;
        }

        @Override
        public Lang getLang() {
            return this.writer.getLang();
        }

        @Override
        public void write(OutputStream out, Graph graph, PrefixMap prefixMap, String baseURI, Context context2) {
            this.writer.write(out, DatasetGraphFactory.wrap(graph), prefixMap, baseURI, context2);
        }

        @Override
        public void write(Writer out, Graph graph, PrefixMap prefixMap, String baseURI, Context context2) {
            this.writer.write(out, DatasetGraphFactory.wrap(graph), prefixMap, baseURI, context2);
        }
    }

    private static class IndentedWriterWriter
    extends IndentedWriter {
        IndentedWriterWriter(Writer w) {
            super(w);
        }
    }
}

