/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingLib;
import org.apache.jena.sparql.resultset.RDFOutput;
import org.apache.jena.sparql.util.EqualityTest;
import org.apache.jena.sparql.util.Iso;
import org.apache.jena.sparql.util.NodeIsomorphismMap;
import org.apache.jena.sparql.util.NodeUtils;

public class ResultSetCompare {
    public static boolean equalsByValue(ResultSet rs1, ResultSet rs2) {
        if (!ResultSetCompare.compareHeader(rs1, rs2)) {
            return false;
        }
        ResultSetRewindable rs1a = rs1.rewindable();
        ResultSetRewindable rs2a = rs2.rewindable();
        if (ResultSetCompare.equivalent(ResultSetCompare.convert(rs1a), ResultSetCompare.convert(rs2a), new BNodeIso(NodeUtils.sameValue))) {
            return true;
        }
        rs1a.reset();
        rs2a.reset();
        return ResultSetCompare.isomorphic(rs1a, rs2a);
    }

    public static boolean equalsByTest(Collection<Binding> b1, Collection<Binding> b2, EqualityTest match) {
        ArrayList<Binding> rows1 = new ArrayList<Binding>(b1);
        ArrayList<Binding> rows2 = new ArrayList<Binding>(b2);
        return ResultSetCompare.equivalent(rows1, rows2, match);
    }

    public static boolean equalsByTerm(ResultSet rs1, ResultSet rs2) {
        if (!ResultSetCompare.compareHeader(rs1, rs2)) {
            return false;
        }
        ResultSetRewindable rs1a = rs1.rewindable();
        ResultSetRewindable rs2a = rs2.rewindable();
        if (ResultSetCompare.equivalent(ResultSetCompare.convert(rs1a), ResultSetCompare.convert(rs2a), new BNodeIso(NodeUtils.sameNode))) {
            return true;
        }
        rs1a.reset();
        rs2a.reset();
        return ResultSetCompare.isomorphic(rs1a, rs2a);
    }

    public static boolean equalsByValueAndOrder(ResultSet rs1, ResultSet rs2) {
        if (!ResultSetCompare.compareHeader(rs1, rs2)) {
            return false;
        }
        return ResultSetCompare.equivalentByOrder(ResultSetCompare.convert(rs1), ResultSetCompare.convert(rs2), new BNodeIso(NodeUtils.sameValue));
    }

    public static boolean equalsByTermAndOrder(ResultSet rs1, ResultSet rs2) {
        if (!ResultSetCompare.compareHeader(rs1, rs2)) {
            return false;
        }
        return ResultSetCompare.equivalentByOrder(ResultSetCompare.convert(rs1), ResultSetCompare.convert(rs2), new BNodeIso(NodeUtils.sameNode));
    }

    public static boolean equalsExact(ResultSet rs1, ResultSet rs2) {
        if (!ResultSetCompare.compareHeader(rs1, rs2)) {
            return false;
        }
        return ResultSetCompare.equivalentByOrder(ResultSetCompare.convert(rs1), ResultSetCompare.convert(rs2), NodeUtils.sameNode);
    }

    public static boolean isomorphic(ResultSet rs1, ResultSet rs2) {
        Model m1 = RDFOutput.encodeAsModel(rs1);
        Model m2 = RDFOutput.encodeAsModel(rs2);
        return m1.isIsomorphicWith(m2);
    }

    public static boolean equal(Binding bind1, Binding bind2, EqualityTest test) {
        if (bind1 == bind2) {
            return true;
        }
        if (bind1.size() != bind2.size()) {
            return false;
        }
        return ResultSetCompare.containedIn(bind1, bind2, test);
    }

    private static boolean compareHeader(ResultSet rs1, ResultSet rs2) {
        if (rs1 == null && rs2 == null) {
            return true;
        }
        if (rs1 == null) {
            return false;
        }
        if (rs2 == null) {
            return false;
        }
        HashSet<String> names1 = new HashSet<String>(rs1.getResultVars());
        HashSet<String> names2 = new HashSet<String>(rs2.getResultVars());
        return names1.equals(names2);
    }

    private static List<Binding> convert(ResultSet rs) {
        return Iter.iter((Iterator)rs).map(item -> BindingLib.asBinding(item)).toList();
    }

    private static boolean equivalent(Collection<Binding> rows1, Collection<Binding> rows2, EqualityTest match) {
        if (rows1.size() != rows2.size()) {
            return false;
        }
        for (Binding row1 : rows1) {
            Binding matched = null;
            for (Binding row2 : rows2) {
                if (!ResultSetCompare.equal(row1, row2, match)) continue;
                matched = row2;
                break;
            }
            if (matched == null) {
                return false;
            }
            rows2.remove(matched);
        }
        return true;
    }

    private static boolean equivalentByOrder(List<Binding> rows1, List<Binding> rows2, EqualityTest match) {
        if (rows1.size() != rows2.size()) {
            return false;
        }
        Iterator<Binding> iter1 = rows1.iterator();
        Iterator<Binding> iter2 = rows2.iterator();
        while (iter1.hasNext()) {
            Binding row2;
            Binding row1 = iter1.next();
            if (ResultSetCompare.equal(row1, row2 = iter2.next(), match)) continue;
            return false;
        }
        return true;
    }

    private static boolean containedIn(Binding bind1, Binding bind2, EqualityTest test) {
        Iterator<Var> iter1 = bind1.vars();
        while (iter1.hasNext()) {
            Var v = iter1.next();
            Node n1 = bind1.get(v);
            Node n2 = bind2.get(v);
            if (n2 == null) {
                return false;
            }
            if (test.equal(n1, n2)) continue;
            return false;
        }
        return true;
    }

    public static class BNodeIso
    implements EqualityTest {
        private NodeIsomorphismMap mapping = new NodeIsomorphismMap();
        private EqualityTest literalTest;

        public BNodeIso(EqualityTest literalTest) {
            this.literalTest = literalTest;
        }

        @Override
        public boolean equal(Node n1, Node n2) {
            if (n1 == null && n2 == null) {
                return true;
            }
            if (n1 == null) {
                return false;
            }
            if (n2 == null) {
                return false;
            }
            if (n1.isURI() && n2.isURI()) {
                return n1.equals((Object)n2);
            }
            if (n1.isLiteral() && n2.isLiteral()) {
                return this.literalTest.equal(n1, n2);
            }
            if (n1.isBlank() && n2.isBlank()) {
                return Iso.nodeIso(n1, n2, this.mapping);
            }
            if (n1.isVariable() && n2.isVariable()) {
                return this.mapping.makeIsomorphic(n1, n2);
            }
            if (n1.isNodeTriple() && n2.isNodeTriple()) {
                Triple t1 = n1.getTriple();
                Triple t2 = n2.getTriple();
                return Iso.tripleIso(t1, t2, this.mapping);
            }
            return false;
        }
    }
}

