/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.junit.sparql;

import org.apache.jena.arq.junit.SurpressedTest;
import org.apache.jena.arq.junit.manifest.ManifestEntry;
import org.apache.jena.arq.junit.sparql.tests.QueryExecTest;
import org.apache.jena.arq.junit.sparql.tests.QuerySyntaxTest;
import org.apache.jena.arq.junit.sparql.tests.SerializationTest;
import org.apache.jena.arq.junit.sparql.tests.UpdateExecTest;
import org.apache.jena.arq.junit.sparql.tests.UpdateSyntaxTest;
import org.apache.jena.atlas.lib.Creator;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.junit.QueryTestException;
import org.apache.jena.sparql.vocabulary.TestManifest;
import org.apache.jena.sparql.vocabulary.TestManifestUpdate_11;
import org.apache.jena.sparql.vocabulary.TestManifestX;
import org.apache.jena.sparql.vocabulary.TestManifest_11;

public class SparqlTests {
    public static Syntax defaultSyntaxForTests = Syntax.syntaxARQ;

    public static Runnable makeSPARQLTest(ManifestEntry entry) {
        if (entry.getAction() == null) {
            System.out.println("Null action: " + entry);
            return null;
        }
        Syntax querySyntax = Syntax.syntaxSPARQL_11;
        Syntax querySyntax11 = defaultSyntaxForTests;
        Syntax updateSyntax11 = defaultSyntaxForTests;
        if (!(querySyntax == null || querySyntax.equals((Object)Syntax.syntaxARQ) || querySyntax.equals((Object)Syntax.syntaxSPARQL_10) || querySyntax.equals((Object)Syntax.syntaxSPARQL_11))) {
            throw new QueryTestException("Unknown syntax: " + querySyntax);
        }
        Resource testType = entry.getTestType();
        if (testType == null) {
            testType = TestManifest.QueryEvaluationTest;
        }
        if (testType.equals((Object)TestManifest.PositiveSyntaxTest)) {
            return new QuerySyntaxTest(entry, querySyntax, true);
        }
        if (testType.equals((Object)TestManifest_11.PositiveSyntaxTest11)) {
            return new QuerySyntaxTest(entry, querySyntax11, true);
        }
        if (testType.equals((Object)TestManifestX.PositiveSyntaxTestARQ)) {
            return new QuerySyntaxTest(entry, Syntax.syntaxARQ, true);
        }
        if (testType.equals((Object)TestManifest.NegativeSyntaxTest)) {
            return new QuerySyntaxTest(entry, querySyntax, false);
        }
        if (testType.equals((Object)TestManifest_11.NegativeSyntaxTest11)) {
            Syntax syn = querySyntax11;
            if (entry.getAction().getURI().contains("/Syntax-SPARQL_11/syn-bad-")) {
                syn = Syntax.syntaxSPARQL_11;
            }
            return new QuerySyntaxTest(entry, syn, false);
        }
        if (testType.equals((Object)TestManifestX.NegativeSyntaxTestARQ)) {
            return new QuerySyntaxTest(entry, Syntax.syntaxARQ, false);
        }
        if (testType.equals((Object)TestManifest_11.PositiveUpdateSyntaxTest11)) {
            return new UpdateSyntaxTest(entry, updateSyntax11, true);
        }
        if (testType.equals((Object)TestManifestX.PositiveUpdateSyntaxTestARQ)) {
            return new UpdateSyntaxTest(entry, Syntax.syntaxARQ, true);
        }
        if (testType.equals((Object)TestManifest_11.NegativeUpdateSyntaxTest11)) {
            return new UpdateSyntaxTest(entry, querySyntax11, false);
        }
        if (testType.equals((Object)TestManifestX.NegativeUpdateSyntaxTestARQ)) {
            return new UpdateSyntaxTest(entry, Syntax.syntaxARQ, false);
        }
        if (testType.equals((Object)TestManifest.QueryEvaluationTest)) {
            return new QueryExecTest(entry);
        }
        if (testType.equals((Object)TestManifestX.TestQuery)) {
            return new QueryExecTest(entry);
        }
        if (testType.equals((Object)TestManifestUpdate_11.UpdateEvaluationTest)) {
            return new UpdateExecTest(entry);
        }
        if (testType.equals((Object)TestManifest_11.UpdateEvaluationTest)) {
            return new UpdateExecTest(entry);
        }
        if (testType.equals((Object)TestManifestX.TestSerialization)) {
            return new SerializationTest(entry);
        }
        if (testType.equals((Object)TestManifest.ReducedCardinalityTest)) {
            return new QueryExecTest(entry);
        }
        if (testType.equals((Object)TestManifestX.TestSurpressed)) {
            return new SurpressedTest(entry);
        }
        if (testType.equals((Object)TestManifest_11.CSVResultFormatTest)) {
            Log.warn((Object)"Tests", (String)("Skip CSV test: " + entry.getName()));
            return null;
        }
        return null;
    }

    public static Runnable makeSPARQLTestExecOnly(ManifestEntry entry, Creator<Dataset> maker) {
        Resource testType = entry.getTestType();
        if (testType == null) {
            testType = TestManifest.QueryEvaluationTest;
        }
        if (testType != null) {
            if (testType.equals((Object)TestManifest.QueryEvaluationTest)) {
                return new QueryExecTest(entry, maker);
            }
            if (testType.equals((Object)TestManifestX.TestQuery)) {
                return new QueryExecTest(entry, maker);
            }
        }
        return null;
    }
}

