/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.Tuple1;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.builders.BuilderNode;
import org.apache.jena.sparql.util.EqualityTest;
import org.apache.jena.sparql.util.Iso;
import org.apache.jena.sparql.util.IsoAlg;
import org.apache.jena.sparql.util.IsoMatcher;
import org.apache.jena.sparql.util.NodeUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestIsoMatcher {
    private static Node[] T = new Node[0];

    @Test
    public void iso_00() {
        this.testGraph("", "", true);
    }

    @Test
    public void iso_graph_01() {
        this.testGraph("(<x> <p> 1)", "(<x> <p> 1)", true);
    }

    @Test
    public void iso_graph_02() {
        this.testGraph("(<x> <p> 1)", "(<x> <p> 2)", false);
    }

    @Test
    public void iso_graph_03() {
        this.testGraph("(<x> <p> 1) (<x> <p> 2)", "(<x> <p> 2)", false);
    }

    @Test
    public void iso_graph_04() {
        this.testGraph("(<x> <p> _:a)", "(<x> <p> 2)", false);
    }

    @Test
    public void iso_graph_05() {
        this.testGraph("(<x> <p> _:a)", "(<x> <p> _:b)", true);
    }

    @Test
    public void iso_graph_06() {
        this.testGraph("(_:a <p> _:a)", "(_:b <p> _:b)", true);
    }

    @Test
    public void iso_graph_07() {
        this.testGraph("(_:a1 <p> _:a2)", "(_:bb <p> _:bb)", false);
    }

    @Test
    public void iso_graph_10() {
        this.testGraph("(_:a _:a _:a)", "(_:b _:b _:b)", true);
    }

    @Test
    public void iso_graph_11() {
        this.testGraph("(_:a _:a _:a)", "(_:z _:b _:b)", false);
    }

    @Test
    public void iso_graph_12() {
        this.testGraph("(_:a _:a _:a)", "(_:b _:z _:b)", false);
    }

    @Test
    public void iso_graph_13() {
        this.testGraph("(_:a _:a _:a)", "(_:b _:b _:z)", false);
    }

    @Test
    public void iso_graph_14() {
        this.testGraph("(_:a _:a _:b)", "(_:b _:b _:z)", true);
    }

    @Test
    public void iso_graph_15() {
        this.testGraph("(_:a _:x _:a)", "(_:b _:z _:b)", true);
    }

    @Test
    public void iso_graph_16() {
        this.testGraph("(_:x _:a _:a)", "(_:z _:b _:b)", true);
    }

    @Test
    public void iso_graph_20() {
        this.testGraph("(<x> <p> _:a) (<z> <p> _:a)", "(<x> <p> _:b) (<z> <p> _:b)", true);
    }

    @Test
    public void iso_graph_21() {
        this.testGraph("(<x> <p> _:a1) (<z> <p> _:a2)", "(<x> <p> _:b) (<z> <p> _:b)", false);
    }

    @Test
    public void iso_graph_22() {
        this.testGraph("(_:a <p> _:a) (<s> <q> _:a)", "(_:b <p> _:b) (<s> <q> _:b)", true);
    }

    @Test
    public void iso_graph_23() {
        this.testGraph("(_:a <p> _:a) (<s> <q> _:a)", "(_:b <p> _:b) (<s> <q> _:c)", false);
    }

    @Test
    public void iso_graph_24() {
        this.testGraph("(_:a <p> _:a) (<s> <q> _:a) (_:b <q> _:b)", "(_:b <p> _:b) (<s> <q> _:b) (_:b <q> _:b)", false);
    }

    @Test
    public void iso_graph_30() {
        this.testGraphVar("(?A :p1 ?B)  (?B :p2 ?A)", "(?A :p1 ?B1) (?A :p2 ?B1)", false);
    }

    @Test
    public void iso_graph_31() {
        this.testGraphVar("(?A :p1 ?B) (?B :p2 ?A)", "(?A :p1 ?B) (?A :p2 ?B)", false);
    }

    @Test
    public void iso_graph_32() {
        this.testGraphVar("(?X :p1 ?Y) (?Y :p2 ?X)", "(?A :p1 ?B) (?A :p2 ?B)", false);
    }

    @Test
    public void iso_graph_33() {
        this.testGraphVar("(?X :p1 ?Y) (?Y :p2 ?X)", "(?A :p1 ?B) (?B :p2 ?A)", true);
    }

    @Test
    public void iso_graph_34() {
        this.testGraphVar("(?X :p1 ?Y) (?X :p2 ?Y)", "(?A :p1 ?B) (?A :p2 ?B)", true);
    }

    @Test
    public void iso_graph_35() {
        this.testGraph("(<_:a> :p1 <_:b>) (<_:b> :p2 <_:a>)", "(<_:a> :p1 <_:b>) (<_:a> :p2 <_:b>)", false);
    }

    @Test
    public void iso_graph_36() {
        this.testGraph("(<_:a> :p1 <_:b>) (<_:b> :p2 <_:a>)", "(<_:a> :p1 <_:b>) (<_:b> :p2 <_:a>)", true);
    }

    @Test
    public void iso_graph_40() {
        this.testGraphIso("(<<:s :p :o>> :q1 :z1) (<<_:a :p :o>> :q2 :z2)", "(<<_:a :p :o>> :q2 :z2) (<<:s :p :o>> :q1 :z1)", true);
    }

    @Test
    public void iso_graph_41() {
        this.testGraphIso("(<< _:a :p :o>> :q1 :z1) (<< _:a :p :o>> :q2 :z2) (_:a :p :o)", "(<< _:a :p :o>> :q2 :z2) (<< _:a :p :o>> :q1 :z1) (_:a :p :o)", true);
    }

    @Test
    public void iso_graph_42() {
        this.testGraphIso("(<<<_:a> :p :o>> :q1 :z1) (<<<_:a> :p :o>> :q2 :z2)", "(<<<_:a> :p :o>> :q2 :z2) (<<<_:b> :p :o>> :q1 :z1)", false);
    }

    @Test
    public void iso_graph_43() {
        this.testGraphIso("(<< << _:a :p :o >> :q1 :z1>> :q2 :z2)", "(<< << _:a :p :o >> :q1 :z1>> :q2 :z2)", true);
    }

    @Test
    public void iso_graph_44() {
        this.testGraphIso("(<< :a1 :q1 << :s :p _:o >> >> :q2 :z2)", "(<< :a1 :q1 << :s :p _:o >> >> :q2 :z2)", true);
    }

    @Test
    public void iso_triple_terms_1() {
        TestIsoMatcher.testTripleTerms("<< <_:a1> :p :o>>", "<< <_:a2> :p :o>>", true);
    }

    @Test
    public void iso_triple_terms_2() {
        TestIsoMatcher.testTripleTerms("<< <_:a1> :p :o>>", "<<:s :p <_:a3> >>", false);
    }

    @Test
    public void iso_triple_terms_3() {
        TestIsoMatcher.testTripleTerms("<< <_:a4> :p <_:a4> >>", "<< <_:a5> :p <_:a5> >>", true);
    }

    @Test
    public void iso_triple_terms_4() {
        TestIsoMatcher.testTripleTerms("<< <_:a4> :p <_:a4> >>", "<< <_:a6> :p <_:b6> >>", false);
    }

    @Test
    public void iso_triple_terms_5() {
        TestIsoMatcher.testTripleTerms("<< <_:a7> :p << <_:b7> :q :o >> >>", "<< <_:a8> :p << <_:b8> :q :o >> >>", true);
    }

    @Test
    public void iso_triple_terms_6() {
        TestIsoMatcher.testTripleTerms("<< <_:a7> :p << <_:b7> :q :o >> >>", "<< <_:a9> :p << :s :q :o >>>>", false);
    }

    @Test
    public void iso_dsg_50() {
        this.testDSG("(graph (_:a <p> _:a)) (graph <g> (<s> <q> _:a))", "(graph (_:a <p> _:a)) (graph <g> (<s> <q> _:a))", true);
    }

    @Test
    public void iso_dsg_51() {
        this.testDSG("(graph (_:a <p> _:a)) (graph <g> (<s> <q> _:a))", "(graph (_:a <p> _:a)) (graph <g> (<s> <q> _:b))", false);
    }

    @Test
    public void iso_dsg_52() {
        this.testDSG("(:g << << _:a :p :o >> :q1 :z1>> :q2 :z2)", "(:g << << _:a :p :o >> :q1 :z1>> :q2 :z2)", true);
    }

    @Test
    public void iso_tuples_61() {
        String[] x1 = new String[]{};
        String[] x2 = new String[]{};
        this.testTuples(x1, x2, true);
    }

    @Test
    public void iso_tuples_62() {
        String[] x1 = new String[]{"(<x> <p> 1)"};
        String[] x2 = new String[]{};
        this.testTuples(x1, x2, false);
    }

    @Test
    public void iso_tuples_63() {
        String[] x1 = new String[]{"(_:x <p> 1)"};
        String[] x2 = new String[]{"(_:y <p> 1)"};
        this.testTuples(x1, x2, true);
    }

    @Test
    public void iso_tuples_64() {
        String[] x1 = new String[]{"(_:x <p> 1)", "(_:x <p> 1)"};
        String[] x2 = new String[]{"(_:y <p> 1)", "(_:x <p> 1)"};
        this.testTuples(x1, x2, true);
    }

    @Test
    public void iso_tuples_65() {
        String[] x1 = new String[]{"(_:x <p> 1)", "(_:y <p> 1)"};
        String[] x2 = new String[]{"(_:y <p> 1)", "(_:x <p> 1)"};
        this.testTuples(x1, x2, true);
    }

    @Test
    public void iso_tuples_66() {
        String[] x1 = new String[]{"(_:a <p> 1)", "(_:b <p> 1)", "(_:a <p> 2)"};
        String[] x2 = new String[]{"(_:y <p> 1)", "(_:z <p> 1)", "(_:z <p> 2)"};
        this.testTuples(x1, x2, true);
    }

    private void testTuples(String[] x1, String[] x2, boolean iso) {
        List<Tuple<Node>> t1 = this.tuples(x1);
        List<Tuple<Node>> t2 = this.tuples(x2);
        this.test$(t1, t2, iso);
    }

    private void test$(List<Tuple<Node>> t1, List<Tuple<Node>> t2, boolean iso) {
        boolean b = IsoMatcher.isomorphic(t1, t2);
        if (b != iso) {
            System.out.println("====");
            System.out.println(t1);
            System.out.println("----");
            System.out.println(t2);
            System.out.println("Expected: " + iso + "; got: " + b);
        }
        Assert.assertEquals((Object)iso, (Object)b);
    }

    private List<Tuple<Node>> tuples(String ... strings) {
        ArrayList<Tuple<Node>> tuples = new ArrayList<Tuple<Node>>();
        for (String s : strings) {
            Item item = SSE.parse((String)s);
            List list = BuilderNode.buildNodeList((Item)item);
            Tuple tuple = TupleFactory.tuple((Object[])list.toArray(T));
            tuples.add((Tuple<Node>)tuple);
        }
        return tuples;
    }

    private static void testTripleTerms(String term1, String term2, boolean expected) {
        List<Tuple1> x2;
        Node n1 = SSE.parseNode((String)term1);
        Node n2 = SSE.parseNode((String)term2);
        List<Tuple1> x1 = Collections.singletonList(TupleFactory.create1((Object)n1));
        boolean b = IsoMatcher.isomorphic(x1, x2 = Collections.singletonList(TupleFactory.create1((Object)n2)));
        if (b != expected) {
            System.out.println("====");
            System.out.println(n1);
            System.out.println("----");
            System.out.println(n2);
            System.out.println("Expected: " + expected + "; got: " + b);
        }
        Assert.assertEquals((Object)expected, (Object)b);
    }

    private void testGraphIso(String s1, String s2, boolean result) {
        this.testGraph$(s1, s2, result, false);
        this.testGraph$(s2, s1, result, false);
    }

    private void testGraph(String s1, String s2, boolean result) {
        this.testGraph$(s1, s2, result, true);
        this.testGraph$(s2, s1, result, true);
    }

    private void testGraph$(String s1, String s2, boolean expected, boolean extraCheck) {
        Graph g2;
        s1 = "(graph " + (String)s1 + ")";
        s2 = "(graph " + (String)s2 + ")";
        Graph g1 = SSE.parseGraph((String)s1);
        boolean b = IsoMatcher.isomorphic((Graph)g1, (Graph)(g2 = SSE.parseGraph((String)s2)));
        if (b != expected) {
            System.out.println("====");
            SSE.write((Graph)g1);
            System.out.println("----");
            SSE.write((Graph)g2);
            System.out.println("Expected: " + expected + "; got: " + b);
        }
        Assert.assertEquals((Object)expected, (Object)b);
        if (!extraCheck) {
            return;
        }
        Assert.assertEquals((Object)b, (Object)g1.isIsomorphicWith(g2));
    }

    private void testGraphVar(String s1, String s2, boolean result) {
        this.testGraphVar$(s1, s2, result);
        this.testGraphVar$(s2, s1, result);
    }

    private void testGraphVar$(String s1, String s2, boolean expected) {
        List x2;
        s1 = "(graph " + (String)s1 + ")";
        s2 = "(graph " + (String)s2 + ")";
        Graph g1 = SSE.parseGraph((String)s1);
        Graph g2 = SSE.parseGraph((String)s2);
        List x1 = IsoMatcher.tuplesTriples((Iterator)g1.find());
        boolean b = IsoAlg.isIsomorphic((Collection)x1, (Collection)(x2 = IsoMatcher.tuplesTriples((Iterator)g2.find())), (Iso.Mappable)Iso.mappableBlankNodesVariables, (EqualityTest)NodeUtils.sameRdfTerm);
        if (b != expected) {
            System.out.println("====");
            SSE.write((Graph)g1);
            System.out.println("----");
            SSE.write((Graph)g2);
            System.out.println("Expected: " + expected + "; got: " + b);
        }
        Assert.assertEquals((Object)expected, (Object)b);
    }

    private void testDSG(String s1, String s2, boolean iso) {
        this.testDSG$(s1, s2, iso);
        this.testDSG$(s2, s1, iso);
    }

    private void testDSG$(String s1, String s2, boolean iso) {
        DatasetGraph dsg2;
        s1 = "(dataset " + (String)s1 + ")";
        s2 = "(dataset " + (String)s2 + ")";
        DatasetGraph dsg1 = SSE.parseDatasetGraph((String)s1);
        boolean b = IsoMatcher.isomorphic((DatasetGraph)dsg1, (DatasetGraph)(dsg2 = SSE.parseDatasetGraph((String)s2)));
        if (b != iso) {
            System.out.println("====");
            SSE.write((DatasetGraph)dsg1);
            System.out.println("----");
            SSE.write((DatasetGraph)dsg2);
            System.out.println("Expected: " + iso + "; got: " + b);
        }
        Assert.assertEquals((Object)iso, (Object)b);
    }
}

