/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFWriter;
import org.apache.jena.riot.RiotException;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestRDFWriter {
    private static Graph graph = SSE.parseGraph((String)"(graph (:s :p :o))");

    @Test
    public void rdfwriter_1() {
        RDFWriter.create((Graph)graph).build();
    }

    @Test(expected=RiotException.class)
    public void rdfwriter_2() {
        RDFWriter.create().build();
    }

    @Test
    public void rdfwriter_3() {
        String s = RDFWriter.create().source(graph).lang(Lang.NT).asString();
        Assert.assertTrue((boolean)s.contains("example/s"));
    }

    @Test(expected=RiotException.class)
    public void rdfwriter_4() {
        String s = RDFWriter.create().source(graph).asString();
    }

    @Test
    public void rdfwriter_5() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        RDFWriter.create().source(graph).lang(Lang.NT).output((OutputStream)bout);
        String s = StrUtils.fromUTF8bytes((byte[])bout.toByteArray());
        Assert.assertTrue((boolean)s.contains("example/s"));
    }

    @Test
    public void rdfwriter_6() {
        CharArrayWriter w = new CharArrayWriter();
        RDFWriter.create().source(graph).lang(Lang.NT).build().output((Writer)w);
        String s = ((Object)w).toString();
        Assert.assertTrue((boolean)s.contains("example/s"));
    }
}

