/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.junit.Assert;
import org.junit.Test;

public class TestRiotReader {
    @Test
    public void testCreateIteratorTriples_01() {
        Iterator it = RDFDataMgr.createIteratorTriples((InputStream)new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8)), (Lang)RDFLanguages.NTRIPLES, (String)"http://example/");
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testEncodedUTF8() {
        Iterator it = RDFDataMgr.createIteratorTriples((InputStream)new ByteArrayInputStream("<a> <b> \"\\u263A\" .".getBytes(StandardCharsets.UTF_8)), (Lang)RDFLanguages.NTRIPLES, null);
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Object)"\u263a", (Object)((Triple)it.next()).getObject().getLiteralLexicalForm());
    }

    @Test
    public void testRawUTF8() {
        Iterator it = RDFDataMgr.createIteratorTriples((InputStream)new ByteArrayInputStream("<a> <b> \"\u263a\" .".getBytes(StandardCharsets.UTF_8)), (Lang)RDFLanguages.NTRIPLES, null);
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Object)"\u263a", (Object)((Triple)it.next()).getObject().getLiteralLexicalForm());
    }

    @Test
    public void testCreateIteratorTriples_02() {
        String x = StrUtils.strjoinNL((String[])new String[]{"<rdf:RDF", "   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"", "   xmlns:j.0=\"http://example/\">", "  <rdf:Description rdf:about=\"http://example/s\">", "     <j.0:p rdf:resource=\"http://example/o\"/>", "   </rdf:Description>", "</rdf:RDF>"});
        Iterator it = RDFDataMgr.createIteratorTriples((InputStream)new ByteArrayInputStream(x.getBytes()), (Lang)RDFLanguages.RDFXML, (String)"http://example/");
        Assert.assertTrue((boolean)it.hasNext());
        Triple t = (Triple)it.next();
        Assert.assertNotNull((Object)t);
        Assert.assertEquals((Object)"http://example/s", (Object)t.getSubject().getURI());
        Assert.assertEquals((Object)"http://example/p", (Object)t.getPredicate().getURI());
        Assert.assertEquals((Object)"http://example/o", (Object)t.getObject().getURI());
        Assert.assertFalse((boolean)it.hasNext());
    }
}

