/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.WebContent;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSyntaxDetermination {
    private String url;
    private String contentType;
    private Lang hintLang;
    private Lang expected;

    @Parameterized.Parameters(name="{0} -- {1} {2} {3} {4}")
    public static Iterable<Object[]> data() {
        ArrayList<Object[]> x = new ArrayList<Object[]>();
        TestSyntaxDetermination.add(x, "Test-ext-ttl-1", "http://sparql.org/D.ttl", "text/turtle", Lang.TTL, Lang.TTL);
        TestSyntaxDetermination.add(x, "Test-ext-ttl-2", "http://sparql.org/D.ttl", "text/turtle", Lang.RDFXML, Lang.TTL);
        TestSyntaxDetermination.add(x, "Test-ext-ttl-3", "http://sparql.org/D.ttl", "text/plain", null, Lang.TTL);
        TestSyntaxDetermination.add(x, "Test-ext-ttl-4", "http://sparql.org/D.ttl", "text/plain", Lang.RDFXML, Lang.RDFXML);
        TestSyntaxDetermination.add(x, "Test-ext-ttl-5", "http://sparql.org/D.ttl", null, Lang.TTL, Lang.TTL);
        TestSyntaxDetermination.add(x, "Test-ext-ttl-6", "http://sparql.org/D.ttl", null, null, Lang.TTL);
        TestSyntaxDetermination.add(x, "Test-no-ext-1", "http://sparql.org/D", "text/turtle", Lang.TTL, Lang.TTL);
        TestSyntaxDetermination.add(x, "Test-no-ext-2", "http://sparql.org/D", "text/turtle", Lang.RDFXML, Lang.TTL);
        TestSyntaxDetermination.add(x, "Test-no-ext-3", "http://sparql.org/D", "text/plain", null, null);
        TestSyntaxDetermination.add(x, "Test-no-ext-4", "http://sparql.org/D", "text/plain", Lang.RDFXML, Lang.RDFXML);
        TestSyntaxDetermination.add(x, "Test-no-ext-5", "http://sparql.org/D", null, Lang.NT, Lang.NT);
        TestSyntaxDetermination.add(x, "Test-no-ext-6", "http://sparql.org/D", null, null, null);
        TestSyntaxDetermination.add(x, "Test-ext-rdf-1", "http://sparql.org/D.rdf", "text/turtle", Lang.TTL, Lang.TTL);
        TestSyntaxDetermination.add(x, "Test-ext-rdf-2", "http://sparql.org/D.rdf", "text/turtle", Lang.RDFXML, Lang.TTL);
        TestSyntaxDetermination.add(x, "Test-ext-rdf-3", "http://sparql.org/D.rdf", "text/plain", null, Lang.RDFXML);
        TestSyntaxDetermination.add(x, "Test-ext-rdf-4", "http://sparql.org/D.rdf", "text/plain", Lang.RDFXML, Lang.RDFXML);
        TestSyntaxDetermination.add(x, "Test-ext-rdf-5", "http://sparql.org/D.rdf", null, Lang.TTL, Lang.TTL);
        TestSyntaxDetermination.add(x, "Test-ext-rdf-6", "http://sparql.org/D.rdf", null, null, Lang.RDFXML);
        TestSyntaxDetermination.add(x, "Test-unknown-ext-1", "http://sparql.org/D.xyz", "text/turtle", Lang.TTL, Lang.TTL);
        TestSyntaxDetermination.add(x, "Test-unknown-ext-2", "http://sparql.org/D.xyz", "text/turtle", Lang.RDFXML, Lang.TTL);
        TestSyntaxDetermination.add(x, "Test-unknown-ext-3", "http://sparql.org/D.xyz", "text/plain", null, null);
        TestSyntaxDetermination.add(x, "Test-unknown-ext-4", "http://sparql.org/D.xyz", "text/plain", Lang.RDFXML, Lang.RDFXML);
        TestSyntaxDetermination.add(x, "Test-unknown-ext-5", "http://sparql.org/D.xyz", null, Lang.NT, Lang.NT);
        TestSyntaxDetermination.add(x, "Test-unknown-ext-6", "http://sparql.org/D.xyz", null, null, null);
        return x;
    }

    private static void add(List<Object[]> x, Object ... args) {
        if (args.length != 5) {
            throw new RuntimeException();
        }
        x.add(args);
    }

    public TestSyntaxDetermination(String marker, String url, String contentType, Lang hintLang, Lang expected) {
        this.url = url;
        this.contentType = contentType;
        this.hintLang = hintLang;
        this.expected = expected;
    }

    @Test
    public void syntaxDetermination() {
        TestSyntaxDetermination.test(this.url, this.contentType, this.hintLang, this.expected);
    }

    static void test(String url, String ct, Lang hint, Lang expected) {
        ContentType x = WebContent.determineCT((String)ct, (Lang)hint, (String)url);
        Lang lang = RDFDataMgr.determineLang((String)url, (String)ct, (Lang)hint);
        Assert.assertEquals((Object)expected, (Object)lang);
    }
}

