/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.util.ArrayList;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.lang.BlankNodeAllocator;
import org.apache.jena.riot.lang.BlankNodeAllocatorGlobal;
import org.apache.jena.riot.lang.BlankNodeAllocatorHash;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestBlankNodeAllocator {
    private Factory factory;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> data() {
        ArrayList<Object[]> x = new ArrayList<Object[]>();
        Factory fSeededHashAlloc = new Factory(){

            @Override
            public BlankNodeAllocator create() {
                return new BlankNodeAllocatorHash();
            }

            public String toString() {
                return "SeededHash";
            }
        };
        Factory fUIDAlloc = new Factory(){

            @Override
            public BlankNodeAllocator create() {
                return new BlankNodeAllocatorGlobal();
            }

            public String toString() {
                return "UID";
            }
        };
        x.add(new Object[]{fSeededHashAlloc});
        x.add(new Object[]{fUIDAlloc});
        return x;
    }

    public TestBlankNodeAllocator(Factory factory) {
        this.factory = factory;
    }

    @Test
    public void alloc_01() {
        BlankNodeAllocator alloc = this.factory.create();
        Node n = alloc.create();
        Assert.assertTrue((boolean)n.isBlank());
    }

    @Test
    public void alloc_02() {
        BlankNodeAllocator alloc = this.factory.create();
        Node n1 = alloc.create();
        Node n2 = alloc.create();
        Assert.assertNotEquals((Object)n1, (Object)n2);
    }

    @Test
    public void alloc_03() {
        BlankNodeAllocator alloc = this.factory.create();
        Node n1 = alloc.alloc("foo");
        Node n2 = alloc.alloc("foo");
        Assert.assertEquals((Object)n1, (Object)n2);
    }

    @Test
    public void alloc_04() {
        BlankNodeAllocator alloc = this.factory.create();
        Node n1 = alloc.alloc("foo");
        Node n2 = alloc.alloc("bar");
        Assert.assertNotEquals((Object)n1, (Object)n2);
    }

    public static interface Factory {
        public BlankNodeAllocator create();
    }
}

