/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapStd;
import org.apache.jena.riot.system.RiotLib;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRiotLib {
    private PrefixMap prefixMap;
    private static final String expectedNewStyle = "PREFIX dct:        <http://purl.org/dc/terms/>\nPREFIX lcc-3166-1: <http://www.omg.org/spec/LCC/Countries/ISO3166-1-CountryCodes/>\nPREFIX lcc-3166-2: <http://www.omg.org/spec/LCC/Countries/ISO3166-2-SubdivisionCodes/>\nPREFIX lcc-cr:     <http://www.omg.org/spec/LCC/Countries/CountryRepresentation/>\nPREFIX lcc-lr:     <http://www.omg.org/spec/LCC/Languages/LanguageRepresentation/>\nPREFIX owl:        <http://www.w3.org/2002/07/owl#>\nPREFIX rdf:        <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs:       <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX skos:       <http://www.w3.org/2004/02/skos/core#>\nPREFIX sm:         <http://www.omg.org/techprocess/ab/SpecificationMetadata/>\nPREFIX xsd:        <http://www.w3.org/2001/XMLSchema#>\n";
    private static final String expectedOldStyle = "@prefix dct:        <http://purl.org/dc/terms/> .\n@prefix lcc-3166-1: <http://www.omg.org/spec/LCC/Countries/ISO3166-1-CountryCodes/> .\n@prefix lcc-3166-2: <http://www.omg.org/spec/LCC/Countries/ISO3166-2-SubdivisionCodes/> .\n@prefix lcc-cr:     <http://www.omg.org/spec/LCC/Countries/CountryRepresentation/> .\n@prefix lcc-lr:     <http://www.omg.org/spec/LCC/Languages/LanguageRepresentation/> .\n@prefix owl:        <http://www.w3.org/2002/07/owl#> .\n@prefix rdf:        <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n@prefix rdfs:       <http://www.w3.org/2000/01/rdf-schema#> .\n@prefix skos:       <http://www.w3.org/2004/02/skos/core#> .\n@prefix sm:         <http://www.omg.org/techprocess/ab/SpecificationMetadata/> .\n@prefix xsd:        <http://www.w3.org/2001/XMLSchema#> .\n";

    @Before
    public void setupMaps() {
        this.prefixMap = new PrefixMapStd();
        this.prefixMap.add("lcc-3166-1", "http://www.omg.org/spec/LCC/Countries/ISO3166-1-CountryCodes/");
        this.prefixMap.add("dct", "http://purl.org/dc/terms/");
        this.prefixMap.add("owl", "http://www.w3.org/2002/07/owl#");
        this.prefixMap.add("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.prefixMap.add("lcc-3166-2", "http://www.omg.org/spec/LCC/Countries/ISO3166-2-SubdivisionCodes/");
        this.prefixMap.add("xsd", "http://www.w3.org/2001/XMLSchema#");
        this.prefixMap.add("skos", "http://www.w3.org/2004/02/skos/core#");
        this.prefixMap.add("sm", "http://www.omg.org/techprocess/ab/SpecificationMetadata/");
        this.prefixMap.add("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.prefixMap.add("lcc-lr", "http://www.omg.org/spec/LCC/Languages/LanguageRepresentation/");
        this.prefixMap.add("lcc-cr", "http://www.omg.org/spec/LCC/Countries/CountryRepresentation/");
    }

    @Test
    public void sortPrefixesNewStyle() {
        IndentedLineBuffer writer = new IndentedLineBuffer();
        RiotLib.writePrefixes((IndentedWriter)writer, (PrefixMap)this.prefixMap, (boolean)true);
        String result = writer.asString();
        Assert.assertEquals((Object)expectedNewStyle, (Object)result);
    }

    @Test
    public void sortPrefixesOldStyle() {
        IndentedLineBuffer writer = new IndentedLineBuffer();
        RiotLib.writePrefixes((IndentedWriter)writer, (PrefixMap)this.prefixMap, (boolean)false);
        String result = writer.asString();
        Assert.assertEquals((Object)expectedOldStyle, (Object)result);
    }
}

