/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.thrift;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.riot.thrift.BinRDF;
import org.apache.jena.sparql.resultset.ResultSetCompare;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.builders.BuilderResultSet;
import org.junit.Assert;
import org.junit.Test;

public class TestResultSetThrift {
    static ResultSetRewindable rs0 = TestResultSetThrift.make("(resultset (?x ?y)", "   (row (?x _:a) (?y 3))", "   (row (?x 1) (?y 'a'))", "   (row (?y 'y'))", "   (row (?x _:a))", "   (row)", "   (row (?x 2) (?y 10))", ")");
    static ResultSetRewindable rs1 = TestResultSetThrift.make("(resultset (?x ?y)", "   (row (?x 1) (?y 3))", "   (row (?x 1) (?y 'a'))", ")");
    static ResultSetRewindable rs2 = TestResultSetThrift.make("(resultset (?x ?y)", "   (row (?x 1) (?y 'a'))", "   (row (?x 1) (?y 3))", ")");
    private static final String DIR = "testing/RIOT/RDF-Thrift";

    @Test
    public void resultSet_01() {
        TestResultSetThrift.test(rs0);
    }

    @Test
    public void resultSet_02() {
        ResultSetRewindable r1 = TestResultSetThrift.test(rs1);
        r1.reset();
        rs2.reset();
        Assert.assertFalse((boolean)ResultSetCompare.equalsByTermAndOrder((ResultSet)r1, (ResultSet)rs2));
        rs2.reset();
    }

    @Test
    public void resultSet_03() {
        ResultSetRewindable r2 = TestResultSetThrift.test(rs2);
        r2.reset();
        rs1.reset();
        Assert.assertFalse((boolean)ResultSetCompare.equalsByTermAndOrder((ResultSet)r2, (ResultSet)rs1));
        rs1.reset();
    }

    private static ResultSetRewindable test(ResultSetRewindable resultSet) {
        resultSet.reset();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinRDF.writeResultSet((OutputStream)out, (ResultSet)resultSet, (boolean)true);
        resultSet.reset();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ResultSet rs$ = BinRDF.readResultSet((InputStream)in);
        ResultSetRewindable resultSet2 = ResultSetFactory.makeRewindable((ResultSet)rs$);
        ResultSetCompare.equalsExact((ResultSet)resultSet, (ResultSet)resultSet2);
        resultSet.reset();
        resultSet2.reset();
        return resultSet2;
    }

    private static ResultSetRewindable make(String ... strings) {
        String s = StrUtils.strjoinNL((String[])strings);
        Item item = SSE.parse((String)s);
        ResultSetRewindable rs = ResultSetFactory.makeRewindable((ResultSet)BuilderResultSet.build((Item)item));
        return rs;
    }

    @Test
    public void resultSet_10() {
        try (InputStream in = IO.openFile((String)"testing/RIOT/RDF-Thrift/results-1.srj");){
            ResultSet rs = ResultSetFactory.fromJSON((InputStream)in);
            TestResultSetThrift.test(ResultSetFactory.copyResults((ResultSet)rs));
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
        }
    }
}

