/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.web;

import org.apache.jena.riot.WebContent;
import org.junit.Assert;
import org.junit.Test;

public class TestWebContent {
    @Test
    public void testCanonicaliseMimeTypes1() {
        this.testCanonicalise("text/turtle", "text/turtle");
        this.testCanonicalise("application/turtle", "text/turtle");
    }

    @Test
    public void testCanonicaliseMimeTypes2() {
        this.testCanonicalise("text/rdf+n3", "text/rdf+n3");
        this.testCanonicalise("application/n3", "text/rdf+n3");
        this.testCanonicalise("text/n3", "text/rdf+n3");
    }

    @Test
    public void testCanonicaliseMimeTypes3() {
        this.testCanonicalise("application/n-triples", "application/n-triples");
        this.testCanonicalise("text/plain", "application/n-triples");
    }

    @Test
    public void testCanonicaliseMimeTypes4() {
        this.testCanonicalise("application/n-quads", "application/n-quads");
        this.testCanonicalise("text/n-quads", "application/n-quads");
    }

    @Test
    public void testCanonicaliseMimeTypes5() {
        this.testCanonicalise("application/trig", "application/trig");
        this.testCanonicalise("text/trig", "application/trig");
    }

    private void testCanonicalise(String input, String expected) {
        String canonical = WebContent.contentTypeCanonical((String)input);
        Assert.assertEquals((Object)expected, (Object)canonical);
    }
}

