/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.optimize.TransformPattern2Join;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.syntax.Element;
import org.junit.Assert;
import org.junit.Test;

public class TestPattern2Join {
    @Test
    public void bgp2join_01() {
        TestPattern2Join.test3("{}", "(table unit)");
    }

    @Test
    public void bgp2join_02() {
        TestPattern2Join.test3("{?s ?p ?o}", "(triple ?s ?p ?o)");
    }

    @Test
    public void bgp2join_03() {
        TestPattern2Join.test3("{?s1 ?p1 ?o1 . ?s2 ?p2 ?o2 . }", "(join ", "  (triple ?s1 ?p1 ?o1)", "  (triple ?s2 ?p2 ?o2) )");
    }

    @Test
    public void bgp2join_04() {
        TestPattern2Join.test3("{?s1 ?p1 ?o1 . ?s2 ?p2 ?o2 . ?s3 ?p3 ?o3 . }", "(join ", "   (join (triple ?s1 ?p1 ?o1) (triple ?s2 ?p2 ?o2))", "   (triple ?s3 ?p3 ?o3) )");
    }

    @Test
    public void qp2join_01() {
        TestPattern2Join.test4("{GRAPH ?g { }}", "(datasetnames ?g)");
    }

    @Test
    public void qp2join_02() {
        TestPattern2Join.test4("{GRAPH ?g { ?s ?p ?o  }}", "(quad ?g ?s ?p ?o)");
    }

    @Test
    public void qp2join_03() {
        TestPattern2Join.test4("{GRAPH ?g { ?s1 ?p1 ?o1 . ?s2 ?p2 ?o2 .  }}", "(join ", "  (quad ?g ?s1 ?p1 ?o1)", "  (quad ?g ?s2 ?p2 ?o2) )");
    }

    @Test
    public void qp2join_04() {
        TestPattern2Join.test4("{GRAPH ?g { ?s1 ?p1 ?o1 . ?s2 ?p2 ?o2 . ?s3 ?p3 ?o3 .}}", "(join ", "   (join (quad ?g ?s1 ?p1 ?o1) (quad ?g ?s2 ?p2 ?o2))", "   (quad ?g ?s3 ?p3 ?o3) )");
    }

    @Test
    public void qp2join_05() {
        TestPattern2Join.test4("{GRAPH ?g { ?s1 ?p1 ?o1 . ?s2 ?p2 ?o2 . ?s3 ?p3 ?o3 .}}", "(join ", "   (join (quad ?g ?s1 ?p1 ?o1) (quad ?g ?s2 ?p2 ?o2))", "   (quad ?g ?s3 ?p3 ?o3) )");
    }

    @Test
    public void qp2join_06() {
        TestPattern2Join.test4("{GRAPH ?g1 { ?s1 ?p1 ?o1 } GRAPH ?g2 { ?s2 ?p2 ?o2 } }", "(join (quad ?g1 ?s1 ?p1 ?o1) (quad ?g2 ?s2 ?p2 ?o2) )");
    }

    @Test
    public void qp2join_07() {
        TestPattern2Join.test4("{GRAPH ?g1 { ?s1 ?p1 ?o1 . ?s9 ?p9 ?o9} GRAPH ?g2 { ?s2 ?p2 ?o2 . ?s8 ?p8 ?o8}}", "(join ", "   (join (quad ?g1 ?s1 ?p1 ?o1) (quad ?g1 ?s9 ?p9 ?o9))", "   (join (quad ?g2 ?s2 ?p2 ?o2) (quad ?g2 ?s8 ?p8 ?o8))", ")");
    }

    private static void test3(String pattern, String ... joinForm) {
        Query q = QueryFactory.create((String)("PREFIX : <http://example/> SELECT * " + pattern));
        Op op = Algebra.compile((Element)q.getQueryPattern());
        TestPattern2Join.test(op, joinForm);
    }

    private static void test4(String pattern, String ... joinForm) {
        Query q = QueryFactory.create((String)("PREFIX : <http://example/> SELECT * " + pattern));
        Op op = Algebra.compile((Element)q.getQueryPattern());
        op = Algebra.toQuadForm((Op)op);
        TestPattern2Join.test(op, joinForm);
    }

    private static void test(Op input, String ... joinForm) {
        Op op2 = Transformer.transform((Transform)new TransformPattern2Join(), (Op)input);
        String x = StrUtils.strjoinNL((String[])joinForm);
        Op opExpected = SSE.parseOp((String)("(prefix ((: <http://example/>)) " + x + ")"));
        Assert.assertEquals((Object)opExpected, (Object)op2);
    }
}

