/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Creator;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.builders.BuilderGraph;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSpecialGraphNames {
    static String x1 = StrUtils.strjoinNL((String[])new String[]{"(dataset", "  (graph (<s> <p> <x>) (<x> <p> <o>) (<x2> <p> <o1>) (<x2> <p> <o3>) (<x2> <p> <o4>))", "  (graph <g1> (<s1> <p1> <s1>) (<s1> <p1> <s2>))", "  (graph <g2> (triple <s2> <p2> <o2>) (triple <s2> <p3> <o3>))", "  (graph <g3> (triple <s2> <p2> <o2>))", ")"});
    private DatasetGraph dsg;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> data() {
        Creator datasetGeneralMaker = () -> DatasetGraphFactory.createGeneral();
        Creator datasetTxnMemMaker = () -> DatasetGraphFactory.createTxnMem();
        Creator datasetMemMaker = () -> DatasetGraphFactory.create();
        return Arrays.asList({"General", datasetGeneralMaker}, {"Plain", datasetMemMaker}, {"TxnMem", datasetTxnMemMaker});
    }

    public TestSpecialGraphNames(String label, Creator<DatasetGraph> maker) {
        this.dsg = BuilderGraph.buildDataset((DatasetGraph)((DatasetGraph)maker.create()), (Item)SSE.parse((String)x1));
    }

    @Test
    public void union_dft_1t() {
        this.union_dft_1(Mode.TRIPLES);
    }

    @Test
    public void union_dft_1q() {
        this.union_dft_1(Mode.QUADS);
    }

    private void union_dft_1(Mode mode) {
        Op opPattern = SSE.parseOp((String)"(bgp (?s ?p ?o))");
        Op op = this.op("(bgp (?s ?p ?o))", mode);
        List<Binding> results = this.exec(op);
        Assert.assertEquals((long)5L, (long)results.size());
        OpGraph op2 = new OpGraph(Quad.unionGraph, opPattern);
        List<Binding> results2 = this.exec((Op)op2);
        Assert.assertEquals((long)4L, (long)results2.size());
    }

    @Test
    public void graph_union_1t() {
        List<Binding> results = this.exec("(graph <" + Quad.unionGraph.getURI() + "> (bgp (<s2> ?p ?o)))", Mode.TRIPLES);
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void graph_union_1q() {
        List<Binding> results = this.exec("(graph <" + Quad.unionGraph.getURI() + "> (bgp (<s2> ?p ?o)))", Mode.QUADS);
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void graph_union_2t() {
        List<Binding> results = this.exec("(graph <" + Quad.unionGraph.getURI() + "> (bgp (<s1> ?p ?o) (?o ?q ?z)  ))", Mode.TRIPLES);
        Assert.assertEquals((long)4L, (long)results.size());
    }

    @Test
    public void graph_union_2q() {
        List<Binding> results = this.exec("(graph <" + Quad.unionGraph.getURI() + "> (bgp (<s1> ?p ?o) (?o ?q ?z)  ))", Mode.QUADS);
        Assert.assertEquals((long)4L, (long)results.size());
    }

    @Test
    public void graph_dft_1t() {
        List<Binding> results = this.exec("(graph <" + Quad.defaultGraphIRI.getURI() + "> (bgp (<s2> ?p ?o)))", Mode.TRIPLES);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void graph_dft_1q() {
        List<Binding> results = this.exec("(graph <" + Quad.defaultGraphIRI.getURI() + "> (bgp (<s2> ?p ?o)))", Mode.QUADS);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void graph_dft_2t() {
        List<Binding> results = this.exec("(graph <" + Quad.defaultGraphIRI.getURI() + "> (bgp (<s> ?p ?o)))", Mode.TRIPLES);
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void graph_dft_2q() {
        List<Binding> results = this.exec("(graph <" + Quad.defaultGraphIRI.getURI() + "> (bgp (<s> ?p ?o)))", Mode.QUADS);
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void graph_dft_3t() {
        List<Binding> results = this.exec("(graph <" + Quad.defaultGraphIRI.getURI() + "> (bgp (?x ?p ?z) (?z ?q ?y) ))", Mode.TRIPLES);
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void graph_dft_3q() {
        List<Binding> results = this.exec("(graph <" + Quad.defaultGraphIRI.getURI() + "> (bgp (?x ?p ?z) (?z ?q ?y) ))", Mode.QUADS);
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void graph_dftg_1t() {
        List<Binding> results = this.exec("(graph <" + Quad.defaultGraphNodeGenerated.getURI() + "> (bgp (<s2> ?p ?o)))", Mode.TRIPLES);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void graph_dftg_2t() {
        List<Binding> results = this.exec("(graph <" + Quad.defaultGraphNodeGenerated.getURI() + "> (bgp (<x2> ?p ?o)))", Mode.TRIPLES);
        Assert.assertEquals((long)3L, (long)results.size());
    }

    @Test
    public void graph_dftg_1q() {
        List<Binding> results = this.exec("(graph <" + Quad.defaultGraphNodeGenerated.getURI() + "> (bgp (<s2> ?p ?o)))", Mode.QUADS);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void graph_dftg_2q() {
        List<Binding> results = this.exec("(graph <" + Quad.defaultGraphNodeGenerated.getURI() + "> (bgp (<x2> ?p ?o)))", Mode.QUADS);
        Assert.assertEquals((long)3L, (long)results.size());
    }

    @Test
    public void direct_3t() {
        List<Binding> results = this.exec("(graph <g1> (bgp (<s1> ?p ?o)))", Mode.TRIPLES);
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void direct_3q() {
        List<Binding> results = this.exec("(graph <g1> (bgp (<s1> ?p ?o)))", Mode.QUADS);
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void direct_4() {
        List<Binding> results = this.exec("(graph <g1> (bgp (<s2> ?p ?o)))", Mode.TRIPLES);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void direct_5() {
        List<Binding> results = this.exec("(graph <g2> (bgp (<s2> ?p ?o)))", Mode.TRIPLES);
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void minus_1() {
        List<Binding> results = this.exec("(minus (bgp (?s ?p ?o)) (bgp (<x2> ?p ?o)))", Mode.TRIPLES);
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void minus_2() {
        List<Binding> results = this.exec("(minus (bgp (?s ?p ?o)) (bgp (<x2> ?p ?o)))", Mode.QUADS);
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void minus_3() {
        List<Binding> results = this.exec("(minus (bgp (?s ?p ?o)) (bgp (<x2> ?p ?o)))", Mode.QUADBLOCKS);
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void filter_exists_1() {
        List<Binding> results = this.exec("(filter (exists (bgp (?s <p> <o>))) (bgp (?s ?p ?o)))", Mode.TRIPLES);
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void filter_exists_2() {
        List<Binding> results = this.exec("(filter (exists (bgp (?s <p> <o>))) (bgp (?s ?p ?o)))", Mode.QUADS);
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void filter_exists_3() {
        List<Binding> results = this.exec("(filter (exists (bgp (?s <p> <o>))) (bgp (?s ?p ?o)))", Mode.QUADBLOCKS);
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void filter_notexists_1() {
        List<Binding> results = this.exec("(filter (notexists (bgp (?s <p> <o>))) (bgp (?s ?p ?o)))", Mode.TRIPLES);
        Assert.assertEquals((long)4L, (long)results.size());
    }

    @Test
    public void filter_notexists_2() {
        List<Binding> results = this.exec("(filter (notexists (bgp (?s <p> <o>))) (bgp (?s ?p ?o)))", Mode.QUADS);
        Assert.assertEquals((long)4L, (long)results.size());
    }

    @Test
    public void filter_notexists_3() {
        List<Binding> results = this.exec("(filter (notexists (bgp (?s <p> <o>))) (bgp (?s ?p ?o)))", Mode.QUADBLOCKS);
        Assert.assertEquals((long)4L, (long)results.size());
    }

    private List<Binding> exec(String string, Mode mode) {
        Op op = this.op(string, mode);
        return this.exec(op);
    }

    private List<Binding> exec(Op op) {
        QueryIterator qIter = Algebra.exec((Op)op, (DatasetGraph)this.dsg);
        return Iter.toList((Iterator)qIter);
    }

    protected Op op(String pattern, Mode mode) {
        Op op = SSE.parseOp((String)pattern);
        if (mode == Mode.QUADS) {
            op = Algebra.toQuadForm((Op)op);
        } else if (mode == Mode.QUADBLOCKS) {
            op = Algebra.toQuadBlockForm((Op)op);
        }
        return op;
    }

    static enum Mode {
        TRIPLES,
        QUADS,
        QUADBLOCKS;

    }
}

