/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.util.Context;
import org.junit.Assert;
import org.junit.Test;

public class TestDataBagDistinctOrder {
    @Test
    public void distinctOrderSpill_1() {
        String qs = StrUtils.strjoinNL((String[])new String[]{"PREFIX  :     <http://example/>", "SELECT DISTINCT *", "{ ?x  :p  ?v }", "ORDER BY ASC(?v)"});
        Query query = QueryFactory.create((String)qs);
        Model model = RDFDataMgr.loadModel((String)"testing/ARQ/Extra/sort-distinct-data.ttl");
        QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Model)model);
        Context cxt = qExec.getContext();
        cxt.set(ARQ.spillToDiskThreshold, (Object)2L);
        List x = ResultSetFormatter.toList((ResultSet)qExec.execSelect());
        List z = x.stream().map(qsoln -> qsoln.getLiteral("v").getInt()).collect(Collectors.toList());
        for (int i = 0; i < z.size() - 1; ++i) {
            int v1 = (Integer)z.get(i);
            int v2 = (Integer)z.get(i + 1);
            if (v2 >= v1) continue;
            Assert.fail((String)("Data not sorted at (" + v1 + ", " + v2 + ") " + z));
        }
    }
}

