/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.graph.Node;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestCastXSD {
    private static boolean origValue;

    @BeforeClass
    public static void beforeClass() {
        origValue = NodeValue.VerboseWarnings;
        NodeValue.VerboseWarnings = false;
    }

    @AfterClass
    public static void afterClass() {
        NodeValue.VerboseWarnings = origValue;
    }

    @Test
    public void cast_to_integer_01() {
        this.testCast("xsd:integer('1e0'^^xsd:double)", "'1'^^xsd:integer");
    }

    @Test
    public void cast_to_integer_02() {
        this.testCast("xsd:byte('1e0'^^xsd:double)", "'1'^^xsd:byte");
    }

    @Test
    public void cast_to_integer_03() {
        this.testNoCast("xsd:byte('HaHa'^^xsd:double)");
    }

    @Test
    public void cast_to_integer_04() {
        this.testCast("xsd:byte('-1'^^xsd:double)", "'-1'^^xsd:byte");
    }

    @Test
    public void cast_to_integer_05() {
        this.testNoCast("xsd:unsignedInt('-1'^^xsd:double)");
    }

    @Test
    public void cast_to_integer_06() {
        this.testNoCast("xsd:byte('500'^^xsd:float)");
    }

    @Test
    public void cast_to_integer_07() {
        this.testCast("xsd:integer('1e20'^^xsd:double)", "100000000000000000000");
    }

    @Test
    public void cast_to_integer_08() {
        this.testCast("xsd:integer('1e19'^^xsd:double)", "10000000000000000000");
    }

    @Test
    public void cast_to_integer_09() {
        this.testCast("xsd:integer('1e18'^^xsd:double)", "1000000000000000000");
    }

    @Test
    public void cast_to_integer_10() {
        this.testCast("xsd:integer('+1'^^xsd:integer)", "'+1'^^xsd:integer");
    }

    @Test
    public void cast_to_integer_11() {
        this.testCast("xsd:byte('+1'^^xsd:integer)", "'+1'^^xsd:byte");
    }

    @Test
    public void cast_to_integer_12() {
        this.testNoCast("xsd:byte('HaHa'^^xsd:integer)");
    }

    @Test
    public void cast_to_integer_13() {
        this.testCast("xsd:byte('-1'^^xsd:integer)", "'-1'^^xsd:byte");
    }

    @Test
    public void cast_to_integer_14() {
        this.testNoCast("xsd:unsignedInt('-1'^^xsd:integer)");
    }

    @Test
    public void cast_to_integer_15() {
        this.testNoCast("xsd:byte('500'^^xsd:integer)");
    }

    @Test
    public void cast_to_integer_16() {
        this.testCast("xsd:decimal('1000000000000'^^xsd:integer)", "'1000000000000'^^xsd:decimal");
    }

    @Test
    public void cast_to_integer_17() {
        this.testCast("xsd:int('1000'^^xsd:integer)", "'1000'^^xsd:int");
    }

    @Test
    public void cast_to_integer_18() {
        this.testCast("xsd:integer('1000'^^xsd:int)", "'1000'^^xsd:integer");
    }

    @Test
    public void cast_to_integer_19() {
        this.testNoCast("xsd:negativeInteger('1000'^^xsd:int)");
    }

    @Test
    public void cast_to_integer_20() {
        this.testCast("xsd:integer('+1'^^xsd:decimal)", "'1'^^xsd:integer");
    }

    @Test
    public void cast_to_integer_21() {
        this.testCast("xsd:integer('1.4'^^xsd:decimal)", "'1'^^xsd:integer");
    }

    @Test
    public void cast_to_integer_22() {
        this.testCast("xsd:byte('01.0'^^xsd:decimal)", "'1'^^xsd:byte");
    }

    @Test
    public void cast_to_integer_23() {
        this.testNoCast("xsd:byte('HaHa'^^xsd:decimal)");
    }

    @Test
    public void cast_to_integer_24() {
        this.testCast("xsd:byte('-1'^^xsd:decimal)", "'-1'^^xsd:byte");
    }

    @Test
    public void cast_to_integer_25() {
        this.testNoCast("xsd:unsignedInt('-1'^^xsd:decimal)");
    }

    @Test
    public void cast_to_integer_26() {
        this.testNoCast("xsd:byte('500'^^xsd:decimal)");
    }

    @Test
    public void cast_to_decimal_01() {
        this.testCast("xsd:decimal('1e-20'^^xsd:double)", "0.00000000000000000001");
    }

    @Test
    public void cast_to_decimal_02() {
        this.testCast("xsd:decimal('1e-19'^^xsd:double)", "0.0000000000000000001");
    }

    @Test
    public void cast_to_decimal_03() {
        this.testCast("xsd:decimal('1e-18'^^xsd:double)", "0.000000000000000001");
    }

    @Test
    public void cast_to_decimal_04() {
        this.testCast("xsd:decimal('1e0'^^xsd:double)", "1.0");
    }

    @Test
    public void cast_to_decimal_05() {
        this.testCast("xsd:decimal('11e0'^^xsd:double)", "11.0");
    }

    @Test
    public void cast_to_decimal_06() {
        this.testCast("xsd:decimal('-0.01'^^xsd:double)", "-0.01");
    }

    @Test
    public void cast_to_decimal_07() {
        this.testCast("xsd:decimal('1'^^xsd:double)", "'1.0'^^xsd:decimal");
    }

    @Test
    public void cast_to_boolean_01() {
        this.testCast("xsd:boolean('1'^^xsd:double)", "true");
    }

    @Test
    public void cast_to_boolean_02() {
        this.testCast("xsd:boolean('+1.0e5'^^xsd:double)", "true");
    }

    @Test
    public void cast_to_boolean_03() {
        this.testCast("xsd:boolean('0'^^xsd:float)", "false");
    }

    @Test
    public void cast_to_boolean_04() {
        this.testCast("xsd:boolean(0.0e0)", "false");
    }

    @Test
    public void cast_to_boolean_05() {
        this.testCast("xsd:boolean(-0.0e0)", "false");
    }

    @Test
    public void cast_to_boolean_06() {
        this.testCast("xsd:boolean('NaN'^^xsd:float)", "false");
    }

    @Test
    public void cast_to_boolean_07() {
        this.testCast("xsd:boolean(1.0)", "true");
    }

    @Test
    public void cast_to_boolean_08() {
        this.testCast("xsd:boolean(0.0)", "false");
    }

    @Test
    public void cast_to_boolean_09() {
        this.testCast("xsd:boolean(-1.00)", "true");
    }

    @Test
    public void cast_to_boolean_10() {
        this.testCast("xsd:boolean(0)", "false");
    }

    @Test
    public void cast_to_boolean_11() {
        this.testCast("xsd:boolean('1')", "true");
    }

    @Test
    public void cast_to_boolean_12() {
        this.testCast("xsd:boolean('true')", "true");
    }

    @Test
    public void cast_to_boolean_13() {
        this.testCast("xsd:boolean('0')", "false");
    }

    @Test
    public void cast_to_boolean_14() {
        this.testCast("xsd:boolean('false')", "false");
    }

    @Test
    public void cast_from_string_01() {
        this.testCast("xsd:integer('+1'^^xsd:string)", "'+1'^^xsd:integer");
    }

    @Test
    public void cast_from_string_02() {
        this.testNoCast("xsd:integer('a'^^xsd:string)");
    }

    @Test
    public void cast_from_string_03() {
        this.testCast("xsd:integer('11')", "'11'^^xsd:integer");
    }

    @Test
    public void cast_from_string_04() {
        this.testCast("xsd:double('12'^^xsd:string)", "'12'^^xsd:double");
    }

    @Test
    public void cast_from_string_05() {
        this.testNoCast("xsd:double('abc'^^xsd:string)");
    }

    @Test
    public void cast_from_boolean_01() {
        this.testCast("xsd:boolean('true'^^xsd:boolean)", "'true'^^xsd:boolean");
    }

    @Test
    public void cast_from_boolean_02() {
        this.testCast("xsd:boolean('1'^^xsd:boolean)", "'1'^^xsd:boolean");
    }

    @Test
    public void cast_from_boolean_03() {
        this.testCast("xsd:integer('1'^^xsd:boolean)", "1");
    }

    @Test
    public void cast_from_boolean_04() {
        this.testCast("xsd:decimal('false'^^xsd:boolean)", "0.0");
    }

    @Test
    public void cast_from_boolean_05() {
        this.testCast("xsd:double('false'^^xsd:boolean)", "0.0E0");
    }

    @Test
    public void cast_to_duration_01() {
        this.testCast("xsd:duration('PT10S')", "'PT10S'^^xsd:duration");
    }

    @Test
    public void cast_to_duration_02() {
        this.testCast("xsd:duration('P1DT10S'^^xsd:dayTimeDuration)", "'P1DT10S'^^xsd:duration");
    }

    @Test
    public void cast_to_duration_03() {
        this.testCast("xsd:dayTimeDuration('P1Y2M3DT1H2M3S'^^xsd:duration)", "'P3DT1H2M3S'^^xsd:dayTimeDuration");
    }

    @Test
    public void cast_to_duration_04() {
        this.testCast("xsd:dayTimeDuration('P1Y'^^xsd:duration)", "'PT0S'^^xsd:dayTimeDuration");
    }

    @Test
    public void cast_to_duration_05() {
        this.testCast("xsd:yearMonthDuration('P1Y2M3DT1H2M3S'^^xsd:duration)", "'P1Y2M'^^xsd:yearMonthDuration");
    }

    @Test
    public void cast_to_duration_06() {
        this.testCast("xsd:dayTimeDuration('P1Y2M'^^xsd:yearMonthDuration)", "'PT0S'^^xsd:dayTimeDuration");
    }

    @Test
    public void cast_to_duration_07() {
        this.testCast("xsd:yearMonthDuration('P1DT10H'^^xsd:dayTimeDuration)", "'P0M'^^xsd:yearMonthDuration");
    }

    @Test
    public void cast_to_duration_08() {
        this.testCast("xsd:yearMonthDuration('P1Y2M')", "'P1Y2M'^^xsd:yearMonthDuration");
    }

    @Test
    public void cast_to_duration_09() {
        this.testCast("xsd:dayTimeDuration('P1DT10H')", "'P1DT10H'^^xsd:dayTimeDuration");
    }

    @Test
    public void cast_to_duration_10() {
        this.testCast("xsd:duration('P1Y2M3DT1H2M3S')", "'P1Y2M3DT1H2M3S'^^xsd:duration");
    }

    @Test
    public void cast_to_temporal_01() {
        this.testCast("xsd:date('2015-10-12T15:00:24'^^xsd:dateTime)", "'2015-10-12'^^xsd:date");
    }

    @Test
    public void cast_to_temporal_02() {
        this.testCast("xsd:date('2015-10-12T15:00:24+01:00'^^xsd:dateTime)", "'2015-10-12+01:00'^^xsd:date");
    }

    @Test
    public void cast_to_temporal_03() {
        this.testCast("xsd:dateTime('2015-10-12'^^xsd:date)", "'2015-10-12T00:00:00'^^xsd:dateTime");
    }

    @Test
    public void cast_to_temporal_04() {
        this.testCast("xsd:dateTime('2015-10-12+01:00'^^xsd:date)", "'2015-10-12T00:00:00+01:00'^^xsd:dateTime");
    }

    @Test
    public void cast_to_temporal_05() {
        this.testCast("xsd:time('2015-10-12T15:00:24'^^xsd:dateTime)", "'15:00:24'^^xsd:time");
    }

    @Test
    public void cast_to_temporal_06() {
        this.testCast("xsd:dateTime('2015-10-12T15:00:24Z')", "'2015-10-12T15:00:24Z'^^xsd:dateTime");
    }

    @Test
    public void cast_to_gregorian_01() {
        this.testCast("xsd:gYear('2015-10-12'^^xsd:date)", "'2015'^^xsd:gYear");
    }

    @Test
    public void cast_to_gregorian_02() {
        this.testCast("xsd:gMonth('2015-10-12'^^xsd:date)", "'--10'^^xsd:gMonth");
    }

    @Test
    public void cast_to_gregorian_03() {
        this.testCast("xsd:gMonthDay('2015-10-12'^^xsd:date)", "'--10-12'^^xsd:gMonthDay");
    }

    @Test
    public void cast_to_gregorian_04() {
        this.testCast("xsd:gYearMonth('2015-10-12'^^xsd:date)", "'2015-10'^^xsd:gYearMonth");
    }

    private void testNoCast(String input) {
        try {
            this.cast(input);
            Assert.fail((String)"Expected ExprEvalException");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    private void testCast(String input, String output) {
        NodeValue nv2 = this.cast(input);
        Node expected = SSE.parseNode((String)output);
        Assert.assertEquals((Object)expected, (Object)nv2.asNode());
    }

    private NodeValue cast(String input$) {
        Expr input = ExprUtils.parse((String)input$);
        ARQ.getContext().set(ARQConstants.sysCurrentTime, (Object)NodeFactoryExtra.nowAsDateTime());
        ExecutionContext env = new ExecutionContext(ARQ.getContext(), null, null, null);
        return input.eval(null, (FunctionEnv)env);
    }
}

