/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.LibTestExpr;
import org.junit.Test;

public class TestExpressions4 {
    @Test
    public void idiv_1() {
        LibTestExpr.test("7 idiv 3", "2");
    }

    @Test
    public void idiv_2() {
        LibTestExpr.test("idiv(7, 3)", "2");
    }

    @Test
    public void idiv_3() {
        LibTestExpr.test("fn:numeric-integer-divide(7, 3)", "2");
    }

    @Test
    public void idiv_4() {
        LibTestExpr.test("op:numeric-integer-divide(7, 3)", "2");
    }

    @Test
    public void idiv_5() {
        LibTestExpr.testSSE("(idiv 7 3)", "2");
    }

    @Test
    public void idiv_10() {
        LibTestExpr.test("IDIV(10 , 3)", "3");
    }

    @Test
    public void idiv_11() {
        LibTestExpr.test("IDIV(3 , -2)", "-1");
    }

    @Test
    public void idiv_12() {
        LibTestExpr.test("IDIV(-3 , 2)", "-1");
    }

    @Test
    public void idiv_13() {
        LibTestExpr.test("IDIV(-3 , -2)", "1");
    }

    @Test
    public void idiv_14() {
        LibTestExpr.test("IDIV(9.0 , 3)", "3");
    }

    @Test
    public void idiv_15() {
        LibTestExpr.test("IDIV(-3.5 , 3)", "-1");
    }

    @Test
    public void idiv_16() {
        LibTestExpr.test("IDIV(3.0 , 4)", "0");
    }

    @Test
    public void idiv_17() {
        LibTestExpr.test("IDIV(3.1E1 , 6)", "5");
    }

    @Test
    public void idiv_18() {
        LibTestExpr.test("IDIV(3.1E1 , 7)", "4");
    }

    @Test(expected=ExprEvalException.class)
    public void idiv_20() {
        LibTestExpr.test("IDIV(3 , 0)", "4");
    }

    @Test(expected=ExprEvalException.class)
    public void idiv_21() {
        LibTestExpr.test("IDIV(3.1 , 0.0)", "4");
    }

    @Test(expected=ExprEvalException.class)
    public void idiv_22() {
        LibTestExpr.test("IDIV(3.1E1 , 0e0)", "4");
    }

    @Test
    public void mod_1() {
        LibTestExpr.test("5 mod 3", "2");
    }

    @Test
    public void mod_2() {
        LibTestExpr.test("mod(5, 3)", "2");
    }

    @Test
    public void mod_3() {
        LibTestExpr.test("fn:numeric-mod(5, 3)", "2");
    }

    @Test
    public void mod_4() {
        LibTestExpr.test("op:numeric-mod(5, 3)", "2");
    }

    @Test
    public void mod_5() {
        LibTestExpr.testSSE("(mod 5 3)", "2");
    }

    @Test
    public void mod_10() {
        LibTestExpr.test("MOD(10 , 3)", "1");
    }

    @Test
    public void mod_11() {
        LibTestExpr.test("MOD(6 , -2)", "0");
    }

    @Test
    public void mod_12() {
        LibTestExpr.test("MOD(4.5 , 1.2)", "0.9");
    }

    @Test
    public void mod_13() {
        LibTestExpr.test("MOD(1.23E2 , 0.6E1)", "3.0E0");
    }

    @Test
    public void mod_14() {
        LibTestExpr.test("MOD(7 , -2)", "1");
    }

    @Test
    public void mod_15() {
        LibTestExpr.test("MOD(7.0 , -2.0)", "1.0");
    }

    @Test
    public void mod_16() {
        LibTestExpr.test("MOD(7e0 , -2e0)", "1.0e0");
    }

    @Test
    public void mod_17() {
        LibTestExpr.test("MOD(-7 , -2)", "-1");
    }

    @Test
    public void mod_18() {
        LibTestExpr.test("MOD(-7.0 , -2.0)", "-1.0");
    }

    @Test
    public void mod_19() {
        LibTestExpr.test("MOD(-7e0 , -2e0)", "-1.0e0");
    }

    @Test(expected=ExprEvalException.class)
    public void mod_20() {
        LibTestExpr.test("MOD(123 , 0)", "3");
    }

    @Test(expected=ExprEvalException.class)
    public void mod_21() {
        LibTestExpr.test("MOD(12.3 , 0.0)", "3.0");
    }

    @Test(expected=ExprEvalException.class)
    public void mod_22() {
        LibTestExpr.test("MOD(1.23E2 , 0.0e0)", "3.0E0");
    }
}

