/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.function.Predicate;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.LibTestExpr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.ExprUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestFunctions {
    private static final NodeValue TRUE = NodeValue.TRUE;
    private static final NodeValue FALSE = NodeValue.FALSE;
    static Node xyz_en = NodeFactory.createLiteral((String)"xyz", (String)"en");
    static NodeValue nv_xyz_en = NodeValue.makeNode((Node)xyz_en);
    static Node xyz_xsd_string = NodeFactory.createLiteral((String)"xyz", (RDFDatatype)XSDDatatype.XSDstring);
    static NodeValue nv_xyz_string = NodeValue.makeNode((Node)xyz_xsd_string);
    static Node n_uri = NodeFactory.createURI((String)"http://example/");
    static NodeValue nv_uri = NodeValue.makeNode((Node)n_uri);

    @Test
    public void expr1() {
        this.test("1", NodeValue.makeInteger((long)1L));
    }

    @Test
    public void exprJavaSubstring1() {
        this.test("afn:substr('abc',0,0)", NodeValue.makeString((String)""));
    }

    @Test
    public void exprJavaSubstring2() {
        this.test("afn:substr('abc',0,1)", NodeValue.makeString((String)"a"));
    }

    @Test
    public void exprJavaSubstring3() {
        this.test("<java:org.apache.jena.sparql.function.library.substr>('abc',0,0)", NodeValue.makeString((String)""));
    }

    @Test
    public void exprJavaSubstring4() {
        this.test("<java:org.apache.jena.sparql.function.library.substr>('abc',0,1)", NodeValue.makeString((String)"a"));
    }

    @Test
    public void exprJavaSubstring5() {
        this.test("afn:substr('\ud801\udc08\ud801\udc4c\ud801\udc3b\ud801\udc2a\ud801\udc49\ud801\udc3f\ud801\udc3b\ud801\udc2e\ud801\udc3f\ud801\udc32', 0, 1)", NodeValue.makeString((String)"\ud801\udc08"));
    }

    @Test
    public void exprSprintf_01() {
        this.test("afn:sprintf('%06d', 11)", NodeValue.makeString((String)"000011"));
    }

    @Test
    public void exprSprintf_02() {
        this.test("afn:sprintf('%s', 'abcdefghi')", NodeValue.makeString((String)"abcdefghi"));
    }

    @Test
    public void exprSprintf_03() {
        this.test("afn:sprintf('sometext %s', 'abcdefghi')", NodeValue.makeString((String)"sometext abcdefghi"));
    }

    @Test
    public void exprSprintf_04() {
        this.test("afn:sprintf('%1$tm %1$te,%1$tY', '2016-03-17'^^xsd:date)", NodeValue.makeString((String)"03 17,2016"));
    }

    @Test
    public void exprSprintf_06() {
        this.test("afn:sprintf('this is %s', 'false'^^xsd:boolean)", NodeValue.makeString((String)"this is false"));
    }

    @Test
    public void exprSprintf_07() {
        this.test("afn:sprintf('this number is equal to %.2f', '11.22'^^xsd:decimal)", NodeValue.makeString((String)("this number is equal to " + String.format("%.2f", 11.22))));
    }

    @Test
    public void exprSprintf_08() {
        this.test("afn:sprintf('%.3f', '1.23456789'^^xsd:float)", NodeValue.makeString((String)String.format("%.3f", 1.23456789)));
    }

    @Test
    public void exprSprintf_09() {
        this.test("afn:sprintf('this number is equal to %o in the octal system', '11'^^xsd:integer)", NodeValue.makeString((String)"this number is equal to 13 in the octal system"));
    }

    @Test
    public void exprSprintf_10() {
        this.test("afn:sprintf('this number is equal to %.5f', '1.23456789'^^xsd:double)", NodeValue.makeString((String)("this number is equal to " + String.format("%.5f", 1.23456789))));
    }

    @Test
    public void exprSprintf_11() {
        this.test("afn:sprintf('%.0f != %s', '12.23456789'^^xsd:double,'15')", NodeValue.makeString((String)"12 != 15"));
    }

    @Test
    public void exprSprintf_12() {
        this.test("afn:sprintf('(%.0f,%s,%d) %4$tm %4$te,%4$tY', '12.23456789'^^xsd:double,'12',11,'2016-03-17'^^xsd:date)", NodeValue.makeString((String)"(12,12,11) 03 17,2016"));
    }

    @Test
    public void exprSprintf_20() {
        TestFunctions.test_exprSprintf_tz_exact("2005-10-14T14:09:43-11:00");
    }

    @Test
    public void exprSprintf_21() {
        TestFunctions.test_exprSprintf_tz_exact("2005-10-14T12:09:43+00:00");
    }

    @Test
    public void exprSprintf_22() {
        TestFunctions.test_exprSprintf_tz_exact("2005-10-14T10:09:43+11:00");
    }

    private static void test_exprSprintf_tz_exact(String nodeStr) {
        String exprStr = "afn:sprintf('%1$tm %1$te,%1$tY', " + NodeValue.makeDateTime((String)nodeStr).toString() + ")";
        Expr expr = ExprUtils.parse((String)exprStr);
        NodeValue r = expr.eval(null, LibTestExpr.createTest());
        Assert.assertTrue((boolean)r.isString());
        String s = r.getString();
        String dtFormat = "yyyy-MM-dd'T'HH:mm:ssXXX";
        SimpleDateFormat sdtFormat = new SimpleDateFormat(dtFormat);
        Date dtDate = null;
        try {
            dtDate = sdtFormat.parse(nodeStr);
        }
        catch (ParseException e) {
            Assert.assertFalse((String)("Cannot parse the input date string. Message:" + e.getMessage()), (boolean)false);
        }
        SimpleDateFormat stdFormatOut = new SimpleDateFormat("MM dd,yyyy");
        stdFormatOut.setTimeZone(TimeZone.getDefault());
        String outDate = stdFormatOut.format(dtDate);
        Assert.assertEquals((Object)s, (Object)outDate);
    }

    private static void test_exprSprintf_tz_possibilites(String nodeStr, String ... possible) {
        String exprStr = "afn:sprintf('%1$tm %1$te,%1$tY', " + NodeValue.makeDateTime((String)nodeStr).toString() + ")";
        Expr expr = ExprUtils.parse((String)exprStr);
        NodeValue r = expr.eval(null, LibTestExpr.createTest());
        Assert.assertTrue((boolean)r.isString());
        String s = r.getString();
        boolean b = false;
        for (String poss : possible) {
            if (!poss.equals(s)) continue;
            b = true;
        }
        Assert.assertTrue((boolean)b);
    }

    @Test
    public void exprSprintf_23() {
        TestFunctions.test_exprSprintf_tz_possibilites("2005-10-14T14:09:43-11:00", "10 14,2005", "10 15,2005");
    }

    @Test
    public void exprSprintf_24() {
        TestFunctions.test_exprSprintf_tz_possibilites("2005-10-14T12:09:43Z", "10 13,2005", "10 14,2005", "10 15,2005");
    }

    @Test
    public void exprSprintf_25() {
        TestFunctions.test_exprSprintf_tz_possibilites("2005-10-14T10:09:43+11:00", "10 13,2005", "10 14,2005");
    }

    @Test
    public void exprStrStart10() {
        this.test("STRSTARTS('abc', 'abcd')", FALSE);
    }

    @Test
    public void exprStrStart11() {
        this.test("STRSTARTS('abc'@en, 'ab')", TRUE);
    }

    @Test
    public void exprStrStart12() {
        this.test("STRSTARTS('abc'^^xsd:string, 'ab')", TRUE);
    }

    @Test
    public void exprStrStart13() {
        this.test("STRSTARTS('abc'^^xsd:string, 'ab'^^xsd:string)", TRUE);
    }

    @Test
    public void exprStrStart14() {
        this.test("STRSTARTS('abc', 'ab'^^xsd:string)", TRUE);
    }

    @Test
    public void exprStrStart15() {
        this.test("STRSTARTS('abc'@en, 'ab'@en)", TRUE);
    }

    @Test
    public void exprStrStart16() {
        this.testEvalException("STRSTARTS('ab'@en, 'ab'@fr)");
    }

    @Test
    public void exprStrStart17() {
        this.testEvalException("STRSTARTS(123, 'ab'@fr)");
    }

    @Test
    public void exprStrStart18() {
        this.testEvalException("STRSTARTS('123'^^xsd:string, 12.3)");
    }

    @Test
    public void exprStrBefore0() {
        this.test("STRBEFORE('abc', 'abcd')", NodeValue.nvEmptyString);
    }

    @Test
    public void exprStrBefore1() {
        this.test("STRBEFORE('abc'@en, 'b')", NodeValue.makeNode((String)"a", (String)"en", (String)null));
    }

    @Test
    public void exprStrBefore2() {
        this.test("STRBEFORE('abc'^^xsd:string, 'c')", NodeValue.makeNode((String)"ab", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprStrBefore3() {
        this.test("STRBEFORE('abc'^^xsd:string, ''^^xsd:string)", NodeValue.makeNode((String)"", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprStrBefore4() {
        this.test("STRBEFORE('abc', 'ab'^^xsd:string)", NodeValue.nvEmptyString);
    }

    @Test
    public void exprStrBefore5() {
        this.test("STRBEFORE('abc'@en, 'b'@en)", NodeValue.makeNode((String)"a", (String)"en", (String)null));
    }

    @Test
    public void exprStrBefore6() {
        this.testEvalException("STRBEFORE('ab'@en, 'ab'@fr)");
    }

    @Test
    public void exprStrBefore7() {
        this.testEvalException("STRBEFORE(123, 'ab'@fr)");
    }

    @Test
    public void exprStrBefore8() {
        this.testEvalException("STRBEFORE('123'^^xsd:string, 12.3)");
    }

    @Test
    public void exprStrBefore9() {
        this.test("STRBEFORE('abc'^^xsd:string, 'z')", NodeValue.nvEmptyString);
    }

    @Test
    public void exprStrBefore10() {
        this.test("STRBEFORE('abc'^^xsd:string, '')", NodeValue.makeNode((String)"", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprStrAfter0() {
        this.test("STRAFTER('abc', 'abcd')", NodeValue.nvEmptyString);
    }

    @Test
    public void exprStrAfter1() {
        this.test("STRAFTER('abc'@en, 'b')", NodeValue.makeNode((String)"c", (String)"en", (String)null));
    }

    @Test
    public void exprStrAfter2() {
        this.test("STRAFTER('abc'^^xsd:string, 'a')", NodeValue.makeNode((String)"bc", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprStrAfter3() {
        this.test("STRAFTER('abc'^^xsd:string, ''^^xsd:string)", NodeValue.makeNode((String)"abc", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprStrAfter4() {
        this.test("STRAFTER('abc', 'bc'^^xsd:string)", NodeValue.nvEmptyString);
    }

    @Test
    public void exprStrAfter5() {
        this.test("STRAFTER('abc'@en, 'b'@en)", NodeValue.makeNode((String)"c", (String)"en", (String)null));
    }

    @Test
    public void exprStrAfter6() {
        this.testEvalException("STRAFTER('ab'@en, 'ab'@fr)");
    }

    @Test
    public void exprStrAfter7() {
        this.testEvalException("STRAFTER(123, 'ab'@fr)");
    }

    @Test
    public void exprStrAfter8() {
        this.testEvalException("STRAFTER('123'^^xsd:string, 12.3)");
    }

    @Test
    public void exprStrAfter9() {
        this.test("STRAFTER('abc'^^xsd:string, 'z')", NodeValue.nvEmptyString);
    }

    @Test
    public void exprStrAfter10() {
        this.test("STRAFTER('abc'^^xsd:string, '')", NodeValue.makeNode((String)"abc", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprStrEnds10() {
        this.test("STRENDS('abc', 'abcd')", FALSE);
    }

    @Test
    public void exprStrEnds11() {
        this.test("STRENDS('abc'@en, 'bc')", TRUE);
    }

    @Test
    public void exprStrEnds12() {
        this.test("STRENDS('abc'^^xsd:string, 'c')", TRUE);
    }

    @Test
    public void exprStrEnds13() {
        this.test("STRENDS('abc'^^xsd:string, 'c'^^xsd:string)", TRUE);
    }

    @Test
    public void exprStrEnds14() {
        this.test("STRENDS('abc', 'ab'^^xsd:string)", FALSE);
    }

    @Test
    public void exprStrEnds15() {
        this.test("STRENDS('abc'@en, 'abc'@en)", TRUE);
    }

    @Test
    public void exprStrEnds16() {
        this.testEvalException("STRENDS('ab'@en, 'ab'@fr)");
    }

    @Test
    public void exprStrEnds17() {
        this.testEvalException("STRENDS(123, 'ab'@fr)");
    }

    @Test
    public void exprStrEnds18() {
        this.testEvalException("STRENDS('123'^^xsd:string, 12.3)");
    }

    @Test
    public void exprContains10() {
        this.test("Contains('abc', 'abcd')", FALSE);
    }

    @Test
    public void exprContains11() {
        this.test("Contains('abc'@en, 'bc')", TRUE);
    }

    @Test
    public void exprContains12() {
        this.test("Contains('abc'^^xsd:string, 'c')", TRUE);
    }

    @Test
    public void exprContains13() {
        this.test("Contains('abc'^^xsd:string, 'c'^^xsd:string)", TRUE);
    }

    @Test
    public void exprContains14() {
        this.test("Contains('abc', 'z'^^xsd:string)", FALSE);
    }

    @Test
    public void exprContains15() {
        this.test("Contains('abc'@en, 'abc'@en)", TRUE);
    }

    @Test
    public void exprContains16() {
        this.testEvalException("Contains('ab'@en, 'ab'@fr)");
    }

    @Test
    public void exprContains17() {
        this.testEvalException("Contains(123, 'ab'@fr)");
    }

    @Test
    public void exprContains18() {
        this.testEvalException("STRENDS('123'^^xsd:string, 12.3)");
    }

    @Test
    public void exprReplace01() {
        this.test("REPLACE('abc', 'b', 'Z')", NodeValue.makeString((String)"aZc"));
    }

    @Test
    public void exprReplace02() {
        this.test("REPLACE('abc', 'b.', 'Z')", NodeValue.makeString((String)"aZ"));
    }

    @Test
    public void exprReplace03() {
        this.test("REPLACE('abcbd', 'b.', 'Z')", NodeValue.makeString((String)"aZZ"));
    }

    @Test
    public void exprReplace04() {
        this.test("REPLACE('abcbd'^^xsd:string, 'b.', 'Z')", NodeValue.makeNode((String)"aZZ", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprReplace05() {
        this.test("REPLACE('abcbd'@en, 'b.', 'Z')", NodeValue.makeNode((String)"aZZ", (String)"en", (String)null));
    }

    @Test
    public void exprReplace06() {
        this.test("REPLACE('abcbd', 'B.', 'Z', 'i')", NodeValue.makeString((String)"aZZ"));
    }

    @Test
    public void exprReplace07() {
        this.test("REPLACE('abc', '.*', 'Z')", NodeValue.makeString((String)"Z"));
    }

    @Test
    public void exprReplace08() {
        this.test("REPLACE('', '.*', 'Z')", NodeValue.makeString((String)"Z"));
    }

    @Test
    public void exprReplace09() {
        this.test("REPLACE('abc', '.?', 'Z')", NodeValue.makeString((String)"ZZZ"));
    }

    @Test
    public void exprReplace10() {
        this.test("REPLACE('abc', 'XXX', 'Z')", NodeValue.makeString((String)"abc"));
    }

    @Test
    public void exprReplace11() {
        this.test("REPLACE('', '.', 'Z')", NodeValue.makeString((String)""));
    }

    @Test
    public void exprReplace12() {
        this.test("REPLACE('', '(a|b)?', 'Z')", NodeValue.makeString((String)"Z"));
    }

    @Test
    public void exprReplace13() {
        this.testEvalException("REPLACE('abc', '.*', '$1')");
    }

    @Test(expected=ExprException.class)
    public void exprReplace14() {
        ExprUtils.parse((String)"REPLACE('abc', '^(a){-9}', 'ABC')");
    }

    @Test
    public void localTimezone_2() {
        this.test("afn:timezone()", (NodeValue nv) -> nv.isDayTimeDuration());
    }

    @Test
    public void localDateTime_1() {
        this.test("afn:nowtz()", (NodeValue nv) -> nv.isDateTime());
    }

    @Test
    public void localDateTime_2() {
        this.test("afn:nowtz()", (NodeValue nv) -> nv.getDateTime().getTimezone() >= -840);
    }

    @Test
    public void localDateTime_3() {
        this.test("afn:nowtz() = NOW()", NodeValue.TRUE);
    }

    @Test
    public void exprSameTerm1() {
        this.test("sameTerm(1,1)", TRUE);
    }

    @Test
    public void exprSameTerm2() {
        this.test("sameTerm(1,1.0)", FALSE);
    }

    @Test
    public void exprSameTerm3() {
        this.test("sameTerm(1,1e0)", FALSE);
    }

    @Test
    public void exprSameTerm4() {
        this.test("sameTerm(<_:a>, <_:a>)", TRUE);
    }

    @Test
    public void exprSameTerm5() {
        this.test("sameTerm(<x>, <x>)", TRUE);
    }

    @Test
    public void exprSameTerm6() {
        this.test("sameTerm(<x>, <y>)", FALSE);
    }

    @Test
    public void exprOneOf_01() {
        this.test("57 in (xsd:integer, '123')", FALSE);
    }

    @Test
    public void exprOneOf_02() {
        this.test("57 in (57)", TRUE);
    }

    @Test
    public void exprOneOf_03() {
        this.test("57 in (123, 57)", TRUE);
    }

    @Test
    public void exprOneOf_04() {
        this.test("57 in (57, 456)", TRUE);
    }

    @Test
    public void exprOneOf_05() {
        this.test("57 in (123, 57, 456)", TRUE);
    }

    @Test
    public void exprOneOf_06() {
        this.test("57 in (1,2,3)", FALSE);
    }

    @Test
    public void exprNotOneOf_01() {
        this.test("57 not in (xsd:integer, '123')", TRUE);
    }

    @Test
    public void exprNotOneOf_02() {
        this.test("57 not in (57)", FALSE);
    }

    @Test
    public void exprNotOneOf_03() {
        this.test("57 not in (123, 57)", FALSE);
    }

    @Test
    public void exprNotOneOf_04() {
        this.test("57 not in (57, 456)", FALSE);
    }

    @Test
    public void exprNotOneOf_05() {
        this.test("57 not in (123, 57, 456)", FALSE);
    }

    @Test
    public void exprNotOneOf_06() {
        this.test("57 not in (1,2,3)", TRUE);
    }

    @Test
    public void exprStrLang1() {
        this.test("strlang('xyz', 'en')", nv_xyz_en);
    }

    @Test(expected=ExprEvalException.class)
    public void exprStrLang2() {
        this.test("strlang('xyz', '')", (NodeValue x) -> false);
    }

    @Test
    public void exprStrDatatype1() {
        this.test("strdt('123', xsd:integer)", NodeValue.makeInteger((long)123L));
    }

    @Test
    public void exprStrDatatype2() {
        this.test("strdt('xyz', xsd:string)", nv_xyz_string);
    }

    @Test
    public void exprStrDatatype3() {
        this.testEvalException("strdt('123',       'datatype')");
    }

    private void test(String exprStr, NodeValue result) {
        Expr expr = ExprUtils.parse((String)exprStr);
        NodeValue r = expr.eval(null, LibTestExpr.createTest());
        Assert.assertEquals((Object)result, (Object)r);
    }

    private void test(String exprStr, Predicate<NodeValue> test) {
        Expr expr = ExprUtils.parse((String)exprStr);
        NodeValue r = expr.eval(null, LibTestExpr.createTest());
        Assert.assertTrue((String)exprStr, (boolean)test.test(r));
    }

    private void testEqual(String exprStr, String exprStrExpected) {
        Expr expr = ExprUtils.parse((String)exprStrExpected);
        NodeValue rExpected = expr.eval(null, LibTestExpr.createTest());
        this.test(exprStr, rExpected);
    }

    private void testEvalException(String exprStr) {
        Expr expr = ExprUtils.parse((String)exprStr);
        try {
            NodeValue r = expr.eval(null, LibTestExpr.createTest());
            Assert.fail((String)"No exception raised");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }
}

