/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.math.BigDecimal;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprEvalTypeException;
import org.apache.jena.sparql.expr.ExprNotComparableException;
import org.apache.jena.sparql.expr.LibTestExpr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDecimal;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDouble;
import org.apache.jena.sparql.expr.nodevalue.NodeValueFloat;
import org.apache.jena.sparql.expr.nodevalue.NodeValueInteger;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.Symbol;
import org.junit.Assert;
import org.junit.Test;

public class TestXSDFuncOp {
    private static final double accuracyExact_D = 0.0;
    private static final double accuracyExact_F = 0.0;
    private static final double accuracyClose_D = 1.0E-6;
    private static final double accuracyClose_F = (double)1.0E-6f;
    private static NodeValue nv_dt = NodeValue.makeNode((String)"2010-03-22T20:31:54.5", (RDFDatatype)XSDDatatype.XSDdateTime);
    private static NodeValue nv_d = NodeValue.makeNode((String)"2010-03-22", (RDFDatatype)XSDDatatype.XSDdate);
    private static NodeValue nv_gy = NodeValue.makeNode((String)"2010", (RDFDatatype)XSDDatatype.XSDgYear);
    private static NodeValue nv_gym = NodeValue.makeNode((String)"2010-03", (RDFDatatype)XSDDatatype.XSDgYearMonth);
    private static NodeValue nv_gmd = NodeValue.makeNode((String)"--03-22", (RDFDatatype)XSDDatatype.XSDgMonthDay);
    private static NodeValue nv_gm = NodeValue.makeNode((String)"--03", (RDFDatatype)XSDDatatype.XSDgMonth);
    private static NodeValue nv_gd = NodeValue.makeNode((String)"---22", (RDFDatatype)XSDDatatype.XSDgDay);
    private static NodeValue nv_t = NodeValue.makeNode((String)"20:31:54.5", (RDFDatatype)XSDDatatype.XSDtime);
    private static NodeValue nv_dt_tz1 = NodeValue.makeNode((String)"2010-03-22T20:31:54.5+01:00", (RDFDatatype)XSDDatatype.XSDdateTime);
    private static NodeValue nv_dt_tz2 = NodeValue.makeNode((String)"2010-03-22T20:31:54.5-05:00", (RDFDatatype)XSDDatatype.XSDdateTime);
    private static NodeValue nv_dt_tz3 = NodeValue.makeNode((String)"2010-03-22T20:31:54.5Z", (RDFDatatype)XSDDatatype.XSDdateTime);
    private static NodeValue nv_d_tz1 = NodeValue.makeNode((String)"2010-03-22+01:00", (RDFDatatype)XSDDatatype.XSDdate);
    private static NodeValue nv_d_tz2 = NodeValue.makeNode((String)"2010-03-22-05:00", (RDFDatatype)XSDDatatype.XSDdate);
    private static NodeValue nv_d_tz3 = NodeValue.makeNode((String)"2010-03-22Z", (RDFDatatype)XSDDatatype.XSDdate);
    private static NodeValue nv_t_tz1 = NodeValue.makeNode((String)"20:31:54.5+01:00", (RDFDatatype)XSDDatatype.XSDtime);
    private static NodeValue nv_t_tz2 = NodeValue.makeNode((String)"20:31:54.5-05:00", (RDFDatatype)XSDDatatype.XSDtime);
    private static NodeValue nv_t_tz3 = NodeValue.makeNode((String)"20:31:54.5Z", (RDFDatatype)XSDDatatype.XSDtime);

    @Test
    public void lex_decimal_1() {
        TestXSDFuncOp.lex_decimal_value(BigDecimal.valueOf(0L), "0.0");
    }

    @Test
    public void lex_decimal_2() {
        TestXSDFuncOp.lex_decimal_value(BigDecimal.valueOf(1L), "1.0");
    }

    @Test
    public void lex_decimal_3() {
        TestXSDFuncOp.lex_decimal_value(BigDecimal.valueOf(0.5), "0.5");
    }

    @Test
    public void lex_decimal_4() {
        TestXSDFuncOp.lex_decimal_value(BigDecimal.valueOf(-0.5), "-0.5");
    }

    @Test
    public void lex_decimal_5() {
        TestXSDFuncOp.lex_decimal_value(BigDecimal.valueOf(1000000000000000L), "1000000000000000.0");
    }

    @Test
    public void lex_decimal_6() {
        TestXSDFuncOp.lex_decimal_value(BigDecimal.valueOf(-1000000000000000L), "-1000000000000000.0");
    }

    @Test
    public void lex_decimal_canonical_1() {
        TestXSDFuncOp.lex_decimal_canonical("+.0", "0.0");
    }

    @Test
    public void lex_decimal_canonical_2() {
        TestXSDFuncOp.lex_decimal_canonical("-.0", "0.0");
    }

    @Test
    public void lex_decimal_canonical_3() {
        TestXSDFuncOp.lex_decimal_canonical("0010", "10.0");
    }

    @Test
    public void lex_decimal_canonical_4() {
        TestXSDFuncOp.lex_decimal_canonical("0012.0000", "12.0");
    }

    @Test
    public void lex_decimal_canonical_5() {
        TestXSDFuncOp.lex_decimal_canonical("-0012.0000", "-12.0");
    }

    @Test
    public void lex_decimal_nodevalue_1() {
        TestXSDFuncOp.lex_decimal_nodevalue("0.0", "0.0");
    }

    @Test
    public void lex_decimal_nodevalue_2() {
        TestXSDFuncOp.lex_decimal_nodevalue("0.", "0.");
    }

    @Test
    public void lex_decimal_nodevalue3() {
        TestXSDFuncOp.lex_decimal_nodevalue("+.0", "+.0");
    }

    private static void lex_decimal_value(BigDecimal decimal, String expected) {
        String lex = XSDFuncOp.canonicalDecimalStr((BigDecimal)decimal);
        Assert.assertEquals((Object)expected, (Object)lex);
    }

    private static void lex_decimal_nodevalue(String input, String expected) {
        NodeValue nv = NodeValue.makeDecimal((String)input);
        String lex = nv.asString();
        Assert.assertEquals((Object)expected, (Object)lex);
    }

    private static void lex_decimal_canonical(String input, String expected) {
        BigDecimal decimal = new BigDecimal(input);
        String lex = XSDFuncOp.canonicalDecimalStr((BigDecimal)decimal);
        Assert.assertEquals((Object)expected, (Object)lex);
    }

    @Test
    public void testAddIntegerInteger() {
        NodeValue nv1 = NodeValue.makeInteger((long)5L);
        NodeValue nv2 = NodeValue.makeInteger((long)7L);
        NodeValue r = XSDFuncOp.numAdd((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not an integer: " + r), (boolean)r.isInteger());
        Assert.assertTrue((String)("Not a NodeValueInteger: " + r), (boolean)(r instanceof NodeValueInteger));
        Assert.assertEquals((String)"Wrong result", (long)12L, (long)r.getInteger().longValue());
    }

    @Test
    public void testAddDecimalDecimal() {
        NodeValue nv1 = NodeValue.makeDecimal((double)4.3);
        NodeValue nv2 = NodeValue.makeDecimal((double)3.7);
        NodeValue r = XSDFuncOp.numAdd((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        Assert.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        Assert.assertEquals((String)"Wrong result", (double)8.0, (double)r.getDecimal().doubleValue(), (double)0.0);
    }

    @Test
    public void testAddFloatFloat() {
        NodeValue nv1 = NodeValue.makeFloat((float)7.5f);
        NodeValue nv2 = NodeValue.makeFloat((float)2.5f);
        NodeValue r = XSDFuncOp.numAdd((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a float: " + r), (boolean)r.isDouble());
        Assert.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        Assert.assertEquals((String)"Wrong result", (double)10.0, (double)r.getFloat(), (double)0.0);
        Assert.assertEquals((String)"Wrong result (as doubles)", (double)10.0, (double)r.getDouble(), (double)0.0);
    }

    @Test
    public void testAddDoubleDouble() {
        NodeValue nv1 = NodeValue.makeDouble((double)7.5);
        NodeValue nv2 = NodeValue.makeDouble((double)2.5);
        NodeValue r = XSDFuncOp.numAdd((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        Assert.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        Assert.assertEquals((String)"Wrong result", (double)10.0, (double)r.getDouble(), (double)0.0);
    }

    @Test
    public void testAddIntegerDecimal() {
        NodeValue nv1 = NodeValue.makeInteger((long)5L);
        NodeValue nv2 = NodeValue.makeDecimal((long)7L);
        NodeValue r = XSDFuncOp.numAdd((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        Assert.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        Assert.assertEquals((String)"Wrong result", (long)12L, (long)r.getDecimal().longValue());
    }

    @Test
    public void testAddDecimalInteger() {
        NodeValue nv1 = NodeValue.makeDecimal((long)7L);
        NodeValue nv2 = NodeValue.makeInteger((long)5L);
        NodeValue r = XSDFuncOp.numAdd((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        Assert.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        Assert.assertEquals((String)"Wrong result", (long)12L, (long)r.getDecimal().longValue());
    }

    @Test
    public void testAddIntegerFloat() {
        NodeValue nv1 = NodeValue.makeInteger((long)5L);
        NodeValue nv2 = NodeValue.makeFloat((float)7.0f);
        NodeValue r = XSDFuncOp.numAdd((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a float: " + r), (boolean)r.isFloat());
        Assert.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        Assert.assertEquals((String)"Wrong result", (double)12.0, (double)r.getDouble(), (double)0.0);
    }

    @Test
    public void testAddFloatInteger() {
        NodeValue nv1 = NodeValue.makeFloat((float)7.0f);
        NodeValue nv2 = NodeValue.makeInteger((long)5L);
        NodeValue r = XSDFuncOp.numAdd((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a float: " + r), (boolean)r.isFloat());
        Assert.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        Assert.assertEquals((String)"Wrong result", (double)12.0, (double)r.getDouble(), (double)0.0);
    }

    @Test
    public void testAddIntegerDouble() {
        NodeValue nv1 = NodeValue.makeInteger((long)5L);
        NodeValue nv2 = NodeValue.makeDouble((double)7.0);
        NodeValue r = XSDFuncOp.numAdd((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        Assert.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        Assert.assertEquals((String)"Wrong result", (double)12.0, (double)r.getDouble(), (double)0.0);
    }

    @Test
    public void testAddDoubleInteger() {
        NodeValue nv1 = NodeValue.makeDouble((double)7.0);
        NodeValue nv2 = NodeValue.makeInteger((long)5L);
        NodeValue r = XSDFuncOp.numAdd((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        Assert.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        Assert.assertEquals((String)"Wrong result", (double)12.0, (double)r.getDouble(), (double)0.0);
    }

    @Test
    public void testAddDecimalFloat() {
        NodeValue nv1 = NodeValue.makeDecimal((double)3.5);
        NodeValue nv2 = NodeValue.makeFloat((float)4.5f);
        NodeValue r = XSDFuncOp.numAdd((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a Float: " + r), (boolean)r.isFloat());
        Assert.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        Assert.assertEquals((String)"Wrong result", (double)8.0, (double)r.getFloat(), (double)0.0);
    }

    @Test
    public void testAddFloatDecimal() {
        NodeValue nv1 = NodeValue.makeFloat((float)4.5f);
        NodeValue nv2 = NodeValue.makeDecimal((double)3.5);
        NodeValue r = XSDFuncOp.numAdd((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a Float: " + r), (boolean)r.isFloat());
        Assert.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        Assert.assertEquals((String)"Wrong result", (double)8.0, (double)r.getFloat(), (double)0.0);
    }

    @Test
    public void testAddDecimalDouble() {
        NodeValue nv1 = NodeValue.makeDecimal((double)3.5);
        NodeValue nv2 = NodeValue.makeDouble((double)4.5);
        NodeValue r = XSDFuncOp.numAdd((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        Assert.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        Assert.assertEquals((String)"Wrong result", (double)8.0, (double)r.getDouble(), (double)0.0);
    }

    @Test
    public void testAddDoubleDecimal() {
        NodeValue nv1 = NodeValue.makeDouble((double)4.5);
        NodeValue nv2 = NodeValue.makeDecimal((double)3.5);
        NodeValue r = XSDFuncOp.numAdd((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        Assert.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        Assert.assertEquals((String)"Wrong result", (double)8.0, (double)r.getDouble(), (double)0.0);
    }

    @Test
    public void testAddDoubleFloat() {
        NodeValue nv1 = NodeValue.makeDouble((double)4.5);
        NodeValue nv2 = NodeValue.makeFloat((float)3.5f);
        NodeValue r = XSDFuncOp.numAdd((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        Assert.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        Assert.assertEquals((String)"Wrong result", (double)8.0, (double)r.getDouble(), (double)0.0);
    }

    @Test
    public void testAddFloatDouble() {
        NodeValue nv1 = NodeValue.makeFloat((float)4.5f);
        NodeValue nv2 = NodeValue.makeDouble((double)3.5);
        NodeValue r = XSDFuncOp.numAdd((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        Assert.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        Assert.assertEquals((String)"Wrong result", (double)8.0, (double)r.getDouble(), (double)0.0);
    }

    @Test
    public void testDivideIntegerInteger() {
        NodeValue nv1 = NodeValue.makeInteger((long)25L);
        NodeValue nv2 = NodeValue.makeInteger((long)2L);
        NodeValue r = XSDFuncOp.numDivide((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        Assert.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        Assert.assertEquals((String)"Wrong result", (double)12.5, (double)r.getDecimal().doubleValue(), (double)0.0);
    }

    private static String divideDecimal(String v1, String v2, String v3) {
        NodeValue nv1 = NodeValue.makeDecimal((String)v1);
        NodeValue nv2 = NodeValue.makeDecimal((String)v2);
        NodeValue nv3 = NodeValue.makeDecimal((String)v3);
        NodeValue r = XSDFuncOp.numDivide((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        Assert.assertTrue((String)("Wrong result : expected=" + r + " : got=" + nv3), (boolean)NodeValue.sameAs((NodeValue)r, (NodeValue)nv3));
        return r.asNode().getLiteralLexicalForm();
    }

    @Test
    public void testDivideDecimal1() {
        TestXSDFuncOp.divideDecimal("1", "10", "0.1");
    }

    @Test
    public void testDivideDecimal2() {
        TestXSDFuncOp.divideDecimal("1", "2", "0.5");
    }

    @Test
    public void testDivideDecimal3() {
        String x = TestXSDFuncOp.divideDecimal("1", "3", "0.333333333333333333333333");
        Assert.assertEquals((String)"Wrong lexical form length", (long)26L, (long)x.length());
    }

    @Test
    public void testDivideDecimal4() {
        String x = TestXSDFuncOp.divideDecimal("0", "3", "0");
        Assert.assertEquals((String)"Wrong lexical form", (Object)"0.0", (Object)x);
    }

    @Test
    public void testDivideDecimal5() {
        String x = TestXSDFuncOp.divideDecimal("1", "10000000000000000000000000", "0.0000000000000000000000001");
        Assert.assertEquals((String)"Wrong length lexical form", (long)27L, (long)x.length());
    }

    @Test
    public void testDivideDecimal6() {
        String x = TestXSDFuncOp.divideDecimal("1", "10000000000000000000000000000", "0.0000000000000000000000000001");
        Assert.assertEquals((String)"Wrong length lexical form", (long)30L, (long)x.length());
    }

    @Test(expected=ExprEvalException.class)
    public void testDivideByZero1() {
        NodeValue nv1 = NodeValue.makeInteger((long)1L);
        NodeValue nv2 = NodeValue.makeInteger((long)0L);
        NodeValue r = XSDFuncOp.numDivide((NodeValue)nv1, (NodeValue)nv2);
    }

    @Test
    public void testDivideByZero2() {
        NodeValue nv1 = NodeValue.makeInteger((long)1L);
        NodeValue nv2 = NodeValue.makeDouble((double)0.0);
        NodeValue r = XSDFuncOp.numDivide((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        Assert.assertTrue((String)("Not a +INF: " + r), (r.getDouble() == Double.POSITIVE_INFINITY ? 1 : 0) != 0);
    }

    @Test
    public void testDivideByZero4() {
        NodeValue nv1 = NodeValue.makeInteger((long)-1L);
        NodeValue nv2 = NodeValue.makeDouble((double)0.0);
        NodeValue r = XSDFuncOp.numDivide((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        Assert.assertTrue((String)("Not a -INF: " + r), (r.getDouble() == Double.NEGATIVE_INFINITY ? 1 : 0) != 0);
    }

    @Test(expected=ExprEvalException.class)
    public void testDivideByZero5() {
        NodeValue nv1 = NodeValue.makeInteger((long)1L);
        NodeValue nv2 = NodeValue.makeDecimal((long)0L);
        NodeValue r = XSDFuncOp.numDivide((NodeValue)nv1, (NodeValue)nv2);
    }

    @Test(expected=ExprEvalException.class)
    public void testDivideByZero6() {
        NodeValue nv1 = NodeValue.makeDecimal((long)1L);
        NodeValue nv2 = NodeValue.makeDecimal((long)0L);
        NodeValue r = XSDFuncOp.numDivide((NodeValue)nv1, (NodeValue)nv2);
    }

    @Test
    public void testSubtractDoubleDecimal() {
        NodeValue nv1 = NodeValue.makeDouble((double)4.5);
        NodeValue nv2 = NodeValue.makeDecimal((double)3.5);
        NodeValue r = XSDFuncOp.numSubtract((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        Assert.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        Assert.assertEquals((String)"Wrong result", (double)1.0, (double)r.getDouble(), (double)0.0);
    }

    @Test
    public void testSubtractDecimalInteger() {
        NodeValue nv1 = NodeValue.makeDecimal((double)3.5);
        NodeValue nv2 = NodeValue.makeInteger((long)2L);
        NodeValue r = XSDFuncOp.numSubtract((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        Assert.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        Assert.assertTrue((String)"Wrong result", (boolean)NodeValue.sameAs((NodeValue)NodeValue.makeDecimal((double)1.5), (NodeValue)r));
    }

    @Test
    public void testMultiplyDoubleDecimal() {
        NodeValue nv1 = NodeValue.makeDouble((double)4.5);
        NodeValue nv2 = NodeValue.makeDecimal((double)3.5);
        NodeValue r = XSDFuncOp.numMultiply((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        Assert.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        Assert.assertEquals((String)"Wrong result", (double)15.75, (double)r.getDouble(), (double)0.0);
    }

    @Test
    public void testMultiplyDecimalInteger() {
        NodeValue nv1 = NodeValue.makeDecimal((double)3.5);
        NodeValue nv2 = NodeValue.makeInteger((long)2L);
        NodeValue r = XSDFuncOp.numMultiply((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        Assert.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        Assert.assertEquals((String)"Wrong result", (long)7L, (long)r.getDecimal().longValue());
    }

    @Test
    public void testCompare1() {
        NodeValue nv5 = NodeValue.makeInteger((long)5L);
        NodeValue nv7 = NodeValue.makeInteger((long)7L);
        Assert.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (long)-1L, (long)NodeValue.compare((NodeValue)nv5, (NodeValue)nv7));
        NodeValue nv5b = NodeValue.makeInteger((long)5L);
        Assert.assertEquals((String)("Does not compare " + nv5 + " & " + nv5b), (long)0L, (long)NodeValue.compare((NodeValue)nv5, (NodeValue)nv5b));
    }

    @Test
    public void testCompare2() {
        NodeValue nv5 = NodeValue.makeInteger((long)5L);
        NodeValue nv7 = NodeValue.makeNodeInteger((long)7L);
        Assert.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (long)-1L, (long)NodeValue.compare((NodeValue)nv5, (NodeValue)nv7));
        NodeValue nv5b = NodeValue.makeNodeInteger((long)5L);
        Assert.assertEquals((String)("Does not compare " + nv5 + " & " + nv5b), (long)0L, (long)NodeValue.compare((NodeValue)nv5, (NodeValue)nv5b));
    }

    @Test
    public void testCompare3() {
        NodeValue nv5 = NodeValue.makeInteger((long)5L);
        NodeValue nv7 = NodeValue.makeDouble((double)7.0);
        Assert.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (long)-1L, (long)NodeValue.compare((NodeValue)nv5, (NodeValue)nv7));
    }

    @Test
    public void testCompare4() {
        NodeValue nv5 = NodeValue.makeInteger((long)5L);
        NodeValue nv7 = NodeValue.makeFloat((float)7.0f);
        Assert.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (long)-1L, (long)NodeValue.compare((NodeValue)nv5, (NodeValue)nv7));
    }

    @Test
    public void testCompare5() {
        NodeValue nv5 = NodeValue.makeInteger((long)5L);
        NodeValue nv7 = NodeValue.makeDecimal((long)7L);
        Assert.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (long)-1L, (long)NodeValue.compare((NodeValue)nv5, (NodeValue)nv7));
    }

    @Test
    public void testCompare10() {
        NodeValue nv1 = NodeValue.makeDateTime((String)"2005-10-14T13:09:43Z");
        NodeValue nv2 = NodeValue.makeNodeDateTime((String)"2005-10-14T14:09:43Z");
        Assert.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (long)-1L, (long)NodeValue.compare((NodeValue)nv1, (NodeValue)nv2));
    }

    @Test
    public void testCompare11() {
        NodeValue nv1 = NodeValue.makeDateTime((String)"2005-10-14T13:09:43-08:00");
        NodeValue nv2 = NodeValue.makeNodeDateTime((String)"2005-10-14T13:09:43+01:00");
        Assert.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (long)1L, (long)NodeValue.compare((NodeValue)nv1, (NodeValue)nv2));
    }

    @Test
    public void testCompare12() {
        if (!ARQ.isTrue((Symbol)ARQ.strictSPARQL)) {
            NodeValue nv1 = NodeValue.makeDate((String)"2006-07-21-08:00");
            NodeValue nv2 = NodeValue.makeNodeDate((String)"2006-07-21+01:00");
            Assert.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (long)1L, (long)NodeValue.compare((NodeValue)nv1, (NodeValue)nv2));
        }
    }

    @Test
    public void testCompare15() {
        NodeValue nv1 = NodeValue.makeDate((String)"2005-10-14Z");
        NodeValue nv2 = NodeValue.makeNodeDateTime((String)"2005-10-14T14:09:43Z");
        try {
            NodeValue.compare((NodeValue)nv1, (NodeValue)nv2);
            Assert.assertFalse((String)("Compared the uncomparable: " + nv1 + " & " + nv2), (boolean)true);
        }
        catch (ExprNotComparableException exprNotComparableException) {
            // empty catch block
        }
    }

    @Test
    public void testCompare16() {
        NodeValue nv1 = NodeValue.makeDateTime((String)"2007-08-31T16:20:03");
        NodeValue nv2 = NodeValue.makeDateTime((String)"2007-08-31T16:20:03Z");
        try {
            NodeValue.compare((NodeValue)nv1, (NodeValue)nv2);
            Assert.assertFalse((String)("Compared the uncomparable: " + nv1 + " & " + nv2), (boolean)true);
        }
        catch (ExprNotComparableException exprNotComparableException) {
            // empty catch block
        }
    }

    @Test
    public void testCompare17() {
        NodeValue nv1 = NodeValue.makeDate((String)"2007-08-31");
        NodeValue nv2 = NodeValue.makeDate((String)"2007-08-31Z");
        try {
            NodeValue.compare((NodeValue)nv1, (NodeValue)nv2);
            Assert.assertFalse((String)("Compared the uncomparable: " + nv1 + " & " + nv2), (boolean)true);
        }
        catch (ExprNotComparableException exprNotComparableException) {
            // empty catch block
        }
    }

    @Test
    public void testCompare18() {
        NodeValue nv1 = NodeValue.makeDateTime((String)"2007-08-31T16:20:03");
        NodeValue nv2 = NodeValue.makeDateTime((String)"2007-08-31T01:20:03Z");
        Assert.assertEquals((long)1L, (long)NodeValue.compare((NodeValue)nv1, (NodeValue)nv2));
    }

    @Test
    public void testCompare20() {
        NodeValue nv1 = NodeValue.makeString((String)"abcd");
        NodeValue nv2 = NodeValue.makeNodeString((String)"abc");
        Assert.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (long)1L, (long)NodeValue.compare((NodeValue)nv1, (NodeValue)nv2));
    }

    @Test
    public void testCompare21() {
        NodeValue nv5 = NodeValue.makeInteger((long)5L);
        NodeValue nv7 = NodeValue.makeString((String)"5");
        try {
            NodeValue.compare((NodeValue)nv5, (NodeValue)nv7);
            Assert.fail((String)("Should not compare (but did) " + nv5 + " & " + nv7));
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
        int x = NodeValue.compareAlways((NodeValue)nv5, (NodeValue)nv7);
        Assert.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (long)1L, (long)NodeValue.compareAlways((NodeValue)nv5, (NodeValue)nv7));
    }

    @Test
    public void testCompare22() {
        NodeValue nv1 = NodeValue.makeNodeString((String)"aaa");
        NodeValue nv2 = NodeValue.makeString((String)"aaabbb");
        int x = NodeValue.compare((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertEquals((String)"Not CMP_LESS", (long)x, (long)-1L);
        Assert.assertTrue((String)"It's CMP_GREATER", (x != 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"It's CMP_EQUAL", (x != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompare23() {
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createBlankNode());
        NodeValue nv2 = NodeValue.makeString((String)"5");
        try {
            NodeValue.compare((NodeValue)nv1, (NodeValue)nv2);
            Assert.fail((String)("Should not compare (but did) " + nv1 + " & " + nv2));
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    @Test
    public void testSameUnknown_1() {
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createURI((String)"test:abc"));
        NodeValue nv2 = NodeValue.makeNode((Node)NodeFactory.createURI((String)"test:abc"));
        Assert.assertTrue((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        Assert.assertFalse((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        try {
            NodeValue.compare((NodeValue)nv1, (NodeValue)nv2);
            Assert.fail((String)("Should not compare (but did) " + nv1 + " & " + nv2));
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    @Test
    public void testSameUnknown_2() {
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createBlankNode());
        NodeValue nv2 = NodeValue.makeNode((Node)NodeFactory.createURI((String)"test:abc"));
        Assert.assertFalse((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        Assert.assertTrue((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        try {
            NodeValue.compare((NodeValue)nv1, (NodeValue)nv2);
            Assert.fail((String)("Should not compare (but did) " + nv1 + " & " + nv2));
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    @Test
    public void testSameDateTime_1() {
        NodeValue nv1 = NodeValue.makeDateTime((String)"2007-09-04T09:22:03");
        NodeValue nv2 = NodeValue.makeDateTime((String)"2007-09-04T09:22:03");
        Assert.assertTrue((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        Assert.assertFalse((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
    }

    @Test
    public void testSameDateTime_2() {
        NodeValue nv1 = NodeValue.makeDateTime((String)"2007-09-04T09:22:03");
        NodeValue nv2 = NodeValue.makeDateTime((String)"2007-09-04T19:00:00");
        Assert.assertFalse((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        Assert.assertTrue((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
    }

    @Test
    public void testSameDateTime_3() {
        NodeValue nv1 = NodeValue.makeDateTime((String)"2007-09-04T10:22:03+01:00");
        NodeValue nv2 = NodeValue.makeDateTime((String)"2007-09-04T09:22:03Z");
        Assert.assertTrue((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        Assert.assertFalse((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
    }

    @Test
    public void testSameDateTime_4() {
        NodeValue nv1 = NodeValue.makeDateTime((String)"2007-09-04T10:22:03+01:00");
        NodeValue nv2 = NodeValue.makeDateTime((String)"2007-09-04T10:22:03Z");
        Assert.assertFalse((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        Assert.assertTrue((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
    }

    @Test
    public void testSameDateTime_5() {
        NodeValue nv1 = NodeValue.makeDateTime((String)"2007-09-04T10:22:03+01:00");
        NodeValue nv2 = NodeValue.makeDateTime((String)"2007-09-04T09:22:03");
        try {
            NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2);
            Assert.fail((String)("Should not sameValueAs (but did) " + nv1 + " & " + nv2));
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
        try {
            NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2);
            Assert.fail((String)("Should not notSameValueAs (but did) " + nv1 + " & " + nv2));
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    @Test
    public void testSameDate_1() {
        NodeValue nv1 = NodeValue.makeDate((String)"2007-09-04");
        NodeValue nv2 = NodeValue.makeDate((String)"2007-09-04");
        Assert.assertTrue((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        Assert.assertFalse((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
    }

    @Test
    public void testSameDate_2() {
        NodeValue nv1 = NodeValue.makeDate((String)"2007-09-04Z");
        NodeValue nv2 = NodeValue.makeDate((String)"2007-09-04+00:00");
        Assert.assertTrue((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        Assert.assertFalse((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
    }

    @Test
    public void testSameDate_3() {
        NodeValue nv1 = NodeValue.makeDate((String)"2007-09-04Z");
        NodeValue nv2 = NodeValue.makeDate((String)"2007-09-04");
        try {
            NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2);
            Assert.fail((String)("Should not sameValueAs (but did) " + nv1 + " & " + nv2));
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
        try {
            NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2);
            Assert.fail((String)("Should not notSameValueAs (but did) " + nv1 + " & " + nv2));
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    @Test
    public void testCompareGeneral1() {
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createBlankNode());
        NodeValue nv2 = NodeValue.makeString((String)"5");
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (long)-1L, (long)NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2));
    }

    @Test
    public void testCompareGeneral2() {
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createBlankNode());
        NodeValue nv2 = NodeValue.makeNode((Node)NodeFactory.createURI((String)"test:abc"));
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (long)-1L, (long)NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2));
    }

    @Test
    public void testCompareGeneral3() {
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"test:abc"));
        NodeValue nv2 = NodeValue.makeNode((Node)NodeFactory.createURI((String)"test:abc"));
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (long)1L, (long)NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2));
    }

    @Test
    public void testCompareGeneral4() {
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createURI((String)"test:abc"));
        NodeValue nv2 = NodeValue.makeNode((Node)NodeFactory.createURI((String)"test:xyz"));
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (long)-1L, (long)NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2));
    }

    @Test
    public void testCompareDuration_01() {
        TestXSDFuncOp.testCompare("'P365D'^^xsd:duration", "'P300D'^^xsd:duration", 1);
    }

    @Test(expected=ExprNotComparableException.class)
    public void testCompareDuration_02() {
        TestXSDFuncOp.testCompare("'P365D'^^xsd:duration", "'P1Y'^^xsd:duration", 2);
    }

    @Test(expected=ExprNotComparableException.class)
    public void testCompareDuration_03() {
        TestXSDFuncOp.testCompare("'P365D'^^xsd:dayTimeDuration", "'P1Y'^^xsd:yearMonthDuration", 2);
    }

    @Test(expected=ExprNotComparableException.class)
    public void testCompareDuration_04() {
        TestXSDFuncOp.testCompare("'P1M'^^xsd:duration", "'P28D'^^xsd:duration", 2);
    }

    @Test(expected=ExprNotComparableException.class)
    public void testCompareDuration_05() {
        TestXSDFuncOp.testCompare("'P1M'^^xsd:yearMonthDuration", "'P28D'^^xsd:dayTimeDuration", 2);
    }

    @Test
    public void testCompareDuration_06() {
        TestXSDFuncOp.testCompare("'P13M'^^xsd:yearMonthDuration", "'P1Y'^^xsd:yearMonthDuration", 1);
    }

    private static void testCompare(String s1, String s2, int correct) {
        NodeValue nv1 = TestXSDFuncOp.parse(s1);
        NodeValue nv2 = TestXSDFuncOp.parse(s2);
        int x = NodeValue.compare((NodeValue)nv1, (NodeValue)nv2);
        Assert.assertEquals((String)("(" + s1 + ", " + s2 + ") -> " + TestXSDFuncOp.name(x) + " [" + TestXSDFuncOp.name(correct) + "]"), (long)correct, (long)x);
        int y = x;
        if (x == -1 || x == 1) {
            y = -x;
        }
        Assert.assertEquals((String)("Not symmetric: (" + s1 + ", " + s2 + ")"), (long)NodeValue.compare((NodeValue)nv2, (NodeValue)nv1), (long)y);
    }

    private static String name(int cmp) {
        switch (cmp) {
            case 0: {
                return "EQ";
            }
            case 1: {
                return "GT";
            }
            case -1: {
                return "LT";
            }
            case -9: {
                return "NE";
            }
            case 2: {
                return "INDET";
            }
        }
        return "Unknown";
    }

    private static NodeValue parse(String str) {
        Node n = SSE.parseNode((String)str);
        return NodeValue.makeNode((Node)n);
    }

    @Test
    public void testAbs1() {
        NodeValue nv = NodeValue.makeInteger((long)2L);
        NodeValue r = XSDFuncOp.abs((NodeValue)nv);
        Assert.assertTrue((String)("Not an integer: " + r), (boolean)r.isInteger());
        Assert.assertTrue((String)("Not a NodeValueInteger: " + r), (boolean)(r instanceof NodeValueInteger));
        Assert.assertEquals((String)"Wrong result", (long)2L, (long)r.getInteger().longValue());
    }

    @Test
    public void testAbs2() {
        NodeValue nv = NodeValue.makeInteger((long)-2L);
        NodeValue r = XSDFuncOp.abs((NodeValue)nv);
        Assert.assertTrue((String)("Not an integer: " + r), (boolean)r.isInteger());
        Assert.assertTrue((String)("Not a NodeValueInteger: " + r), (boolean)(r instanceof NodeValueInteger));
        Assert.assertEquals((String)"Wrong result", (long)2L, (long)r.getInteger().longValue());
    }

    @Test
    public void testAbs3() {
        NodeValue nv = NodeValue.makeDecimal((long)2L);
        NodeValue r = XSDFuncOp.abs((NodeValue)nv);
        Assert.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        Assert.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        Assert.assertEquals((String)"Wrong result", (double)2.0, (double)r.getDecimal().doubleValue(), (double)0.0);
    }

    @Test
    public void testAbs4() {
        NodeValue nv = NodeValue.makeDecimal((long)-2L);
        NodeValue r = XSDFuncOp.abs((NodeValue)nv);
        Assert.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        Assert.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        Assert.assertEquals((String)"Wrong result", (double)2.0, (double)r.getDecimal().doubleValue(), (double)0.0);
    }

    @Test
    public void testAbs5() {
        NodeValue nv = NodeValue.makeFloat((float)2.0f);
        NodeValue r = XSDFuncOp.abs((NodeValue)nv);
        Assert.assertTrue((String)("Not an float: " + r), (boolean)r.isFloat());
        Assert.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        Assert.assertEquals((String)"Wrong result", (double)2.0, (double)r.getFloat(), (double)0.0);
    }

    @Test
    public void testAbs6() {
        NodeValue nv = NodeValue.makeFloat((float)-2.0f);
        NodeValue r = XSDFuncOp.abs((NodeValue)nv);
        Assert.assertTrue((String)("Not an float: " + r), (boolean)r.isFloat());
        Assert.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        Assert.assertEquals((String)"Wrong result", (double)2.0, (double)r.getFloat(), (double)0.0);
    }

    @Test
    public void testAbs7() {
        NodeValue nv = NodeValue.makeDouble((double)2.0);
        NodeValue r = XSDFuncOp.abs((NodeValue)nv);
        Assert.assertTrue((String)("Not an double: " + r), (boolean)r.isDouble());
        Assert.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        Assert.assertEquals((String)"Wrong result", (double)2.0, (double)r.getDouble(), (double)0.0);
    }

    @Test
    public void testAbs8() {
        NodeValue nv = NodeValue.makeDouble((double)-2.0);
        NodeValue r = XSDFuncOp.abs((NodeValue)nv);
        Assert.assertTrue((String)("Not an double: " + r), (boolean)r.isDouble());
        Assert.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        Assert.assertEquals((String)"Wrong result", (double)2.0, (double)r.getDouble(), (double)0.0);
    }

    @Test
    public void testCeiling1() {
        NodeValue nv = NodeValue.makeDecimal((double)2.6);
        NodeValue r = XSDFuncOp.ceiling((NodeValue)nv);
        Assert.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        Assert.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        Assert.assertEquals((String)"Wrong result", (long)3L, (long)r.getDecimal().longValue());
    }

    @Test
    public void testCeiling2() {
        NodeValue nv = NodeValue.makeDecimal((double)-3.6);
        NodeValue r = XSDFuncOp.ceiling((NodeValue)nv);
        Assert.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        Assert.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        Assert.assertEquals((String)"Wrong result", (long)-3L, (long)r.getDecimal().longValue());
    }

    @Test
    public void testCeiling3() {
        NodeValue nv = NodeValue.makeDouble((double)2.6);
        NodeValue r = XSDFuncOp.ceiling((NodeValue)nv);
        Assert.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDouble());
        Assert.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        Assert.assertEquals((String)"Wrong result", (double)3.0, (double)r.getDouble(), (double)0.0);
    }

    @Test
    public void testCeiling4() {
        NodeValue nv = NodeValue.makeDouble((double)-3.6);
        NodeValue r = XSDFuncOp.ceiling((NodeValue)nv);
        Assert.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDouble());
        Assert.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        Assert.assertEquals((String)"Wrong result", (double)-3.0, (double)r.getDouble(), (double)0.0);
    }

    @Test
    public void testCeiling5() {
        NodeValue nv = NodeValue.makeInteger((long)3L);
        NodeValue r = XSDFuncOp.ceiling((NodeValue)nv);
        Assert.assertTrue((String)("Not an integer: " + r), (boolean)r.isInteger());
        Assert.assertTrue((String)("Not a NodeValueInteger: " + r), (boolean)(r instanceof NodeValueInteger));
        Assert.assertEquals((String)"Wrong result", (long)3L, (long)r.getInteger().longValue());
    }

    @Test
    public void testFloor1() {
        NodeValue nv = NodeValue.makeDecimal((double)2.6);
        NodeValue r = XSDFuncOp.floor((NodeValue)nv);
        Assert.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        Assert.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        Assert.assertEquals((String)"Wrong result", (long)2L, (long)r.getDecimal().longValue());
    }

    @Test
    public void testFloor2() {
        NodeValue nv = NodeValue.makeDecimal((double)-3.6);
        NodeValue r = XSDFuncOp.floor((NodeValue)nv);
        Assert.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        Assert.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        Assert.assertEquals((String)"Wrong result", (long)-4L, (long)r.getDecimal().longValue());
    }

    @Test
    public void testFloor3() {
        NodeValue nv = NodeValue.makeDouble((double)2.6);
        NodeValue r = XSDFuncOp.floor((NodeValue)nv);
        Assert.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDouble());
        Assert.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        Assert.assertEquals((String)"Wrong result", (double)2.0, (double)r.getDouble(), (double)0.0);
    }

    @Test
    public void testFloor4() {
        NodeValue nv = NodeValue.makeDouble((double)-3.6);
        NodeValue r = XSDFuncOp.floor((NodeValue)nv);
        Assert.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDouble());
        Assert.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        Assert.assertEquals((String)"Wrong result", (double)-4.0, (double)r.getDouble(), (double)0.0);
    }

    @Test
    public void testFloor5() {
        NodeValue nv = NodeValue.makeInteger((long)3L);
        NodeValue r = XSDFuncOp.floor((NodeValue)nv);
        Assert.assertTrue((String)("Not an integer: " + r), (boolean)r.isInteger());
        Assert.assertTrue((String)("Not a NodeValueInteger: " + r), (boolean)(r instanceof NodeValueInteger));
        Assert.assertEquals((String)"Wrong result", (long)3L, (long)r.getInteger().longValue());
    }

    @Test
    public void testSqrt1() {
        NodeValue four = NodeValue.makeInteger((long)4L);
        NodeValue two = NodeValue.makeDouble((double)2.0);
        NodeValue result = XSDFuncOp.sqrt((NodeValue)four);
        Assert.assertTrue((boolean)result.isDouble());
        Assert.assertFalse((boolean)result.isDecimal());
        Assert.assertTrue((boolean)NodeValue.sameAs((NodeValue)two, (NodeValue)result));
        Assert.assertTrue((boolean)two.asNode().sameValueAs((Object)result.asNode()));
    }

    @Test
    public void testSqrt2() {
        NodeValue four = NodeValue.makeDouble((double)4.0);
        NodeValue two = NodeValue.makeInteger((long)2L);
        NodeValue result = XSDFuncOp.sqrt((NodeValue)four);
        Assert.assertTrue((boolean)result.isDouble());
        Assert.assertTrue((boolean)NodeValue.sameAs((NodeValue)two, (NodeValue)result));
        Assert.assertNotNull((Object)result.asNode());
    }

    @Test(expected=ExprEvalException.class)
    public void testStrReplace() {
        NodeValue wrong = NodeValue.makeString((String)"^(?:-*[^-]){-9}");
        NodeValue nvStr = NodeValue.makeString((String)"AGIKLAKLMTUARAR");
        NodeValue empty = NodeValue.makeString((String)"");
        XSDFuncOp.strReplace((NodeValue)nvStr, (NodeValue)wrong, (NodeValue)empty);
    }

    private static void testDateTimeCast(NodeValue nv, XSDDatatype xsd, NodeValue nvResult) {
        NodeValue nv2 = XSDFuncOp.dateTimeCast((NodeValue)nv, (XSDDatatype)xsd);
        Assert.assertEquals((Object)nvResult, (Object)nv2);
    }

    @Test
    public void cast_gregorian_01() {
        TestXSDFuncOp.testDateTimeCast(nv_dt, XSDDatatype.XSDdateTime, nv_dt);
    }

    @Test
    public void cast_gregorian_02() {
        TestXSDFuncOp.testDateTimeCast(nv_dt, XSDDatatype.XSDdate, nv_d);
    }

    @Test
    public void cast_gregorian_03() {
        TestXSDFuncOp.testDateTimeCast(nv_dt, XSDDatatype.XSDgYear, nv_gy);
    }

    @Test
    public void cast_gregorian_04() {
        TestXSDFuncOp.testDateTimeCast(nv_dt, XSDDatatype.XSDgYearMonth, nv_gym);
    }

    @Test
    public void cast_gregorian_05() {
        TestXSDFuncOp.testDateTimeCast(nv_dt, XSDDatatype.XSDgMonthDay, nv_gmd);
    }

    @Test
    public void cast_gregorian_06() {
        TestXSDFuncOp.testDateTimeCast(nv_dt, XSDDatatype.XSDgMonth, nv_gm);
    }

    @Test
    public void cast_gregorian_07() {
        TestXSDFuncOp.testDateTimeCast(nv_dt, XSDDatatype.XSDgDay, nv_gd);
    }

    @Test
    public void cast_gregorian_08() {
        TestXSDFuncOp.testDateTimeCast(nv_dt, XSDDatatype.XSDtime, nv_t);
    }

    @Test
    public void cast_gregorian_10() {
        TestXSDFuncOp.testDateTimeCast(nv_d, XSDDatatype.XSDdateTime, NodeValue.makeNode((String)"2010-03-22T00:00:00", (RDFDatatype)XSDDatatype.XSDdateTime));
    }

    @Test
    public void cast_gregorian_11() {
        TestXSDFuncOp.testDateTimeCast(nv_d, XSDDatatype.XSDdate, nv_d);
    }

    @Test
    public void cast_gregorian_12() {
        TestXSDFuncOp.testDateTimeCast(nv_d, XSDDatatype.XSDgYear, nv_gy);
    }

    @Test
    public void cast_gregorian_13() {
        TestXSDFuncOp.testDateTimeCast(nv_d, XSDDatatype.XSDgYearMonth, nv_gym);
    }

    @Test
    public void cast_gregorian_14() {
        TestXSDFuncOp.testDateTimeCast(nv_d, XSDDatatype.XSDgMonthDay, nv_gmd);
    }

    @Test
    public void cast_gregorian_15() {
        TestXSDFuncOp.testDateTimeCast(nv_d, XSDDatatype.XSDgMonth, nv_gm);
    }

    @Test
    public void cast_gregorian_16() {
        TestXSDFuncOp.testDateTimeCast(nv_d, XSDDatatype.XSDgDay, nv_gd);
    }

    @Test
    public void cast_gregorian_21() {
        TestXSDFuncOp.testDateTimeCast(nv_gym, XSDDatatype.XSDgYearMonth, nv_gym);
    }

    @Test
    public void cast_gregorian_22() {
        TestXSDFuncOp.testDateTimeCast(nv_gy, XSDDatatype.XSDgYear, nv_gy);
    }

    @Test
    public void cast_gregorian_23() {
        TestXSDFuncOp.testDateTimeCast(nv_gmd, XSDDatatype.XSDgMonthDay, nv_gmd);
    }

    @Test
    public void cast_gregorian_24() {
        TestXSDFuncOp.testDateTimeCast(nv_gm, XSDDatatype.XSDgMonth, nv_gm);
    }

    @Test
    public void cast_gregorian_25() {
        TestXSDFuncOp.testDateTimeCast(nv_gd, XSDDatatype.XSDgDay, nv_gd);
    }

    @Test(expected=ExprEvalTypeException.class)
    public void cast_gregorian_31() {
        TestXSDFuncOp.testDateTimeCast(nv_gym, XSDDatatype.XSDdate, nv_d);
    }

    @Test(expected=ExprEvalTypeException.class)
    public void cast_gregorian_32() {
        TestXSDFuncOp.testDateTimeCast(nv_gy, XSDDatatype.XSDdate, NodeValue.makeDate((String)"2010-01-01"));
    }

    @Test(expected=ExprEvalTypeException.class)
    public void cast_gregorian_33() {
        TestXSDFuncOp.testDateTimeCast(nv_gmd, XSDDatatype.XSDdate, nv_d);
    }

    @Test(expected=ExprEvalTypeException.class)
    public void cast_gregorian_34() {
        TestXSDFuncOp.testDateTimeCast(nv_gm, XSDDatatype.XSDdate, nv_d);
    }

    @Test(expected=ExprEvalTypeException.class)
    public void cast_gregorian_35() {
        TestXSDFuncOp.testDateTimeCast(nv_gd, XSDDatatype.XSDdate, nv_d);
    }

    @Test(expected=ExprEvalTypeException.class)
    public void cast_err_gregorian_01() {
        TestXSDFuncOp.testDateTimeCast(NodeValue.makeBoolean((boolean)false), XSDDatatype.XSDgDay, nv_gd);
    }

    @Test
    public void cast_date_tz_01() {
        TestXSDFuncOp.testDateTimeCast(nv_dt_tz1, XSDDatatype.XSDdate, nv_d_tz1);
    }

    @Test
    public void cast_date_tz_02() {
        TestXSDFuncOp.testDateTimeCast(nv_dt_tz2, XSDDatatype.XSDdate, nv_d_tz2);
    }

    @Test
    public void cast_date_tz_03() {
        TestXSDFuncOp.testDateTimeCast(nv_dt_tz3, XSDDatatype.XSDdate, nv_d_tz3);
    }

    @Test
    public void cast_time_tz_01() {
        TestXSDFuncOp.testDateTimeCast(nv_dt_tz1, XSDDatatype.XSDtime, nv_t_tz1);
    }

    @Test
    public void cast_time_tz_02() {
        TestXSDFuncOp.testDateTimeCast(nv_dt_tz2, XSDDatatype.XSDtime, nv_t_tz2);
    }

    @Test
    public void cast_time_tz_03() {
        TestXSDFuncOp.testDateTimeCast(nv_dt_tz3, XSDDatatype.XSDtime, nv_t_tz3);
    }

    @Test
    public void fn_error_01() {
        try {
            LibTestExpr.eval("fn:error()");
            Assert.fail((String)"No exception");
        }
        catch (ExprEvalException ex) {
            Assert.assertNull((Object)ex.getMessage());
        }
    }

    @Test
    public void fn_error_02() {
        try {
            LibTestExpr.eval("fn:error('MESSAGE')");
            Assert.fail((String)"No exception");
        }
        catch (ExprEvalException ex) {
            Assert.assertEquals((Object)"MESSAGE", (Object)ex.getMessage());
        }
    }
}

