/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.graph.Factory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.modify.AbstractTestUpdateBase;
import org.apache.jena.sparql.modify.UsingList;
import org.apache.jena.sparql.modify.request.QuadAcc;
import org.apache.jena.sparql.modify.request.QuadDataAcc;
import org.apache.jena.sparql.modify.request.Target;
import org.apache.jena.sparql.modify.request.UpdateCopy;
import org.apache.jena.sparql.modify.request.UpdateDataDelete;
import org.apache.jena.sparql.modify.request.UpdateDataInsert;
import org.apache.jena.sparql.modify.request.UpdateDeleteWhere;
import org.apache.jena.sparql.modify.request.UpdateModify;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateAction;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateProcessor;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractTestUpdateGraph
extends AbstractTestUpdateBase {
    protected static Node s = NodeFactoryExtra.parseNode((String)"<http://example/r>");
    protected static Node p = NodeFactoryExtra.parseNode((String)"<http://example/p>");
    protected static Node q = NodeFactoryExtra.parseNode((String)"<http://example/q>");
    protected static Node v = NodeFactoryExtra.parseNode((String)"<http://example/v>");
    protected static Node o1 = NodeFactoryExtra.parseNode((String)"2007");
    protected static Triple triple1 = new Triple(s, p, o1);
    protected static Node o2 = NodeFactoryExtra.parseNode((String)"1066");
    protected static Triple triple2 = new Triple(s, p, o2);
    protected static Graph graph1 = AbstractTestUpdateGraph.data1();
    protected static Node graphIRI = NodeFactoryExtra.parseNode((String)"<http://example/graph>");

    @Test
    public void testInsertData1() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        this.defaultGraphData(gStore, graph1);
        QuadDataAcc acc = new QuadDataAcc();
        acc.addTriple(triple2);
        UpdateDataInsert insert = new UpdateDataInsert(acc);
        UpdateProcessor uProc = UpdateExecutionFactory.create((Update)insert, (DatasetGraph)gStore);
        uProc.execute();
        Assert.assertFalse((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple2));
    }

    @Test
    public void testDeleteData1() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        this.defaultGraphData(gStore, graph1);
        QuadDataAcc acc = new QuadDataAcc();
        acc.addTriple(triple2);
        UpdateDataDelete delete = new UpdateDataDelete(acc);
        UpdateProcessor uProc = UpdateExecutionFactory.create((Update)delete, (DatasetGraph)gStore);
        uProc.execute();
        Assert.assertFalse((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
        Assert.assertFalse((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple2));
    }

    @Test
    public void testDeleteData2() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        this.defaultGraphData(gStore, graph1);
        QuadDataAcc acc = new QuadDataAcc();
        acc.addTriple(triple1);
        UpdateDataDelete delete = new UpdateDataDelete(acc);
        UpdateProcessor uProc = UpdateExecutionFactory.create((Update)delete, (DatasetGraph)gStore);
        uProc.execute();
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        Assert.assertFalse((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
    }

    @Test
    public void testInsert1() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        UpdateModify insert = new UpdateModify();
        UpdateAction.execute((Update)insert, (DatasetGraph)gStore);
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testInsert2() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        UpdateModify insert = new UpdateModify();
        insert.getInsertAcc().addTriple(triple1);
        UpdateAction.execute((Update)insert, (DatasetGraph)gStore);
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
    }

    @Test
    public void testInsert3() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        gStore.addGraph(graphIRI, Factory.createDefaultGraph());
        UpdateModify insert = new UpdateModify();
        insert.getInsertAcc().addQuad(new Quad(graphIRI, triple1));
        UpdateAction.execute((Update)insert, (DatasetGraph)gStore);
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), triple1));
    }

    @Test
    public void testInsert4() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        this.defaultGraphData(gStore, graph1);
        UpdateModify insert = new UpdateModify();
        insert.getInsertAcc().addTriple(SSE.parseTriple((String)"(?s <http://example/p> 1066)"));
        Element element = QueryFactory.createElement((String)"{ ?s <http://example/p> 2007 }");
        insert.setElement(element);
        UpdateAction.execute((Update)insert, (DatasetGraph)gStore);
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple2));
    }

    @Test
    public void testDelete1() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        QuadAcc acc = new QuadAcc();
        UpdateDeleteWhere delete = new UpdateDeleteWhere(acc);
        UpdateAction.execute((Update)delete, (DatasetGraph)gStore);
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testDelete2() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        this.defaultGraphData(gStore, graph1);
        QuadAcc acc = new QuadAcc();
        UpdateDeleteWhere delete = new UpdateDeleteWhere(acc);
        acc.addTriple(SSE.parseTriple((String)"(?s ?p ?o)"));
        UpdateAction.execute((Update)delete, (DatasetGraph)gStore);
        Assert.assertTrue((String)"Not empty", (boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testDelete3() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        this.defaultGraphData(gStore, graph1);
        QuadDataAcc acc = new QuadDataAcc();
        UpdateDataDelete delete = new UpdateDataDelete(acc);
        acc.addTriple(triple1);
        UpdateAction.execute((Update)delete, (DatasetGraph)gStore);
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testDelete4() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        this.namedGraphData(gStore, graphIRI, AbstractTestUpdateGraph.data1());
        QuadDataAcc acc = new QuadDataAcc();
        UpdateDataDelete delete = new UpdateDataDelete(acc);
        acc.setGraph(graphIRI);
        acc.addTriple(triple1);
        UpdateAction.execute((Update)delete, (DatasetGraph)gStore);
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getGraph(graphIRI)));
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testDelete5() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        this.defaultGraphData(gStore, AbstractTestUpdateGraph.data2());
        this.namedGraphData(gStore, graphIRI, AbstractTestUpdateGraph.data1());
        UpdateModify modify = new UpdateModify();
        Element element = QueryFactory.createElement((String)"{ ?s <http://example/p> ?o }");
        modify.setElement(element);
        modify.getDeleteAcc().addQuad(SSE.parseQuad((String)"(<http://example/graph> ?s <http://example/p> 2007 )"));
        UpdateAction.execute((Update)modify, (DatasetGraph)gStore);
        Assert.assertTrue((String)"Not empty", (boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getGraph(graphIRI)));
        Assert.assertFalse((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testModify1() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        this.defaultGraphData(gStore, AbstractTestUpdateGraph.data2());
        this.namedGraphData(gStore, graphIRI, Factory.createDefaultGraph());
        UpdateModify modify = new UpdateModify();
        Element element = QueryFactory.createElement((String)"{ ?s <http://example/p> ?o }");
        modify.setElement(element);
        modify.getInsertAcc().addQuad(new Quad(graphIRI, triple1));
        modify.getDeleteAcc().addTriple(SSE.parseTriple((String)"(?s <http://example/p> ?o)"));
        modify.getDeleteAcc().addQuad(SSE.parseQuad((String)"(<http://example/graph> ?s <http://example/p> ?o)"));
        UpdateAction.execute((Update)modify, (DatasetGraph)gStore);
        Assert.assertFalse((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getGraph(graphIRI)));
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), triple1));
    }

    @Test
    public void testModify2() {
        Triple t = new Triple(NodeFactory.createBlankNode(), p, o2);
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        gStore.getContext().set(ARQ.spillToDiskThreshold, (Object)0L);
        this.defaultGraphData(gStore, AbstractTestUpdateGraph.data(t));
        this.namedGraphData(gStore, graphIRI, AbstractTestUpdateGraph.data(t));
        UpdateModify modify = new UpdateModify();
        Element element = QueryFactory.createElement((String)"{ ?s <http://example/p> ?o }");
        modify.setElement(element);
        modify.getInsertAcc().addQuad(new Quad(graphIRI, triple1));
        modify.getDeleteAcc().addTriple(SSE.parseTriple((String)"(?s <http://example/p> ?o)"));
        modify.getDeleteAcc().addQuad(SSE.parseQuad((String)"(<http://example/graph> ?s <http://example/p> ?o)"));
        UpdateAction.execute((Update)modify, (DatasetGraph)gStore);
        Assert.assertFalse((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getGraph(graphIRI)));
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), triple1));
        Assert.assertFalse((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), t));
    }

    @Test
    public void testModifyInitialBindings() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        this.defaultGraphData(gStore, AbstractTestUpdateGraph.data12());
        this.namedGraphData(gStore, graphIRI, Factory.createDefaultGraph());
        Binding initialBinding = BindingFactory.binding((Var)Var.alloc((String)"o"), (Node)o1);
        UpdateModify modify = new UpdateModify();
        Element element = QueryFactory.createElement((String)"{ ?s <http://example/p> ?o }");
        modify.setElement(element);
        modify.getInsertAcc().addQuad(new Quad(graphIRI, triple1));
        modify.getDeleteAcc().addTriple(SSE.parseTriple((String)"(?s <http://example/p> ?o)"));
        modify.getDeleteAcc().addQuad(SSE.parseQuad((String)"(<http://example/graph> ?s <http://example/p> ?o)"));
        UpdateAction.execute((Update)modify, (DatasetGraph)gStore, (Binding)initialBinding);
        Assert.assertFalse((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getGraph(graphIRI)));
        Assert.assertFalse((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), triple1));
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple2));
        Assert.assertFalse((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
    }

    @Test
    public void testCopy() {
        Triple t = new Triple(NodeFactory.createBlankNode(), p, o2);
        Triple t2 = new Triple(NodeFactory.createBlankNode(), p, o1);
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        gStore.getContext().set(ARQ.spillToDiskThreshold, (Object)0L);
        this.defaultGraphData(gStore, AbstractTestUpdateGraph.data(triple1, triple2, t));
        this.namedGraphData(gStore, graphIRI, AbstractTestUpdateGraph.data(t2));
        UpdateCopy copy = new UpdateCopy(Target.DEFAULT, Target.create((Node)graphIRI));
        UpdateAction.execute((Update)copy, (DatasetGraph)gStore);
        Assert.assertFalse((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        Assert.assertFalse((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getGraph(graphIRI)));
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), triple1));
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), triple2));
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), t));
        Assert.assertFalse((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), t2));
        Assert.assertTrue((boolean)gStore.getDefaultGraph().isIsomorphicWith(gStore.getGraph(graphIRI)));
    }

    @Test
    public void testUpdateInsertData() {
        DatasetGraph dsg = this.getEmptyDatasetGraph();
        String updateStr = "INSERT DATA { <x:s> <x:p> 'dft' }";
        byte[] bytes = Bytes.string2bytes((String)updateStr);
        UsingList usingList = new UsingList();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        UpdateAction.parseExecute((UsingList)usingList, (DatasetGraph)dsg, (InputStream)in);
        Assert.assertEquals((long)1L, (long)dsg.getDefaultGraph().size());
    }

    @Test
    public void testUpdateDeleteData() {
        DatasetGraph dsg = this.getEmptyDatasetGraph();
        dsg.add(SSE.parseQuad((String)"(_ <x:s> <x:p> <x:o>)"));
        Assert.assertEquals((long)1L, (long)dsg.getDefaultGraph().size());
        String updateStr = "DELETE DATA { <x:s> <x:p> <x:o> }";
        byte[] bytes = Bytes.string2bytes((String)updateStr);
        UsingList usingList = new UsingList();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        UpdateAction.parseExecute((UsingList)usingList, (DatasetGraph)dsg, (InputStream)in);
        Assert.assertEquals((long)0L, (long)dsg.getDefaultGraph().size());
    }

    @Test
    public void testUpdateScript1() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        AbstractTestUpdateGraph.script(gStore, "update-1.ru");
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), new Triple(s, p, NodeFactoryExtra.parseNode((String)"123"))));
    }

    @Test
    public void testUpdateScript2() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        AbstractTestUpdateGraph.script(gStore, "update-2.ru");
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(NodeFactory.createURI((String)"http://example/g1")), new Triple(s, p, NodeFactoryExtra.parseNode((String)"123"))));
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testUpdateScript3() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        AbstractTestUpdateGraph.script(gStore, "update-3.ru");
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getGraph(NodeFactory.createURI((String)"http://example/g1"))));
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testUpdateScript4() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        AbstractTestUpdateGraph.script(gStore, "data-1.ru");
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), new Triple(s, p, NodeFactoryExtra.parseNode((String)"123"))));
    }

    @Test
    public void testUpdateScript5() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        AbstractTestUpdateGraph.script(gStore, "data-2.ru");
        Graph g = GraphFactory.createPlainGraph();
        Node b = NodeFactory.createBlankNode();
        g.add(new Triple(s, p, b));
        g.add(new Triple(b, q, v));
        Assert.assertTrue((boolean)g.isIsomorphicWith(gStore.getDefaultGraph()));
    }

    @Test
    public void testUpdateScript6() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        AbstractTestUpdateGraph.script(gStore, "data-3.ru");
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), new Triple(s, p, NodeFactoryExtra.parseNode((String)"123"))));
    }

    @Test
    public void testUpdateScript7() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        AbstractTestUpdateGraph.script(gStore, "data-4.ru");
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), new Triple(s, p, NodeFactoryExtra.parseNode((String)"123"))));
        Graph g = gStore.getGraph(graphIRI);
        Assert.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), new Triple(s, p, o2)));
    }

    @Test
    public void testUpdateScript8() {
        Node gn = NodeFactory.createURI((String)"http://example/g");
        Node testNode = NodeFactory.createURI((String)"http://example/test");
        Node result = NodeFactory.createURI((String)"http://example/result");
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        AbstractTestUpdateGraph.script(gStore, "data-5-with.ru");
        Assert.assertTrue((boolean)gStore.containsGraph(gn));
        Graph g = gStore.getGraph(gn);
        Assert.assertEquals((long)2L, (long)g.size());
        Assert.assertEquals((long)0L, (long)gStore.getDefaultGraph().size());
    }

    @Test(expected=QueryException.class)
    public void testUpdateBad1() {
        this.testBad("bad-1.ru", 1);
    }

    @Test
    public void testUpdateBad2() {
        this.testBad("bad-2.ru", 1);
    }

    @Test
    public void testUpdateBad3() {
        this.testBad("bad-3.ru", 0);
    }

    private void testBad(String file, int expectedSize) {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        AbstractTestUpdateGraph.script(gStore, file);
        Assert.assertEquals((long)expectedSize, (long)AbstractTestUpdateGraph.countQuads(gStore));
    }

    private static long countQuads(DatasetGraph dsg) {
        return Iter.count((Iterator)dsg.find());
    }

    private static Graph data1() {
        return AbstractTestUpdateGraph.data(triple1);
    }

    private static Graph data2() {
        return AbstractTestUpdateGraph.data(triple2);
    }

    private static Graph data12() {
        return AbstractTestUpdateGraph.data(triple1, triple2);
    }

    private static Graph data(Triple ... triples) {
        Graph graph = Factory.createDefaultGraph();
        for (Triple t : triples) {
            graph.add(t);
        }
        return graph;
    }
}

