/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.update.UpdateAction;
import org.apache.jena.update.UpdateException;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestUpdateOperations {
    private static final String DIR = "testing/Update";
    private Node gName = SSE.parseNode((String)"<http://example/g>");
    private static ErrorHandler eh;

    private DatasetGraph graphStore() {
        return DatasetGraphFactory.create();
    }

    @BeforeClass
    public static void beforeClass() {
        eh = ErrorHandlerFactory.getDefaultErrorHandler();
        ErrorHandler silent = ErrorHandlerFactory.errorHandlerStrictSilent();
        ErrorHandlerFactory.setDefaultErrorHandler((ErrorHandler)silent);
    }

    @AfterClass
    public static void afterClass() {
        ErrorHandlerFactory.setDefaultErrorHandler((ErrorHandler)eh);
    }

    @Test
    public void load1() {
        DatasetGraph gs = this.graphStore();
        UpdateRequest req = UpdateFactory.create((String)"LOAD <testing/Update/D.nt>");
        UpdateAction.execute((UpdateRequest)req, (DatasetGraph)gs);
        Assert.assertEquals((long)1L, (long)gs.getDefaultGraph().size());
        Assert.assertFalse((boolean)gs.listGraphNodes().hasNext());
    }

    @Test
    public void load2() {
        DatasetGraph gs = this.graphStore();
        UpdateRequest req = UpdateFactory.create((String)("LOAD <testing/Update/D.nt> INTO GRAPH <" + this.gName.getURI() + ">"));
        UpdateAction.execute((UpdateRequest)req, (DatasetGraph)gs);
    }

    @Test
    public void load3() {
        DatasetGraph gs = this.graphStore();
        UpdateRequest req = UpdateFactory.create((String)"LOAD <testing/Update/D.nq>");
        UpdateAction.execute((UpdateRequest)req, (DatasetGraph)gs);
        Assert.assertEquals((long)0L, (long)gs.getDefaultGraph().size());
        gs.containsGraph(NodeFactory.createURI((String)"http://example/"));
        Assert.assertEquals((long)1L, (long)gs.getGraph(this.gName).size());
    }

    @Test(expected=UpdateException.class)
    public void load4() {
        DatasetGraph gs = this.graphStore();
        UpdateRequest req = UpdateFactory.create((String)("LOAD <testing/Update/D.nq> INTO GRAPH <" + this.gName.getURI() + ">"));
        UpdateAction.execute((UpdateRequest)req, (DatasetGraph)gs);
    }

    @Test
    public void load5() {
        DatasetGraph gs = this.graphStore();
        UpdateRequest req = UpdateFactory.create((String)("LOAD SILENT <testing/Update/D.nq> INTO GRAPH <" + this.gName.getURI() + ">"));
        UpdateAction.execute((UpdateRequest)req, (DatasetGraph)gs);
        Assert.assertEquals((long)0L, (long)Iter.count((Iterator)gs.find()));
    }

    @Test(expected=UpdateException.class)
    public void load6() {
        DatasetGraph gs = this.graphStore();
        UpdateRequest req = UpdateFactory.create((String)"LOAD <testing/Update/D-bad.nq>");
        UpdateAction.execute((UpdateRequest)req, (DatasetGraph)gs);
        Assert.assertEquals((long)0L, (long)Iter.count((Iterator)gs.find()));
    }

    @Test
    public void load7() {
        DatasetGraph gs = this.graphStore();
        UpdateRequest req = UpdateFactory.create((String)"LOAD SILENT <testing/Update/D-bad.nq>");
        UpdateAction.execute((UpdateRequest)req, (DatasetGraph)gs);
        Assert.assertEquals((long)0L, (long)Iter.count((Iterator)gs.find()));
    }

    @Test(expected=UpdateException.class)
    public void load8() {
        DatasetGraph gs = this.graphStore();
        UpdateRequest req = UpdateFactory.create((String)("LOAD <testing/Update/D-bad.nt> INTO GRAPH <" + this.gName.getURI() + ">"));
        UpdateAction.execute((UpdateRequest)req, (DatasetGraph)gs);
        Assert.assertEquals((long)0L, (long)Iter.count((Iterator)gs.find()));
    }

    @Test
    public void load9() {
        DatasetGraph gs = this.graphStore();
        UpdateRequest req = UpdateFactory.create((String)("LOAD SILENT <testing/Update/D-bad.nt> INTO GRAPH <" + this.gName.getURI() + ">"));
        UpdateAction.execute((UpdateRequest)req, (DatasetGraph)gs);
        Assert.assertEquals((long)0L, (long)Iter.count((Iterator)gs.find()));
    }

    @Test(expected=UpdateException.class)
    public void load10() {
        DatasetGraph gs = this.graphStore();
        UpdateRequest req = UpdateFactory.create((String)("LOAD <testing/Update/D-quads.nt> INTO GRAPH <" + this.gName.getURI() + ">"));
        UpdateAction.execute((UpdateRequest)req, (DatasetGraph)gs);
        Assert.assertEquals((long)0L, (long)Iter.count((Iterator)gs.find()));
    }

    @Test
    public void load11() {
        DatasetGraph gs = this.graphStore();
        UpdateRequest req = UpdateFactory.create((String)("LOAD SILENT <testing/Update/D-quads.nt> INTO GRAPH <" + this.gName.getURI() + ">"));
        UpdateAction.execute((UpdateRequest)req, (DatasetGraph)gs);
        Assert.assertEquals((long)0L, (long)Iter.count((Iterator)gs.find()));
    }

    @Test(expected=UpdateException.class)
    public void load12() {
        DatasetGraph gs = this.graphStore();
        UpdateRequest req = UpdateFactory.create((String)"LOAD <testing/Update/D-not-found.nt>");
        UpdateAction.execute((UpdateRequest)req, (DatasetGraph)gs);
        Assert.assertEquals((long)0L, (long)Iter.count((Iterator)gs.find()));
    }

    @Test
    public void load13() {
        DatasetGraph gs = this.graphStore();
        UpdateRequest req = UpdateFactory.create((String)"LOAD SILENT <testing/Update/D-not-found.nt>");
        UpdateAction.execute((UpdateRequest)req, (DatasetGraph)gs);
        Assert.assertEquals((long)0L, (long)Iter.count((Iterator)gs.find()));
    }

    @Test(expected=UpdateException.class)
    public void load14() {
        DatasetGraph gs = this.graphStore();
        UpdateRequest req = UpdateFactory.create((String)("LOAD <testing/Update/D-not-found.nt> INTO GRAPH <" + this.gName.getURI() + ">"));
        UpdateAction.execute((UpdateRequest)req, (DatasetGraph)gs);
        Assert.assertEquals((long)0L, (long)Iter.count((Iterator)gs.find()));
    }

    @Test
    public void load15() {
        DatasetGraph gs = this.graphStore();
        UpdateRequest req = UpdateFactory.create((String)("LOAD SILENT <testing/Update/D-not-found.nt> INTO GRAPH <" + this.gName.getURI() + ">"));
        UpdateAction.execute((UpdateRequest)req, (DatasetGraph)gs);
        Assert.assertEquals((long)0L, (long)Iter.count((Iterator)gs.find()));
    }

    @Test
    public void insert_where_01() {
        Model m = ModelFactory.createDefaultModel();
        Resource anon = m.createResource();
        anon.addProperty(RDF.type, (RDFNode)OWL.Thing);
        Assert.assertEquals((long)1L, (long)m.size());
        UpdateRequest req = UpdateFactory.create((String)"INSERT { ?s ?p ?o } WHERE { ?o ?p ?s }");
        UpdateAction.execute((UpdateRequest)req, (Model)m);
        Assert.assertEquals((long)2L, (long)m.size());
        Assert.assertEquals((long)1L, (long)m.listStatements(anon, null, (RDFNode)null).toList().size());
        Assert.assertEquals((long)1L, (long)m.listStatements(null, null, (RDFNode)anon).toList().size());
    }

    @Test
    public void delete_insert_where_01() {
        DatasetGraph dsg0 = DatasetGraphFactory.create();
        UpdateRequest req = UpdateFactory.create((String)"INSERT DATA { <x> <p> 2 . <z> <q> 2 . <z> <q> 3 . }");
        UpdateAction.execute((UpdateRequest)req, (DatasetGraph)dsg0);
        Assert.assertEquals((long)3L, (long)dsg0.getDefaultGraph().size());
        final AtomicLong counterIns = new AtomicLong(0L);
        final AtomicLong counterDel = new AtomicLong(0L);
        DatasetGraphWrapper dsg = new DatasetGraphWrapper(dsg0){

            public void add(Quad quad) {
                counterIns.incrementAndGet();
                super.add(quad);
            }

            public void delete(Quad quad) {
                counterDel.incrementAndGet();
                super.delete(quad);
            }
        };
        String s = "DELETE { ?x <p> 2 . <z> <q> 2 } INSERT { ?x <p> 1 . <x> <q> 1  } WHERE { ?x <p> ?o {} UNION {} }";
        req = UpdateFactory.create((String)s);
        UpdateAction.execute((UpdateRequest)req, (DatasetGraph)dsg);
        Assert.assertEquals((long)3L, (long)counterIns.get());
        Assert.assertEquals((long)3L, (long)counterIns.get());
        Assert.assertEquals((long)3L, (long)dsg.getDefaultGraph().size());
    }
}

