/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.solver;

import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.engine.optimizer.StatsMatcher;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderLib;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderProcIndexes;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderWeighted;
import org.apache.jena.sparql.solver.SolverLibTest;
import org.junit.Assert;
import org.junit.Test;

public class TestReorder {
    @Test
    public void match_01() {
        StatsMatcher matcher = SolverLibTest.matcher("((:x :p ANY) 5)");
        Triple t = SolverLibTest.triple("(:x :p ?v)");
        double d = matcher.match(t);
        Assert.assertEquals((double)5.0, (double)d, (double)0.0);
    }

    @Test
    public void match_02() {
        StatsMatcher matcher = SolverLibTest.matcher("((:x :p ANY) 5)");
        Triple t = SolverLibTest.triple("(:x :q ?v)");
        double d = matcher.match(t);
        Assert.assertEquals((double)-1.0, (double)d, (double)0.0);
    }

    @Test
    public void match_03() {
        StatsMatcher matcher = SolverLibTest.matcher("((:x :p VAR) 5)");
        Triple t = SolverLibTest.triple("(:x :p ?v)");
        double d = matcher.match(t);
        Assert.assertEquals((double)5.0, (double)d, (double)0.0);
    }

    @Test
    public void match_04() {
        StatsMatcher matcher = SolverLibTest.matcher("((TERM :p VAR) 5)");
        Triple t = SolverLibTest.triple("(:x :p ?v)");
        double d = matcher.match(t);
        Assert.assertEquals((double)5.0, (double)d, (double)0.0);
    }

    @Test
    public void match_05() {
        StatsMatcher matcher = SolverLibTest.matcher("((URI :p VAR) 5)");
        Triple t = SolverLibTest.triple("(:x :p ?v)");
        double d = matcher.match(t);
        Assert.assertEquals((double)5.0, (double)d, (double)0.0);
    }

    @Test
    public void match_06() {
        StatsMatcher matcher = SolverLibTest.matcher("((LITERAL :p VAR) 5)");
        Triple t = SolverLibTest.triple("(:x :p ?v)");
        double d = matcher.match(t);
        Assert.assertEquals((double)-1.0, (double)d, (double)0.0);
    }

    @Test
    public void match_07() {
        StatsMatcher matcher = SolverLibTest.matcher("((BNODE :p VAR) 5)");
        Triple t = SolverLibTest.triple("(_:a :p ?v)");
        double d = matcher.match(t);
        Assert.assertEquals((double)5.0, (double)d, (double)0.0);
    }

    @Test
    public void match_08() {
        StatsMatcher matcher = SolverLibTest.matcher("((VAR :p LITERAL) 5)");
        Triple t = SolverLibTest.triple("(?x :p ?v)");
        double d = matcher.match(t);
        Assert.assertEquals((double)-1.0, (double)d, (double)0.0);
    }

    @Test
    public void match_09() {
        StatsMatcher matcher = SolverLibTest.matcher("((VAR :p LITERAL) 5)");
        Triple t = SolverLibTest.triple("(?x :p 1913)");
        double d = matcher.match(t);
        Assert.assertEquals((double)5.0, (double)d, (double)0.0);
    }

    @Test
    public void match_10() {
        StatsMatcher matcher = SolverLibTest.matcher("((VAR :p LITERAL) 5) ((VAR :p ANY) 10)");
        Triple t = SolverLibTest.triple("(?x :p 1913)");
        double d = matcher.match(t);
        Assert.assertEquals((double)5.0, (double)d, (double)0.0);
    }

    @Test
    public void match_11() {
        StatsMatcher matcher = SolverLibTest.matcher("((VAR :p ANY) 10) ((VAR :p LITERAL) 5)");
        Triple t = SolverLibTest.triple("(?x :p 1913)");
        double d = matcher.match(t);
        Assert.assertEquals((double)10.0, (double)d, (double)0.0);
    }

    @Test
    public void match_20() {
        StatsMatcher matcher = SolverLibTest.matcher("(:p 10) ");
        Triple t = SolverLibTest.triple("(?x :p ?v)");
        double d = matcher.match(t);
        Assert.assertEquals((double)10.0, (double)d, (double)0.0);
    }

    @Test
    public void match_21() {
        StatsMatcher matcher = SolverLibTest.matcher("(:p 10) ");
        Triple t = SolverLibTest.triple("(?x :p 1913)");
        double d = matcher.match(t);
        Assert.assertEquals((double)4.0, (double)d, (double)0.0);
    }

    @Test
    public void match_22() {
        StatsMatcher matcher = SolverLibTest.matcher("(:p 11)");
        Triple t = SolverLibTest.triple("(:x :p 1913)");
        double d = matcher.match(t);
        Assert.assertEquals((double)1.0, (double)d, (double)0.0);
    }

    @Test
    public void match_23() {
        StatsMatcher matcher = SolverLibTest.matcher("(:p 11)");
        Triple t = SolverLibTest.triple("(:x ?p 1913)");
        double d = matcher.match(t);
        Assert.assertEquals((double)-1.0, (double)d, (double)0.0);
    }

    @Test
    public void match_24() {
        StatsMatcher matcher = SolverLibTest.matcher("(:p 11) (TERM 12)");
        Triple t = SolverLibTest.triple("(?x :q ?v)");
        double d = matcher.match(t);
        Assert.assertEquals((double)12.0, (double)d, (double)0.0);
    }

    @Test
    public void match_25() {
        StatsMatcher matcher = SolverLibTest.matcher("(:p 3) (other 1)");
        Triple t = SolverLibTest.triple("(?x :p ?v)");
        double d = matcher.match(t);
        Assert.assertEquals((double)3.0, (double)d, (double)0.0);
    }

    @Test
    public void match_26() {
        StatsMatcher matcher = SolverLibTest.matcher("(:pp 3) (other 1)");
        Triple t = SolverLibTest.triple("(:x :p ?v)");
        double d = matcher.match(t);
        Assert.assertEquals((double)1.0, (double)d, (double)0.0);
    }

    @Test
    public void match_27() {
        StatsMatcher matcher = SolverLibTest.matcher("(:p 200) (TERM 2)");
        Triple t = SolverLibTest.triple("(?x :q :v)");
        double d = matcher.match(t);
        Assert.assertEquals((double)2.0, (double)d, (double)0.0);
    }

    @Test
    public void reorderIndexes1() {
        ReorderProcIndexes proc = new ReorderProcIndexes(new int[]{0, 1});
        BasicPattern bgp = SolverLibTest.bgp("(bgp (:x :p ?v) (:x :q ?w))");
        BasicPattern bgp2 = proc.reorder(bgp);
        Assert.assertEquals((Object)bgp, (Object)bgp2);
    }

    @Test
    public void reorderIndexes2() {
        ReorderProcIndexes proc = new ReorderProcIndexes(new int[]{1, 0});
        BasicPattern bgp1 = SolverLibTest.bgp("(bgp (:x :p ?v) (:x :q ?w))");
        BasicPattern bgp2 = SolverLibTest.bgp("(bgp (:x :q ?w) (:x :p ?v))");
        BasicPattern bgp3 = proc.reorder(bgp1);
        Assert.assertEquals((Object)bgp2, (Object)bgp3);
    }

    @Test
    public void stats_01() {
        StatsMatcher m = SolverLibTest.matcher("((:x :p ANY) 5)");
        ReorderWeighted transform = new ReorderWeighted(m);
        BasicPattern bgp = SolverLibTest.bgp("(bgp)");
        BasicPattern bgp2 = transform.reorder(bgp);
        Assert.assertEquals((Object)bgp2, (Object)bgp);
    }

    @Test
    public void stats_dft_01() {
        ReorderTransformation transform = ReorderLib.fixed();
        BasicPattern bgp = SolverLibTest.bgp("(bgp)");
        BasicPattern bgp2 = transform.reorder(bgp);
        Assert.assertEquals((Object)bgp2, (Object)bgp);
    }
}

