/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax.syntaxtransform;

import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.syntax.syntaxtransform.QueryTransformOps;
import org.junit.Assert;
import org.junit.Test;

public class TestQueryOps {
    @Test
    public void queryOp_01() {
        TestQueryOps.testShallowCopy("SELECT * { }");
    }

    @Test
    public void queryOp_02() {
        TestQueryOps.testShallowCopy("SELECT ?x { }");
    }

    @Test
    public void queryOp_03() {
        TestQueryOps.testShallowCopy("SELECT * { ?s ?p ?o }");
    }

    @Test
    public void queryOp_04() {
        TestQueryOps.testShallowCopy("SELECT ?x { ?s ?p ?o }");
    }

    @Test
    public void queryOp_05() {
        TestQueryOps.testShallowCopy("SELECT (?x+1 AS ?z) ?y { }");
    }

    @Test
    public void queryOp_06() {
        TestQueryOps.testShallowCopy("SELECT DISTINCT (?x+1 AS ?z) ?y { }");
    }

    @Test
    public void queryOp_07() {
        TestQueryOps.testShallowCopy("SELECT REDUCED (?x+1 AS ?z) ?y { }");
    }

    @Test
    public void queryOp_10() {
        TestQueryOps.testShallowCopy("SELECT ?s { ?s ?p ?o } GROUP BY ?s");
    }

    @Test
    public void queryOp_11() {
        TestQueryOps.testShallowCopy("SELECT ?s { ?s ?p ?o } ORDER BY ?o");
    }

    @Test
    public void queryOp_12() {
        TestQueryOps.testShallowCopy("SELECT ?s { ?s ?p ?o } LIMIT 10");
    }

    @Test
    public void queryOp_13() {
        TestQueryOps.testShallowCopy("SELECT ?s { ?s ?p ?o } OFFSET 5 LIMIT 10");
    }

    private static void testShallowCopy(String queryString) {
        Query q1 = QueryFactory.create((String)queryString);
        Query q2 = QueryTransformOps.shallowCopy((Query)q1);
        Assert.assertEquals((Object)q1, (Object)q2);
    }
}

