/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system;

import java.io.OutputStream;
import java.util.function.Function;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.other.G;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.IsoMatcher;
import org.apache.jena.system.RDFStar;
import org.apache.jena.vocabulary.RDF;
import org.junit.Assert;
import org.junit.Test;

public class TestRDFStarTranslation {
    private static final Node s = SSE.parseNode((String)":s");
    private static final Node p = SSE.parseNode((String)":p");
    private static final Node o = SSE.parseNode((String)":o");
    private static final Node q = SSE.parseNode((String)":q");
    private static final Node z = SSE.parseNode((String)":z");
    private static final Node a = SSE.parseNode((String)":a");
    private static final Node rdfSubject = RDF.Nodes.subject;
    private static final Node rdfPredicate = RDF.Nodes.predicate;
    private static final Node rdfObject = RDF.Nodes.object;

    private static boolean isomorphic(Graph g1, Graph g2) {
        return IsoMatcher.isomorphic((Graph)g1, (Graph)g2);
    }

    @Test
    public void rdfx_basic() {
        Graph g = TestRDFStarTranslation.data("(graph (:s :p :o))");
        Graph g1 = RDFStar.encodeRDFStar((Graph)g);
        Assert.assertTrue((boolean)TestRDFStarTranslation.isomorphic(g, g1));
        Assert.assertEquals((long)1L, (long)g1.size());
        Graph g2 = RDFStar.encodeRDFStar((Graph)g1);
        Assert.assertTrue((boolean)TestRDFStarTranslation.isomorphic(g, g2));
        Assert.assertEquals((long)1L, (long)g2.size());
    }

    @Test
    public void rdfx_01() {
        Graph graph = TestRDFStarTranslation.data("(graph (<<:s :p :o>> :q :z) (:s1 :p1 :o1) )");
        this.testEncode(graph, 5, g -> G.getOnePO((Graph)g, (Node)q, (Node)z));
    }

    @Test
    public void rdfx_02() {
        Graph graph = TestRDFStarTranslation.data("(graph (<<:s :p :o>> :q :z) (<<:s :p :o>> :q2 :z2) )");
        this.testEncode(graph, 5, g -> G.getOnePO((Graph)g, (Node)q, (Node)z));
    }

    @Test
    public void rdfx_03() {
        Graph graph = TestRDFStarTranslation.data("(graph (<<:s :p :o>> :q :z) (:a :q <<:s :p :o>>) )");
        this.testEncode(graph, 5, g -> G.getOnePO((Graph)g, (Node)q, (Node)z));
    }

    @Test
    public void rdfx_04() {
        Graph graph = TestRDFStarTranslation.data("(graph (<<:s :p :o>> :q <<:s :p :o>>) (<<:s :p :o>> :q :z) )");
        this.testEncode(graph, 5, g -> G.getOnePO((Graph)g, (Node)q, (Node)z));
    }

    @Test
    public void rdfx_05() {
        Graph graph = TestRDFStarTranslation.data("(graph (<<:s :p :o>> :q <<:s1 :p1 :o1>>) (<<:s :p :o>> :q :z) )");
        this.testEncode(graph, 8, g -> G.getOnePO((Graph)g, (Node)q, (Node)z));
    }

    @Test
    public void rdfx_10() {
        this.testEncodeDecode("(graph (<<:s :p :o>> :q :z) (:s1 :p1 :o1) )");
    }

    @Test
    public void rdfx_11() {
        this.testEncodeDecode("(graph (<<:s :p :o>> :q :z) (<<:s :p :o>> :q2 :z2) )");
    }

    @Test
    public void rdfx_12() {
        this.testEncodeDecode("(graph (<<:s :p :o>> :q :z) (:a :q <<:s :p :o>>) )");
    }

    @Test
    public void rdfx_13() {
        this.testEncodeDecode("(graph (<<:s :p :o>> :q <<:s :p :o>>) (<<:s :p :o>> :q :z) )");
    }

    @Test
    public void rdfx_14() {
        this.testEncodeDecode("(graph (<<:s :p :o>> :q <<:s1 :p1 :o1>>) (<<:s :p :o>> :q :z) )");
    }

    @Test
    public void rdfx_15() {
        this.testEncodeDecode("(graph (<< <<:s :p :o>> :r :z>> :q :a) )");
    }

    @Test
    public void rdfx_18() {
        String data = StrUtils.strjoinNL((String[])new String[]{"(graph", "  (<<:s :p :o>> :q :z)", "  (<<:s :p :o>> :r <<:s :p :o>>)", "  (:a :q <<:s :p :o>>)", "  (:s :p :o)", ")"});
        this.testEncodeDecode(data);
    }

    @Test
    public void rdfx_19() {
        this.testEncodeDecode("(graph (<< <<:s :p :o>> :r <<:s1 :p1 :o1>>>> :q <<:s :p :o>>) )");
    }

    static Graph data(String dataStr) {
        Graph g = SSE.parseGraph((String)dataStr);
        g.getPrefixMapping().setNsPrefix("", "http://example/");
        g.getPrefixMapping().setNsPrefix("rdf", RDF.getURI());
        return g;
    }

    private void testEncodeDecode(String str) {
        Graph graph = TestRDFStarTranslation.data(str);
        Graph g1 = RDFStar.encodeRDFStar((Graph)graph);
        this.testNoTripleTerms(g1);
        Graph g2 = RDFStar.decodeRDFStar((Graph)g1);
        boolean b = TestRDFStarTranslation.isomorphic(graph, g2);
        if (!b) {
            System.out.println("-- Mismatch");
            RDFDataMgr.write((OutputStream)System.out, (Graph)graph, (RDFFormat)RDFFormat.TURTLE_BLOCKS);
            System.out.println("-- Encode");
            RDFDataMgr.write((OutputStream)System.out, (Graph)g1, (RDFFormat)RDFFormat.TURTLE_BLOCKS);
            System.out.println("-- Decode");
            RDFDataMgr.write((OutputStream)System.out, (Graph)g2, (RDFFormat)RDFFormat.TURTLE_BLOCKS);
            System.out.println("-----");
        }
        Assert.assertTrue((boolean)b);
    }

    private void testNoTripleTerms(Graph graph) {
        Assert.assertFalse((boolean)G.find((Graph)graph, null, null, null).filterKeep(RDFStar::tripleHasNodeTriple).hasNext());
    }

    private void testEncode(Graph graph, int expectedSize, Function<Graph, Node> getReif) {
        Graph g1 = RDFStar.encodeRDFStar((Graph)graph);
        this.testNoTripleTerms(g1);
        Assert.assertEquals((String)"Encoded", (long)expectedSize, (long)g1.size());
        Node reif = getReif.apply(g1);
        Assert.assertTrue((boolean)G.containsOne((Graph)g1, (Node)reif, (Node)rdfSubject, (Node)s));
        Assert.assertTrue((boolean)G.containsOne((Graph)g1, (Node)reif, (Node)rdfPredicate, (Node)p));
        Assert.assertTrue((boolean)G.containsOne((Graph)g1, (Node)reif, (Node)rdfObject, (Node)o));
    }

    private void testInPlace(String str) {
        Graph graph = TestRDFStarTranslation.data(str);
        Graph g1a = RDFStar.encodeRDFStar((Graph)graph);
        Graph g1 = RDFStar.encodeRDFStarInPlace((Graph)graph);
        Assert.assertSame((Object)graph, (Object)g1);
        this.testNoTripleTerms(g1);
        boolean b = TestRDFStarTranslation.isomorphic(g1, g1a);
        if (!b) {
            System.out.println("-- Mismatch");
            RDFDataMgr.write((OutputStream)System.out, (Graph)TestRDFStarTranslation.data(str), (RDFFormat)RDFFormat.TURTLE_BLOCKS);
            System.out.println("-- Encode");
            RDFDataMgr.write((OutputStream)System.out, (Graph)g1, (RDFFormat)RDFFormat.TURTLE_BLOCKS);
            System.out.println("-----");
        }
        Assert.assertTrue((boolean)b);
    }

    @Test
    public void rdfx_inplace_01() {
        this.testInPlace("(graph (<<:s :p :o>> :q :z) (:s1 :p1 :o1) )");
    }

    @Test
    public void rdfx_inplace_02() {
        this.testInPlace("(graph (<<:s :p :o>> :q :z) (<<:s :p :o>> :q2 :z2) )");
    }

    @Test
    public void rdfx_inplace_03() {
        this.testInPlace("(graph (<<:s :p :o>> :q :z) (:a :q <<:s :p :o>>) )");
    }

    @Test
    public void rdfx_inplace_04() {
        this.testInPlace("(graph (<<:s :p :o>> :q <<:s :p :o>>) (<<:s :p :o>> :q :z) )");
    }

    @Test
    public void rdfx_inplace_05() {
        this.testInPlace("(graph (<<:s :p :o>> :q <<:s1 :p1 :o1>>) (<<:s :p :o>> :q :z) )");
    }

    @Test
    public void rdfx_inplace_10() {
        this.testInPlace("(graph (<<:s :p :o>> :q :z) (:s1 :p1 :o1) )");
    }

    @Test
    public void rdfx_inplace_11() {
        this.testInPlace("(graph (<<:s :p :o>> :q :z) (<<:s :p :o>> :q2 :z2) )");
    }

    @Test
    public void rdfx_inplace_12() {
        this.testInPlace("(graph (<<:s :p :o>> :q :z) (:a :q <<:s :p :o>>) )");
    }

    @Test
    public void rdfx_inplace_13() {
        this.testInPlace("(graph (<<:s :p :o>> :q <<:s :p :o>>) (<<:s :p :o>> :q :z) )");
    }

    @Test
    public void rdfx_inplace_14() {
        this.testInPlace("(graph (<<:s :p :o>> :q <<:s1 :p1 :o1>>) (<<:s :p :o>> :q :z) )");
    }

    @Test
    public void rdfx_inplace_15() {
        this.testInPlace("(graph (<< <<:s :p :o>> :r :z>> :q :a) )");
    }

    @Test
    public void rdfx_inplace_18() {
        String data = StrUtils.strjoinNL((String[])new String[]{"(graph", "  (<<:s :p :o>> :q :z)", "  (<<:s :p :o>> :r <<:s :p :o>>)", "  (:a :q <<:s :p :o>>)", "  (:s :p :o)", ")"});
        this.testInPlace(data);
    }

    @Test
    public void rdfx_inplace_19() {
        this.testEncodeDecode("(graph (<< <<:s :p :o>> :r <<:s1 :p1 :o1>>>> :q <<:s :p :o>>) )");
    }
}

